/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.ExtraModels;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ElectricBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final Set<Connection> DRAWN_CONNECTIONS = new HashSet<Connection>();
    private static final int DEFAULT_COLOUR = -1;
    private static final int POWERED_COLOUR = -9652;
    private static final int CROSSING_ZONE_COLOUR = -3983818;
    private static final float POWER_NODE_SCALE = 1.5f;

    public ElectricBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(T node, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay) {
        ElectricBlockEntityRenderer.drawNodeAndConnections((IElectricityNode)node);
    }

    public static void drawNodeAndConnections(IElectricityNode node) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !LinkHandler.isHoldingWrench()) {
            return;
        }
        DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
        LinkHandler handler = LinkHandler.get();
        boolean isLookingAt = handler.isTargetNode(node);
        if (isLookingAt && !handler.isLinking() && !node.isNodeConnectionLimitReached() || handler.isLinkingNode(node) || handler.canLinkToNode(node.getNodeLevel(), node) && handler.isTargetNode(node)) {
            AABB box = node.getNodeInteractBox();
            int color = handler.getLinkColour(node.getNodeLevel());
            renderer.deferDraw((pose, consumer) -> {
                pose.m_85836_();
                BlockPos pos = node.getNodePosition();
                pose.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                Matrix4f matrix = pose.m_85850_().m_85861_();
                renderer.drawInvertedColouredBox(matrix, (VertexConsumer)consumer, box.m_82400_(0.03125), color, 0.7f);
                pose.m_85849_();
            });
        }
        for (Connection connection : node.getNodeConnections()) {
            if (DRAWN_CONNECTIONS.contains(connection)) continue;
            DRAWN_CONNECTIONS.add(connection);
            renderer.deferDraw((pose, consumer) -> {
                pose.m_85836_();
                BlockPos pos = node.getNodePosition();
                pose.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                pose.m_85837_(0.5, 0.5, 0.5);
                Vec3 delta = Vec3.m_82528_((Vec3i)connection.getPosB().m_121996_((Vec3i)connection.getPosA()));
                double yaw = Math.atan2(-delta.f_82481_, delta.f_82479_) + Math.PI;
                double pitch = Math.atan2(delta.m_165924_(), delta.f_82480_) + 1.5707963705062866;
                boolean selected = !handler.isLinking() && connection.equals(handler.getTargetConnection());
                int color = ElectricBlockEntityRenderer.getConnectionColour(connection, node.getNodeLevel());
                float offset = (float)(Math.sin((double)Util.m_137550_() / 500.0) + 1.0) / 2.0f * 0.2f;
                AABB box = new AABB(0.0, -0.03125, -0.03125, delta.m_82553_(), 0.03125, 0.03125);
                pose.m_85845_(Vector3f.f_122225_.m_122270_((float)yaw));
                pose.m_85845_(Vector3f.f_122227_.m_122270_((float)pitch));
                Matrix4f matrix = pose.m_85850_().m_85861_();
                renderer.drawColouredBox(matrix, (VertexConsumer)consumer, box, color, 0.7f + offset);
                renderer.drawColouredBox(matrix, (VertexConsumer)consumer, box.m_82400_(0.03125), color, 0.5f + offset);
                if (selected) {
                    renderer.drawColouredBox(matrix, (VertexConsumer)consumer, box.m_82400_(0.03125), -1, 0.8f);
                }
                pose.m_85849_();
            });
        }
        renderer.deferDraw((pose, consumer) -> {
            pose.m_85836_();
            BlockPos pos = node.getNodePosition();
            pose.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            Matrix4f matrix = pose.m_85850_().m_85861_();
            renderer.drawTexturedBox(matrix, (VertexConsumer)consumer, node.getNodeInteractBox(), 0.0f, 0.0f, 0.25f, 0.25f);
            pose.m_85849_();
        });
    }

    private static int getConnectionColour(Connection connection, Level level) {
        if (connection.isCrossingPowerableZone(level)) {
            return -3983818;
        }
        if (connection.isPowered(level)) {
            return -9652;
        }
        return -1;
    }

    private static BakedModel getNodeModel(IElectricityNode node) {
        if (node.isNodeConnectionLimitReached()) {
            return ExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        LinkHandler handler = LinkHandler.get();
        if (handler.isLinking() && !handler.isLinkingNode(node)) {
            if (handler.canLinkToNode(node.getNodeLevel(), node)) {
                return ExtraModels.ELECTRIC_NODE_SUCCESS.getModel();
            }
            return ExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        if (node.isNodePowered()) {
            return ExtraModels.ELECTRIC_NODE_NEUTRAL.getModel();
        }
        return ExtraModels.ELECTRIC_NODE_POWER.getModel();
    }

    public boolean m_5932_(T node) {
        return true;
    }

    public int m_142163_() {
        return (Integer)Config.CLIENT.electricityViewDistance.get();
    }

    public static void clearDrawn() {
        DRAWN_CONNECTIONS.clear();
    }

    public static Set<Connection> getDrawnConnections() {
        return DRAWN_CONNECTIONS;
    }
}

