/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.google.common.base.MoreObjects;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class ProcessingRecipe
implements Recipe<Container> {
    protected final RecipeType<?> type;
    protected final ResourceLocation id;
    protected final Category category;
    protected final Ingredient ingredient;
    protected final ItemStack result;
    protected final int time;

    protected ProcessingRecipe(RecipeType<?> type, ResourceLocation id, Category category, Ingredient ingredient, ItemStack result, int time) {
        this.type = type;
        this.id = id;
        this.category = category;
        this.ingredient = ingredient;
        this.result = result;
        this.time = time;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public Category getCategory() {
        return this.category;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.ingredient.test(container.m_8020_(0));
    }

    public ItemStack m_5874_(Container container) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getTime() {
        return this.time;
    }

    public static Builder builder(Category category, Ingredient input, ItemStack output, int processTime, Serializer<? extends ProcessingRecipe> serializer) {
        return new Builder(category, input, output, processTime, serializer);
    }

    public static enum Category implements StringRepresentable
    {
        BLOCKS("blocks"),
        ITEMS("items"),
        FOOD("food"),
        MISC("misc");

        public static final StringRepresentable.EnumCodec<Category> CODEC;
        private final String name;

        private Category(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public void toNetwork(FriendlyByteBuf buf) {
            buf.m_130072_(this.name, 6);
        }

        public static Category fromNetwork(FriendlyByteBuf buf) {
            return Category.byName(buf.m_130136_(6));
        }

        public static Category byName(String name) {
            return (Category)((Object)MoreObjects.firstNonNull((Object)((Object)((Category)CODEC.m_216455_(name))), (Object)((Object)MISC)));
        }

        static {
            CODEC = StringRepresentable.m_216439_(Category::values);
        }
    }

    public static class Builder
    implements RecipeBuilder {
        private final Category category;
        protected final Ingredient ingredient;
        protected final ItemStack result;
        protected final int time;
        protected final Serializer<? extends ProcessingRecipe> serializer;
        protected final Advancement.Builder advancement = Advancement.Builder.m_138353_();

        private Builder(Category category, Ingredient ingredient, ItemStack result, int time, Serializer<? extends ProcessingRecipe> serializer) {
            this.category = category;
            this.ingredient = ingredient;
            this.result = result;
            this.time = time;
            this.serializer = serializer;
        }

        public RecipeBuilder m_126132_(String name, CriterionTriggerInstance instance) {
            this.advancement.m_138386_(name, instance);
            return this;
        }

        public RecipeBuilder m_126145_(@Nullable String var1) {
            throw new UnsupportedOperationException("Group not supported for ProcessingRecipes");
        }

        public net.minecraft.world.item.Item m_142372_() {
            return this.result.m_41720_();
        }

        public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
            this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
            ResourceLocation advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + id.m_135815_());
            consumer.accept(new Result(id, this.category, this.ingredient, this.result, this.time, this.serializer, this.advancement, advancementId));
        }
    }

    public static abstract class Serializer<T extends ProcessingRecipe>
    implements RecipeSerializer<T> {
        protected final Factory<T> factory;
        protected final int defaultTime;

        public Serializer(Factory<T> factory, int defaultTime) {
            this.factory = factory;
            this.defaultTime = defaultTime;
        }

        public abstract void toJson(JsonObject var1, Result var2);

        public T fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Category category = Category.fromNetwork(buf);
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack result = buf.m_130267_();
            int time = buf.m_130242_();
            return this.factory.create(id, category, ingredient, result, time);
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            ((ProcessingRecipe)recipe).category.toNetwork(buf);
            ((ProcessingRecipe)recipe).ingredient.m_43923_(buf);
            buf.m_130055_(((ProcessingRecipe)recipe).result);
            buf.m_130130_(((ProcessingRecipe)recipe).time);
        }
    }

    public static abstract class ItemWithCount
    extends ProcessingRecipe {
        protected ItemWithCount(RecipeType<?> type, ResourceLocation id, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, id, category, ingredient, result, time);
        }

        public static class Serializer<T extends ProcessingRecipe>
        extends com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe$Serializer<T> {
            public Serializer(Factory<T> factory, int defaultTime) {
                super(factory, defaultTime);
            }

            @Override
            public void toJson(JsonObject object, Result result) {
                object.addProperty("category", result.category.m_7912_());
                object.add("ingredient", result.ingredient.m_43942_());
                String id = Registry.f_122827_.m_7981_((Object)result.result.m_41720_()).toString();
                int count = result.result.m_41613_();
                if (count == 1) {
                    object.addProperty("result", id);
                } else {
                    JsonObject itemObject = new JsonObject();
                    itemObject.addProperty("item", id);
                    itemObject.addProperty("count", (Number)count);
                    object.add("result", (JsonElement)itemObject);
                }
                object.addProperty("time", (Number)result.time);
            }

            public T fromJson(ResourceLocation id, JsonObject object) {
                Category category = Category.byName(GsonHelper.m_13851_((JsonObject)object, (String)"category", (String)"misc"));
                Ingredient input = Utils.getIngredient(object, "ingredient");
                ItemStack output = Utils.getItemStack(object, "result");
                int processTime = GsonHelper.m_13824_((JsonObject)object, (String)"time", (int)this.defaultTime);
                return this.factory.create(id, category, input, output, processTime);
            }
        }
    }

    public static abstract class Item
    extends ProcessingRecipe {
        protected Item(RecipeType<?> type, ResourceLocation id, Category category, Ingredient ingredient, ItemStack result, int time) {
            super(type, id, category, ingredient, result, time);
        }

        public static ProcessingRecipe from(final AbstractCookingRecipe recipe) {
            return new ProcessingRecipe(recipe.m_6671_(), recipe.m_6423_(), Category.FOOD, (Ingredient)recipe.m_7527_().get(0), recipe.m_8043_(), recipe.m_43753_()){

                public RecipeSerializer<?> m_7707_() {
                    return recipe.m_7707_();
                }
            };
        }

        public static class Serializer<T extends ProcessingRecipe>
        extends com.mrcrayfish.furniture.refurbished.crafting.ProcessingRecipe$Serializer<T> {
            public Serializer(Factory<T> factory, int defaultTime) {
                super(factory, defaultTime);
            }

            @Override
            public void toJson(JsonObject object, Result result) {
                String id = Registry.f_122827_.m_7981_((Object)result.result.m_41720_()).toString();
                object.addProperty("category", result.category.m_7912_());
                object.add("ingredient", result.ingredient.m_43942_());
                object.addProperty("result", id);
                object.addProperty("time", (Number)result.time);
            }

            public T fromJson(ResourceLocation id, JsonObject object) {
                Category category = Category.byName(GsonHelper.m_13851_((JsonObject)object, (String)"category", (String)"misc"));
                Ingredient ingredient = Utils.getIngredient(object, "ingredient");
                ResourceLocation resultId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"result"));
                net.minecraft.world.item.Item item = (net.minecraft.world.item.Item)Registry.f_122827_.m_6612_(resultId).orElseThrow(() -> new IllegalStateException("The item '%s' does not exist".formatted(resultId)));
                int time = GsonHelper.m_13824_((JsonObject)object, (String)"time", (int)this.defaultTime);
                return this.factory.create(id, category, ingredient, new ItemStack((ItemLike)item), time);
            }
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Category category;
        private final Ingredient ingredient;
        private final ItemStack result;
        private final int time;
        private final Serializer<? extends ProcessingRecipe> serializer;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, Category category, Ingredient ingredient, ItemStack result, int time, Serializer<? extends ProcessingRecipe> serializer, Advancement.Builder advancement, ResourceLocation advancementId) {
            this.id = id;
            this.category = category;
            this.ingredient = ingredient;
            this.result = result;
            this.time = time;
            this.serializer = serializer;
            this.advancement = advancement;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject object) {
            this.serializer.toJson(object, this);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }

    public static interface Factory<T extends ProcessingRecipe> {
        public T create(ResourceLocation var1, Category var2, Ingredient var3, ItemStack var4, int var5);
    }
}

