/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.block.FurnitureAttachedFaceBlock;
import com.mrcrayfish.furniture.refurbished.block.MetalType;
import com.mrcrayfish.furniture.refurbished.blockentity.LightswitchBlockEntity;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.data.DropWithName;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_6862;

public class LightswitchBlock
extends FurnitureAttachedFaceBlock
implements class_2343,
BlockTagSupplier,
DropWithName {
    public static final class_2746 ENABLED = class_2741.field_12515;
    public static final class_2746 POWERED = class_2741.field_12484;
    protected final MetalType type;

    public LightswitchBlock(MetalType type, class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public MetalType getMetalType() {
        return this.type;
    }

    @Override
    protected Map<class_2680, class_265> generateShapes(ImmutableList<class_2680> states) {
        class_265 wallShape = class_2248.method_9541((double)14.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
        class_265 ceilingShape = class_2248.method_9541((double)4.0, (double)14.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
        class_265 floorShape = class_2248.method_9541((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)2.0, (double)11.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
            class_2738 face = (class_2738)state.method_11654((class_2769)field_11007);
            return switch (face) {
                default -> throw new IncompatibleClassChangeError();
                case class_2738.field_12475 -> VoxelShapeHelper.rotateHorizontally(floorShape, facing.method_10153());
                case class_2738.field_12471 -> VoxelShapeHelper.rotateHorizontally(wallShape, facing.method_10153());
                case class_2738.field_12473 -> VoxelShapeHelper.rotateHorizontally(ceilingShape, facing.method_10153());
            };
        })));
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 result) {
        boolean enabled = (Boolean)state.method_11654((class_2769)ENABLED) == false;
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)ENABLED, (Comparable)Boolean.valueOf(enabled)), 3);
        class_243 sound = this.getPositionForSound(state, pos);
        level.method_43128(null, sound.field_1352, sound.field_1351, sound.field_1350, (class_3414)ModSounds.BLOCK_LIGHTSWITCH_FLICK.get(), class_3419.field_15245, 0.7f, enabled ? 1.0f : 0.8f);
        return class_1269.method_29236((boolean)level.method_8608());
    }

    private class_243 getPositionForSound(class_2680 state, class_2338 pos) {
        class_243 center = class_243.method_24953((class_2382)pos);
        class_2738 face = (class_2738)state.method_11654((class_2769)field_11007);
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2738.field_12475 -> center.method_1023(0.0, 0.5, 0.0);
            case class_2738.field_12473 -> center.method_1031(0.0, 0.5, 0.0);
            case class_2738.field_12471 -> {
                class_2350 dir = ((class_2350)state.method_11654((class_2769)field_11177)).method_10153();
                yield center.method_1031((double)dir.method_10148() * 0.5, 0.0, (double)dir.method_10165() * 0.5);
            }
        };
    }

    @Override
    public boolean method_9498(class_2680 state) {
        return true;
    }

    @Override
    public int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)ENABLED) != false ? 1 : 0;
    }

    @Override
    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        super.method_9536(state, level, pos, newState, isMoving);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{ENABLED});
        builder.method_11667(new class_2769[]{POWERED});
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        class_2586 class_25862;
        if (stack.method_7938() && (class_25862 = level.method_8321(pos)) instanceof LightswitchBlockEntity) {
            LightswitchBlockEntity light = (LightswitchBlockEntity)class_25862;
            light.setCustomName(stack.method_7964());
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new LightswitchBlockEntity(pos, state);
    }

    @Override
    public List<class_6862<class_2248>> getTags() {
        return List.of(class_3481.field_33715);
    }
}

