/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.block.CeilingFanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModDamageTypes;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class CeilingFanBlockEntity
extends ElectricityModuleBlockEntity
implements ILevelAudio {
    private static final float MAX_SPEED = 50.0f;
    private static final float ACCELERATION = 1.25f;
    private static final float RESISTANCE = 0.98f;
    private static final class_238[] DAMAGE_BOXES = (class_238[])class_156.method_656(() -> {
        class_238[] boxes = new class_238[class_2350.values().length];
        boxes[class_2350.field_11036.method_10146()] = new class_238(-0.625, 0.5, -0.625, 1.625, 0.625, 1.625);
        boxes[class_2350.field_11033.method_10146()] = new class_238(-0.625, 0.375, -0.625, 1.625, 0.5, 1.625);
        boxes[class_2350.field_11043.method_10146()] = new class_238(-0.625, -0.625, 0.375, 1.625, 1.625, 0.5);
        boxes[class_2350.field_11034.method_10146()] = new class_238(0.5, -0.625, -0.625, 0.625, 1.625, 1.625);
        boxes[class_2350.field_11035.method_10146()] = new class_238(-0.625, -0.625, 0.5, 1.625, 1.625, 0.625);
        boxes[class_2350.field_11039.method_10146()] = new class_238(0.375, -0.625, -0.625, 0.5, 1.625, 1.625);
        return boxes;
    });
    protected final class_243 audioPosition;
    private float bladeSpeed;
    private float bladeRotation;
    private float lastBladeRotation;

    public CeilingFanBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)ModBlockEntities.CEILING_FAN.get(), pos, state);
        this.audioPosition = class_243.method_24953((class_2382)pos).method_1031(0.0, 0.375, 0.0);
    }

    @Override
    public boolean isNodePowered() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)class_2741.field_12484) && (Boolean)state.method_11654((class_2769)class_2741.field_12484) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)class_2741.field_12484)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    private void updateAnimation() {
        this.lastBladeRotation = this.bladeRotation;
        if (this.isNodePowered()) {
            this.bladeSpeed = Math.min(this.bladeSpeed + 1.25f, 50.0f);
        }
        this.bladeSpeed *= 0.98f;
        this.bladeRotation += this.bladeSpeed;
        if (this.bladeRotation > 360.0f) {
            this.bladeRotation -= 360.0f;
            this.lastBladeRotation -= 360.0f;
        }
    }

    public float getRotation(float partialTick) {
        return class_3532.method_16439((float)partialTick, (float)this.lastBladeRotation, (float)this.bladeRotation);
    }

    private void performDamage(class_1937 level) {
        if (this.isNodePowered()) {
            class_2350 direction = this.getDirection();
            class_238 box = this.getDamageBox(direction).method_996(this.method_11016());
            List entities = level.method_18467(class_1309.class, box);
            entities.forEach(entity -> {
                entity.method_5643(ModDamageTypes.CEILING_FAN, 0.5f);
                entity.method_6015(entity);
            });
        }
    }

    public class_238 getDamageBox(class_2350 direction) {
        return DAMAGE_BOXES[direction.method_10146()];
    }

    public class_2350 getDirection() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)CeilingFanBlock.FACING)) {
            return (class_2350)state.method_11654((class_2769)CeilingFanBlock.FACING);
        }
        return class_2350.field_11043;
    }

    @Override
    public void moduleTick(class_1937 level) {
        super.moduleTick(level);
        if (!level.field_9236) {
            this.performDamage(level);
        } else {
            this.updateAnimation();
            AudioManager.get().playLevelAudio(this);
        }
    }

    @Override
    public class_3414 getSound() {
        return (class_3414)ModSounds.BLOCK_CEILING_FAN_SPIN.get();
    }

    @Override
    public class_3419 getSource() {
        return class_3419.field_15245;
    }

    @Override
    public class_243 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.bladeSpeed > 5.0f && !this.method_11015();
    }

    @Override
    public float getAudioVolume() {
        return this.bladeSpeed / 50.0f;
    }

    @Override
    public float getAudioPitch() {
        return 0.5f + this.bladeSpeed / 50.0f;
    }

    @Override
    public int getAudioHash() {
        return this.field_11867.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return this == other;
    }

    @Override
    public double getAudioRadiusSqr() {
        return 16.0;
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level.method_8608() && this.isNodePowered()) {
            this.bladeSpeed = 50.0f;
        }
    }
}

