/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IComputer;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.ComputerMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageComputerState;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_747;
import org.jetbrains.annotations.Nullable;

public class ComputerBlockEntity
extends ElectricityModuleBlockEntity
implements IComputer {
    public static final int DATA_POWERED = 0;
    public static final int DATA_SYSTEM = 1;
    public static final int DATA_PROGRAM_1 = 2;
    public static final int DATA_PROGRAM_2 = 3;
    protected int systemData;
    protected int programData1;
    protected int programData2;
    protected Program currentProgram;
    @Nullable
    protected class_1657 currentUser;
    protected final class_3913 data = new BuildableContainerData(builder -> {
        builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {});
        builder.add(1, () -> this.systemData, value -> {});
        builder.add(2, () -> this.programData1, value -> {
            this.programData1 = value;
        });
        builder.add(3, () -> this.programData2, value -> {
            this.programData2 = value;
        });
    });

    public ComputerBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.COMPUTER.get(), pos, state);
    }

    public ComputerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public class_2338 getComputerPos() {
        return this.field_11867;
    }

    @Override
    public void setUser(@Nullable class_1657 player) {
        this.currentUser = player;
    }

    @Override
    @Nullable
    public class_1657 getUser() {
        if (this.currentUser != null && (!this.currentUser.method_5805() || this.currentUser.method_31481())) {
            this.currentUser = null;
        }
        return this.currentUser;
    }

    @Override
    @Nullable
    public Program getProgram() {
        return this.currentProgram;
    }

    @Override
    @Nullable
    public ComputerMenu getMenu() {
        ComputerMenu menu;
        class_1703 class_17032;
        class_1657 player = this.getUser();
        if (player != null && (class_17032 = player.field_7512) instanceof ComputerMenu && (menu = (ComputerMenu)class_17032).getComputer() == this) {
            return menu;
        }
        return null;
    }

    @Override
    public boolean isServer() {
        return this.field_11863 != null && !this.field_11863.method_8608();
    }

    @Override
    public boolean isValid(class_1657 player) {
        return this.isNodePowered() && Utils.isInInteractableRange(this, player) && player.equals((Object)this.getUser());
    }

    @Override
    public boolean isNodePowered() {
        class_2680 state = this.method_11010();
        return state.method_28498((class_2769)class_2741.field_12484) && (Boolean)state.method_11654((class_2769)class_2741.field_12484) != false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)class_2741.field_12484)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    public class_3908 createMenuProvider() {
        return new class_747((windowId, playerInventory, player1) -> new ComputerMenu(windowId, playerInventory, this.data, this), (class_2561)Utils.translation("container", "computer", new Object[0]));
    }

    public boolean isBeingUsed() {
        ComputerMenu menu;
        class_1703 class_17032;
        return this.currentUser != null && this.currentUser.method_5805() && (class_17032 = this.currentUser.field_7512) instanceof ComputerMenu && this.currentUser.equals((Object)(menu = (ComputerMenu)class_17032).getComputer().getUser());
    }

    @Override
    public void launchProgram(@Nullable class_2960 id) {
        if (id == null) {
            if (this.currentProgram != null) {
                this.currentProgram.onClose(true);
            }
            this.currentProgram = null;
            this.syncStateToCurrentUser();
            return;
        }
        if (this.currentProgram != null && this.currentProgram.getId().equals((Object)id)) {
            return;
        }
        Computer.get().createProgramInstance(id, this).ifPresent(program -> {
            this.currentProgram = program;
            this.syncStateToCurrentUser();
        });
    }

    public void syncStateToCurrentUser() {
        class_1657 class_16572 = this.getUser();
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            this.syncStateToPlayer((class_1657)player);
        }
    }

    public void syncStateToPlayer(class_1657 player) {
        class_2960 programId = this.currentProgram != null ? this.currentProgram.getId() : null;
        Network.getPlay().sendToPlayer(() -> (class_3222)player, (IMessage)new MessageComputerState(this.field_11867, programId));
    }

    private void tickProgram() {
        if (this.currentProgram != null) {
            this.currentProgram.tick();
        }
    }

    @Override
    public void moduleTick(class_1937 level) {
        super.moduleTick(level);
        if (!level.field_9236) {
            this.tickProgram();
        }
    }

    private void setPowerState(boolean powered) {
        this.systemData |= powered ? 1 : 0;
    }

    private void setStartupTime(int time) {
        this.systemData |= time << 16;
    }
}

