/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.block.WorkbenchBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IWorkbench;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3915;

public class WorkbenchBlockEntity
extends ElectricityModuleLootBlockEntity
implements IWorkbench {
    public static final int DATA_POWERED = 0;
    @Nullable
    protected class_1657 currentUser;
    protected int updateTimer;
    protected int countsHash;
    protected final class_3915 selectedRecipe = class_3915.method_17403();
    protected final class_3915 searchNeighbours = class_3915.method_17403();
    protected final class_3913 data = new BuildableContainerData(builder -> builder.add(0, () -> this.isNodePowered() ? 1 : 0, value -> {}));

    public WorkbenchBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.WORKBENCH.get(), pos, state);
    }

    public WorkbenchBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 12);
        this.selectedRecipe.method_17404(-1);
        this.searchNeighbours.method_17404(1);
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        return menu instanceof WorkbenchMenu;
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "workbench", new Object[0]);
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        return new WorkbenchMenu(windowId, playerInventory, this, this.data);
    }

    public void writeMenuData(class_2540 buffer) {
        buffer.method_10804(this.selectedRecipe.method_17407());
        buffer.method_10804(this.searchNeighbours.method_17407());
        buffer.method_10804(this.isNodePowered() ? 1 : 0);
    }

    @Override
    public boolean isNodePowered() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)WorkbenchBlock.POWERED)) {
            return (Boolean)state.method_11654((class_2769)WorkbenchBlock.POWERED);
        }
        return false;
    }

    @Override
    public void setNodePowered(boolean powered) {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)WorkbenchBlock.POWERED)) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)WorkbenchBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        }
    }

    @Override
    public void method_5435(class_1657 player) {
        super.method_5435(player);
        this.setUser(player);
    }

    @Override
    public void method_5432(class_1657 player) {
        super.method_5432(player);
        this.setUser(null);
    }

    public boolean isOccupied() {
        return this.getUser() != null;
    }

    @Nullable
    public class_1657 getUser() {
        WorkbenchMenu menu;
        class_1703 class_17032;
        if (this.currentUser != null && this.currentUser.method_5805() && (class_17032 = this.currentUser.field_7512) instanceof WorkbenchMenu && (menu = (WorkbenchMenu)class_17032).getContainer() == this) {
            return this.currentUser;
        }
        return null;
    }

    public void setUser(@Nullable class_1657 player) {
        if (!this.isOccupied() || player == null) {
            this.currentUser = player;
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, WorkbenchBlockEntity workbench) {
        workbench.sendCountsToUser(false);
    }

    public void sendCountsToUser(boolean force) {
        class_1657 player = this.getUser();
        if (player != null && (this.updateTimer++ % 4 == 0 || force)) {
            Map<class_1792, Integer> newCounts = Utils.countItems(true, this.getSupplyContainers());
            int hash = newCounts.hashCode();
            if (hash == this.countsHash && !force) {
                return;
            }
            this.countsHash = hash;
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            for (Map.Entry<class_1792, Integer> entry : newCounts.entrySet()) {
                map.put(class_1792.method_7880((class_1792)entry.getKey()), entry.getValue());
            }
            ((WorkbenchMenu)player.field_7512).updateItemCounts((Map<Integer, Integer>)map);
            Network.getPlay().sendToPlayer(() -> (class_3222)player, (IMessage)new MessageWorkbench.ItemCounts((Map<Integer, Integer>)map));
        }
    }

    @Override
    public void performCraft(WorkbenchContructingRecipe recipe) {
        Map<class_1792, Integer> items = this.getConsumedMaterialItems(recipe);
        if (items != null) {
            this.removeItems(items);
        }
    }

    @Override
    public boolean canCraft(WorkbenchContructingRecipe recipe) {
        return this.isNodePowered() && this.getConsumedMaterialItems(recipe) != null;
    }

    @Override
    public class_3915 selectedRecipeDataSlot() {
        return this.selectedRecipe;
    }

    @Override
    public class_3915 searchNeighboursDataSlot() {
        return this.searchNeighbours;
    }

    @Override
    public class_1263 getWorkbenchContainer() {
        return this;
    }

    @Override
    public class_3914 createLevelAccess() {
        return class_3914.method_17392((class_1937)Objects.requireNonNull(this.field_11863), (class_2338)this.field_11867);
    }

    protected boolean shouldSearchNeighbours() {
        return this.searchNeighbours.method_17407() != 0;
    }

    @Nullable
    private Map<class_1792, Integer> getConsumedMaterialItems(WorkbenchContructingRecipe recipe) {
        Map<class_1792, Integer> counts = Utils.countItems(true, this.getSupplyContainers());
        HashMap<class_1792, Integer> materials = new HashMap<class_1792, Integer>();
        for (StackedIngredient material : recipe.getMaterials()) {
            int remaining = material.count();
            for (class_1799 stack : material.ingredient().method_8105()) {
                class_1792 item = stack.method_7909();
                int count = counts.getOrDefault(item, 0);
                if ((count -= materials.getOrDefault(item, 0).intValue()) <= 0) continue;
                if (count >= remaining) {
                    materials.merge(item, remaining, Integer::sum);
                    remaining = 0;
                    break;
                }
                materials.merge(item, count, Integer::sum);
                remaining -= count;
            }
            if (remaining <= 0) continue;
            return null;
        }
        return materials;
    }

    private boolean removeItems(Map<class_1792, Integer> items) {
        ArrayList transactions = new ArrayList();
        for (Pair<class_2350, class_1263> pair2 : this.getSupplyContainers()) {
            class_2350 direction = (class_2350)pair2.first();
            class_1263 container = (class_1263)pair2.second();
            Utils.getContainerSlots(container, direction).forEach(slot -> {
                class_1799 stack = container.method_5438(slot);
                if (stack.method_7960() || stack.method_7986()) {
                    return;
                }
                if (!Utils.canTakeFromContainer(container, slot, stack, direction)) {
                    return;
                }
                class_1792 item = stack.method_7909();
                Integer count = (Integer)items.get(item);
                if (count != null) {
                    if (stack.method_7947() < count) {
                        count = count - stack.method_7947();
                        items.put(item, count);
                        transactions.add(Pair.of((Object)container, () -> stack.method_7939(0)));
                    } else {
                        Integer finalCount = count;
                        transactions.add(Pair.of((Object)container, () -> stack.method_7934(finalCount.intValue())));
                        items.remove(item);
                    }
                }
            });
        }
        if (items.isEmpty()) {
            transactions.forEach(pair -> {
                ((Runnable)pair.right()).run();
                ((class_1263)pair.left()).method_5431();
            });
            return true;
        }
        return false;
    }

    private List<Pair<class_2350, class_1263>> getSupplyContainers() {
        ArrayList<Pair<class_2350, class_1263>> list = new ArrayList<Pair<class_2350, class_1263>>();
        list.add(Pair.of(null, (Object)this));
        if (this.shouldSearchNeighbours()) {
            class_2350 direction = this.getDirection();
            this.getContainer(direction).ifPresent(list::add);
            this.getContainer(direction.method_10153()).ifPresent(list::add);
            this.getContainer(direction.method_10160()).ifPresent(list::add);
            this.getContainer(direction.method_10170()).ifPresent(list::add);
        }
        Optional.ofNullable(this.getUser()).ifPresent(player -> list.add(Pair.of(null, (Object)player.method_31548())));
        return list;
    }

    private Optional<Pair<class_2350, class_1263>> getContainer(class_2350 offset) {
        class_2338 pos;
        class_2586 class_25862;
        if (this.field_11863 != null && (class_25862 = this.field_11863.method_8321(pos = this.field_11867.method_10093(offset))) instanceof class_1263) {
            class_1263 container = (class_1263)class_25862;
            class_2680 state = this.field_11863.method_8320(pos);
            class_2248 block = state.method_26204();
            if (container instanceof class_2595 && block instanceof class_2281) {
                container = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)state, (class_1937)this.field_11863, (class_2338)pos, (boolean)true);
            }
            if (container != null) {
                return Optional.of(Pair.of((Object)offset.method_10153(), (Object)container));
            }
        }
        return Optional.empty();
    }

    private class_2350 getDirection() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)class_2741.field_12481)) {
            return (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        }
        return class_2350.field_11043;
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        if (tag.method_10573("SelectedRecipe", 3)) {
            this.selectedRecipe.method_17404(tag.method_10550("SelectedRecipe"));
        }
        if (tag.method_10573("IncludeNeighbours", 1)) {
            this.searchNeighbours.method_17404(tag.method_10577("IncludeNeighbours") ? 1 : 0);
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("SelectedRecipe", this.selectedRecipe.method_17407());
        tag.method_10556("IncludeNeighbours", this.searchNeighbours.method_17407() != 0);
    }
}

