/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.OnOffSlider;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.ElectricityGeneratorMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageTogglePower;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;

public class ElectricityGeneratorScreen
extends class_465<ElectricityGeneratorMenu> {
    private static final class_2960 TEXTURE = Utils.resource("textures/gui/container/electricity_generator.png");
    protected OnOffSlider slider;

    public ElectricityGeneratorScreen(ElectricityGeneratorMenu menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
    }

    protected void method_25426() {
        super.method_25426();
        this.slider = (OnOffSlider)this.method_37063((class_364)new OnOffSlider(this.field_2776 + this.field_2792 - 22 - 6, this.field_2800 + 5, (class_2561)Utils.translation("gui", "generator_toggle", new Object[0]), btn -> Network.getPlay().sendToServer((IMessage)new MessageTogglePower())));
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.slider.setEnabled(((ElectricityGeneratorMenu)this.field_2797).isEnabled());
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.method_2380(poseStack, mouseX, mouseY);
    }

    protected void method_2389(class_4587 poseStack, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        this.method_25302(poseStack, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        if (((ElectricityGeneratorMenu)this.field_2797).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy() > 0) {
            float normalEnergy = (float)((ElectricityGeneratorMenu)this.field_2797).getEnergy() / (float)((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy();
            int v = (int)Math.ceil(14.0f * normalEnergy);
            this.method_25302(poseStack, this.field_2776 + 26, this.field_2800 + 25 + 14 - v, 176, 14 - v, 14, v);
        }
        Status status = this.getStatus();
        RenderSystem.setShaderTexture((int)0, (class_2960)IconButton.ICON_TEXTURES);
        class_332.method_25290((class_4587)poseStack, (int)(this.field_2776 + 66), (int)(this.field_2800 + 29), (float)status.iconU, (float)status.iconV, (int)10, (int)10, (int)64, (int)64);
        class_332.method_25290((class_4587)poseStack, (int)(this.field_2776 + 66), (int)(this.field_2800 + 46), (float)0.0f, (float)10.0f, (int)10, (int)10, (int)64, (int)64);
    }

    protected void method_2380(class_4587 poseStack, int mouseX, int mouseY) {
        if (((ElectricityGeneratorMenu)this.field_2797).getEnergy() > 0 && ((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy() > 0 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.field_2776 + 26, this.field_2800 + 25, 14, 14)) {
            this.method_25424(poseStack, (class_2561)Utils.translation("gui", "progress", ((ElectricityGeneratorMenu)this.field_2797).getEnergy(), Components.GUI_SLASH, ((ElectricityGeneratorMenu)this.field_2797).getTotalEnergy()), mouseX, mouseY);
            return;
        }
        super.method_2380(poseStack, mouseX, mouseY);
    }

    protected void method_2388(class_4587 poseStack, int mouseX, int mouseY) {
        super.method_2388(poseStack, mouseX, mouseY);
        Status status = this.getStatus();
        ScreenHelper.drawString(poseStack, status.label, 80, 30, status.textColour, true);
        Pair<class_2561, Integer> pair = this.getNodeCount();
        ScreenHelper.drawString(poseStack, (class_2561)pair.left(), 80, 47, (int)((Integer)pair.right()), true);
    }

    private Pair<class_2561, Integer> getNodeCount() {
        int nodeCount = ((ElectricityGeneratorMenu)this.field_2797).getNodeCount();
        int maxNodeCount = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
        class_5250 label = Utils.translation("gui", "node_count", nodeCount, maxNodeCount);
        int textColour = nodeCount > maxNodeCount ? -3983818 : -1;
        return Pair.of((Object)label, (Object)textColour);
    }

    private Status getStatus() {
        if (((ElectricityGeneratorMenu)this.field_2797).isOverloaded()) {
            return Status.OVERLOADED;
        }
        if (((ElectricityGeneratorMenu)this.field_2797).isEnabled()) {
            if (((ElectricityGeneratorMenu)this.field_2797).isPowered()) {
                return Status.ONLINE;
            }
            if (((ElectricityGeneratorMenu)this.field_2797).getEnergy() == 0) {
                return Status.NO_FUEL;
            }
        }
        return Status.OFFLINE;
    }

    private static enum Status {
        ONLINE(-8799453, 50, 0, (class_2561)Utils.translation("gui", "status.online", new Object[0])),
        OFFLINE(-3983818, 40, 0, (class_2561)Utils.translation("gui", "status.offline", new Object[0])),
        OVERLOADED(-2711764, 30, 0, (class_2561)Utils.translation("gui", "status.overloaded", new Object[0])),
        NO_FUEL(-2711764, 10, 10, (class_2561)Utils.translation("gui", "status.no_fuel", new Object[0]));

        private final int textColour;
        private final int iconU;
        private final int iconV;
        private final class_2561 label;

        private Status(int textColour, int iconU, int iconV, class_2561 label) {
            this.textColour = textColour;
            this.iconU = iconU;
            this.iconV = iconV;
            this.label = label;
        }
    }
}

