/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.PostBoxMenu;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSendPackage;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2703;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7529;
import net.minecraft.class_7532;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PostBoxScreen
extends class_465<PostBoxMenu> {
    private static final class_2561 MAILBOXES_LABEL = Utils.translation("gui", "mailboxes", new Object[0]);
    private static final class_5250 DEFAULT_MAILBOX_NAME = Utils.translation("gui", "default_mailbox_name", new Object[0]);
    private static final class_5250 UNKNOWN_MAILBOX_OWNER = Utils.translation("gui", "unknown_mailbox_owner", new Object[0]);
    private static final class_2960 POST_BOX_TEXTURE = Utils.resource("textures/gui/container/post_box.png");
    private static final class_2960 VILLAGER_TEXTURE = new class_2960("textures/gui/container/villager2.png");
    private static final Map<UUID, class_640> PLAYER_INFO_CACHE = new HashMap<UUID, class_640>();
    private static final int SCROLL_SPEED = 5;
    private static final int SCROLL_BAR_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 27;
    private static final int MAILBOX_ENTRY_WIDTH = 85;
    private static final int MAILBOX_ENTRY_HEIGHT = 14;
    private static final int CONTAINER_LEFT = 8;
    private static final int CONTAINER_TOP = 34;
    private static final int CONTAINER_HEIGHT = 130;
    private static final int CONTAINER_WIDTH = 85;
    private static final int MAX_VISIBLE_ITEMS = class_3532.method_15384((double)9.285714285714286) + 1;
    private static final int MAX_RESPONSE_DISPLAY_TIME = 100;
    protected List<IMailbox> mailboxes = new ArrayList<IMailbox>();
    protected IMailbox selected;
    protected class_342 searchEditBox;
    protected String query = "";
    protected class_7529 messageEditBox;
    protected class_4185 sendButton;
    protected String message = "";
    protected int scroll;
    protected int clickedY = -1;
    protected List<class_5481> tooltip;
    @Nullable
    protected String responseTranslationKey;
    protected boolean responseSuccess;
    protected int responseTimer;

    public PostBoxScreen(PostBoxMenu menu, class_1661 playerInventory, class_2561 title) {
        super((class_1703)menu, playerInventory, (class_2561)class_2561.method_43473());
        this.field_2792 = 283;
        this.field_2779 = 172;
        this.field_25269 = 113;
        this.field_25270 = this.field_2779 - 93;
        this.updateSearchFilter();
    }

    protected void method_25426() {
        super.method_25426();
        this.searchEditBox = new class_342(this.field_22793, this.field_2776 + 8, this.field_2800 + 18, 92, 12, (class_2561)Utils.translation("gui", "search_mailboxes", new Object[0]));
        this.method_37063((class_364)this.searchEditBox);
        this.searchEditBox.method_1852("");
        this.searchEditBox.method_1863(s -> {
            this.query = s;
            this.updateSearchFilter();
            this.scroll(0);
        });
        if (!this.query.isBlank()) {
            this.searchEditBox.method_1852(this.query);
        }
        this.messageEditBox = new class_7529(this.field_22793, this.field_2776 + 118, this.field_2800 + 13, 116, 54, (class_2561)Utils.translation("gui", "enter_message", new Object[0]), (class_2561)Utils.translation("gui", "package_message", new Object[0])){

            protected void method_44384(class_4587 poseStack) {
            }

            protected boolean method_44392() {
                return false;
            }
        };
        this.method_37063((class_364)this.messageEditBox);
        if (!this.message.isBlank()) {
            this.messageEditBox.method_44400(this.message);
        } else {
            this.messageEditBox.method_44400("");
        }
        this.messageEditBox.method_44401(s -> {
            this.message = s;
        });
        this.sendButton = new IconButton(this.field_2776 + 284, this.field_2800 + 22, 20, 0, 18, 18, class_5244.field_39003, btn -> {
            if (this.selected != null) {
                Network.getPlay().sendToServer((IMessage)new MessageSendPackage(this.selected.getId(), this.message));
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
            }
        }, (btn, poseStack, mouseX, mouseY) -> this.method_25424(poseStack, (class_2561)Utils.translation("gui", "send", new Object[0]), mouseX, mouseY));
        this.method_37063((class_364)this.sendButton);
    }

    protected void method_37432() {
        this.searchEditBox.method_1865();
        this.messageEditBox.method_44406();
        if (this.responseTranslationKey != null) {
            ++this.responseTimer;
            if (this.responseTimer == 100) {
                this.responseTranslationKey = null;
            }
        }
    }

    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.searchEditBox.method_1887(this.searchEditBox.method_1882().isBlank() ? Utils.translation("gui", "search", new Object[0]).getString() : "");
        this.sendButton.field_22763 = this.selected != null && !((PostBoxMenu)this.field_2797).getContainer().method_5442();
        this.searchEditBox.method_1868(this.searchEditBox.method_1882().isEmpty() && !this.searchEditBox.method_25370() ? 0x707070 : 0xE0E0E0);
        this.method_25420(poseStack);
        super.method_25394(poseStack, mouseX, mouseY, partialTick);
        this.method_2380(poseStack, mouseX, mouseY);
    }

    protected void method_2388(class_4587 poseStack, int mouseX, int mouseY) {
        super.method_2388(poseStack, mouseX, mouseY);
        ScreenHelper.drawString(poseStack, MAILBOXES_LABEL, this.field_25267, this.field_25268, -2039584, false);
    }

    protected void method_2389(class_4587 poseStack, float partialTick, int mouseX, int mouseY) {
        this.tooltip = null;
        RenderSystem.setShaderTexture((int)0, (class_2960)POST_BOX_TEXTURE);
        class_332.method_25290((class_4587)poseStack, (int)this.field_2776, (int)this.field_2800, (float)0.0f, (float)0.0f, (int)(this.field_2792 + 25), (int)this.field_2779, (int)512, (int)256);
        class_332.method_44379((int)(this.field_2776 + 8), (int)(this.field_2800 + 34), (int)(this.field_2776 + 8 + 85), (int)(this.field_2800 + 34 + 130));
        int scroll = this.clampScroll(this.scroll + this.getDeltaScroll(mouseY));
        int startIndex = class_3532.method_15340((int)(scroll / 14), (int)0, (int)Math.max(0, this.mailboxes.size() - MAX_VISIBLE_ITEMS));
        int maxItems = Math.min(MAX_VISIBLE_ITEMS, this.mailboxes.size());
        for (int i = 0; i < maxItems; ++i) {
            int entryIndex = startIndex + i;
            int entryX = this.field_2776 + 8;
            int entryY = this.field_2800 + 34 + entryIndex * 14 - scroll;
            IMailbox mailbox = this.mailboxes.get(entryIndex);
            boolean selected = this.selected == mailbox;
            RenderSystem.setShaderTexture((int)0, (class_2960)POST_BOX_TEXTURE);
            class_332.method_25290((class_4587)poseStack, (int)entryX, (int)entryY, (float)0.0f, (float)(selected ? 172.0f : 186.0f), (int)85, (int)14, (int)512, (int)256);
            Optional<GameProfile> optional = mailbox.getOwner();
            if (optional.isPresent()) {
                class_640 info = this.getPlayerInfo(optional.get());
                RenderSystem.setShaderTexture((int)0, (class_2960)info.method_2968());
                class_7532.method_44443((class_4587)poseStack, (int)(entryX + 3), (int)(entryY + 3), (int)8);
            }
            class_2561 mailboxName = (class_2561)mailbox.getCustomName().filter(s -> !s.isBlank()).map(class_2561::method_43470).orElse(DEFAULT_MAILBOX_NAME);
            ScreenHelper.drawString(poseStack, mailboxName, entryX + 15, entryY + 3, selected ? -171 : -1, true);
            if (!this.method_2378(entryX - this.field_2776 + 3, entryY - this.field_2800 + 3, 8, 8, mouseX, mouseY)) continue;
            class_2561 ownerName = (class_2561)mailbox.getOwner().map(GameProfile::getName).map(class_2561::method_43470).orElse(UNKNOWN_MAILBOX_OWNER);
            this.tooltip = ScreenHelper.createMultilineTooltip(List.of(ownerName));
        }
        class_332.method_44380();
        RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_TEXTURE);
        class_332.method_25290((class_4587)poseStack, (int)(this.field_2776 + 8 + 85 + 1), (int)(this.field_2800 + 34 + this.getScrollBarOffset(mouseY)), (float)(this.canScroll() ? 0.0f : 6.0f), (float)199.0f, (int)6, (int)27, (int)512, (int)256);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 2; ++i) {
                if (!((PostBoxMenu)this.field_2797).getContainer().method_5438(j * 2 + i).method_7960()) continue;
                RenderSystem.setShaderTexture((int)0, (class_2960)POST_BOX_TEXTURE);
                class_332.method_25290((class_4587)poseStack, (int)(this.field_2776 + 235 + i * 18), (int)(this.field_2800 + 14 + j * 18), (float)85.0f, (float)172.0f, (int)16, (int)16, (int)512, (int)256);
            }
        }
        if (this.responseTranslationKey != null && this.responseTimer < 100) {
            class_5250 responseMessage = class_2561.method_43471((String)this.responseTranslationKey);
            int contentWidth = this.field_22793.method_27525((class_5348)responseMessage) + 4;
            int responseToastWidth = 4 + contentWidth + 3;
            int responseToastLeft = this.field_2776 + this.field_2792 / 2 - responseToastWidth / 2;
            int responseToastTop = this.field_2800 - 22;
            poseStack.method_22903();
            if (this.responseTimer < 5) {
                float frameTime = this.field_22787.method_1488();
                poseStack.method_22904(0.0, (double)((5.0f - ((float)this.responseTimer + frameTime)) * 5.0f), 0.0);
            } else if (100 - this.responseTimer < 5) {
                float frameTime = this.field_22787.method_1488();
                float offset = 5.0f - (100.0f - ((float)this.responseTimer + frameTime));
                poseStack.method_22904(0.0, (double)(offset * 5.0f), 0.0);
            }
            class_332.method_44379((int)responseToastLeft, (int)(this.field_2800 - 22), (int)(responseToastLeft + responseToastWidth), (int)this.field_2800);
            RenderSystem.setShaderTexture((int)0, (class_2960)POST_BOX_TEXTURE);
            int toastU = this.responseSuccess ? 8 : 0;
            class_332.method_25290((class_4587)poseStack, (int)responseToastLeft, (int)responseToastTop, (float)toastU, (float)200.0f, (int)4, (int)18, (int)512, (int)256);
            class_332.method_25293((class_4587)poseStack, (int)(responseToastLeft + 4), (int)responseToastTop, (int)contentWidth, (int)18, (float)(toastU + 4), (float)200.0f, (int)1, (int)18, (int)512, (int)256);
            class_332.method_25290((class_4587)poseStack, (int)(responseToastLeft + 4 + contentWidth), (int)responseToastTop, (float)(toastU + 5), (float)200.0f, (int)3, (int)18, (int)512, (int)256);
            this.field_22793.method_30883(poseStack, (class_2561)responseMessage, (float)(responseToastLeft + 6), (float)(responseToastTop + 5), -1);
            class_332.method_44380();
            poseStack.method_22909();
        }
        if (this.method_2378(91, 5, 10, 10, mouseX, mouseY)) {
            this.tooltip = ScreenHelper.createMultilineTooltip(List.of(Utils.translation("gui", "how_to", new Object[0]).method_27692(class_124.field_1065), Utils.translation("gui", "post_box_info", new Object[0])));
        }
    }

    protected void method_2380(class_4587 poseStack, int mouseX, int mouseY) {
        if (this.tooltip != null) {
            this.method_25417(poseStack, this.tooltip, mouseX, mouseY);
            return;
        }
        super.method_2380(poseStack, mouseX, mouseY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int relativeMouseY;
            int clickedIndex;
            this.method_25395(null);
            if (this.method_2378(8, 34, 85, 130, mouseX, mouseY) && (clickedIndex = (this.scroll + (relativeMouseY = (int)(mouseY - (double)this.field_2800 - 34.0))) / 14) >= 0 && clickedIndex < this.mailboxes.size()) {
                IMailbox mailbox = this.mailboxes.get(clickedIndex);
                this.selected = this.selected != mailbox ? mailbox : null;
                this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_17482, (float)1.0f, (float)1.0f));
                this.sendButton.field_22763 = this.selected != null;
                return true;
            }
            if (this.method_2378(94, 34 + this.getScrollBarOffset((int)mouseY), 6, 27, mouseX, mouseY)) {
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY >= 0) {
            this.scroll(this.getDeltaScroll((int)mouseY));
            this.clickedY = -1;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (this.searchEditBox.method_25370()) {
            return this.searchEditBox.method_25404(key, scanCode, modifiers);
        }
        if (this.messageEditBox.method_25370()) {
            return this.messageEditBox.method_25404(key, scanCode, modifiers);
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (this.method_2378(8, 34, 85, 130, mouseX, mouseY)) {
            this.scroll((int)(-5.0 * amount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    private void scroll(int amount) {
        this.scroll = this.clampScroll(this.scroll + amount);
    }

    private int clampScroll(int scroll) {
        return class_3532.method_15340((int)scroll, (int)0, (int)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return Math.max(this.mailboxes.size() * 14 - 130, 0);
    }

    private boolean canScroll() {
        return this.getMaxScroll() > 0;
    }

    private int getScrollBarOffset(int mouseY) {
        int scroll = this.clampScroll(this.scroll + this.getDeltaScroll(mouseY));
        return (int)(103.0 * ((double)scroll / (double)this.getMaxScroll()));
    }

    private int getDeltaScroll(int mouseY) {
        if (this.clickedY != -1) {
            double pixelsPerScroll = 103.0 / (double)this.getMaxScroll();
            return (int)((double)(mouseY - this.clickedY) / pixelsPerScroll);
        }
        return 0;
    }

    private void updateSearchFilter() {
        List<IMailbox> filteredMailboxes = ((PostBoxMenu)this.field_2797).getMailboxes().stream().filter(mailbox -> {
            if (this.query.startsWith("@")) {
                String ownerName = mailbox.getOwner().map(GameProfile::getName).orElse("Unknown");
                return StringUtils.containsIgnoreCase((CharSequence)ownerName, (CharSequence)this.query.substring(1));
            }
            String mailboxName = mailbox.getCustomName().orElse("Mailbox");
            return StringUtils.containsIgnoreCase((CharSequence)mailboxName, (CharSequence)this.query);
        }).sorted(Comparator.comparing(mailbox -> mailbox.getOwner().map(GameProfile::getName).orElse("Unknown")).thenComparing(mailbox -> mailbox.getCustomName().orElse("Mailbox"))).toList();
        this.mailboxes.clear();
        this.mailboxes.addAll(filteredMailboxes);
    }

    private class_640 getPlayerInfo(GameProfile profile) {
        class_640 info;
        class_634 listener;
        if (this.field_22787 != null && (listener = this.field_22787.method_1562()) != null && (info = listener.method_2871(profile.getId())) != null) {
            return info;
        }
        return PLAYER_INFO_CACHE.computeIfAbsent(profile.getId(), uuid -> {
            class_2703.class_2705 update = new class_2703.class_2705(profile, 0, class_1934.field_9215, null, null);
            return new class_640(update, this.field_22787.method_44256(), false);
        });
    }

    public void showResponse(DeliveryResult result) {
        result.message().ifPresent(key -> {
            this.responseSuccess = result.success();
            this.responseTranslationKey = key;
            this.responseTimer = 0;
        });
    }

    public void clearMessage() {
        this.messageEditBox.method_44400("");
    }
}

