/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import net.minecraft.class_1160;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_809;
import net.minecraft.class_827;
import net.minecraft.class_918;

public class GrillBlockEntityRenderer
implements class_827<GrillBlockEntity> {
    private final class_918 renderer;

    public GrillBlockEntityRenderer(class_5614.class_5615 context) {
        this.renderer = context.method_43335();
    }

    public void render(GrillBlockEntity grill, float partialTick, class_4587 poseStack, class_4597 source, int light, int overlay) {
        class_2371<class_1799> items = grill.getCookingItems();
        for (int i = 0; i < items.size(); ++i) {
            class_1799 stack = (class_1799)items.get(i);
            if (stack.method_7960()) continue;
            this.drawCookingSpace(grill, stack, poseStack, i, partialTick, source, light, overlay);
        }
        class_2371<class_1799> fuel = grill.getFuelItems();
        for (int i = 0; i < fuel.size(); ++i) {
            class_1799 stack = (class_1799)fuel.get(i);
            if (stack.method_7960()) continue;
            this.drawFuel(grill, stack, poseStack, i, source, light, overlay);
        }
    }

    private void drawCookingSpace(GrillBlockEntity grill, class_1799 cookingStack, class_4587 poseStack, int quadrant, float partialTick, class_4597 source, int light, int overlay) {
        poseStack.method_22903();
        GrillBlockEntity.CookingSpace space = grill.getCookingSpace(quadrant);
        FlipAnimation animation = space.getAnimation();
        float time = animation.isPlaying() ? animation.getTime(partialTick) : 0.0f;
        float flipProgress = this.calculateFlipProgress(time);
        float flipHeight = 0.75f;
        poseStack.method_22904(0.0, (double)(flipProgress * flipHeight), 0.0);
        poseStack.method_22904(0.3 + 0.4 * (double)(quadrant % 2), 1.0, 0.3 + 0.4 * (double)(quadrant / 2));
        poseStack.method_22907(class_1160.field_20703.method_23626(1.5707964f));
        poseStack.method_22907(class_1160.field_20707.method_23626(1.5707964f * (float)space.getRotation()));
        poseStack.method_22907(class_1160.field_20703.method_23626((float)Math.PI * -3 * time));
        poseStack.method_22907(class_1160.field_20703.method_23626(!animation.isPlaying() && space.isFlipped() ? (float)Math.PI : 0.0f));
        poseStack.method_22905(0.375f, 0.375f, 0.375f);
        this.renderer.method_23178(cookingStack, class_809.class_811.field_4319, light, overlay, poseStack, source, 0);
        poseStack.method_22909();
    }

    private void drawFuel(GrillBlockEntity grill, class_1799 fuelStack, class_4587 poseStack, int index, class_4597 source, int light, int overlay) {
        poseStack.method_22903();
        poseStack.method_22904(0.3 + 0.2 * (double)(index % 3), 0.85, 0.3 + 0.2 * (double)(index / 3));
        poseStack.method_22907(class_1160.field_20703.method_23626(1.5707964f));
        poseStack.method_22907(class_1160.field_20705.method_23214(10.0f));
        poseStack.method_22907(class_1160.field_20707.method_23214(10.0f));
        poseStack.method_22907(class_1160.field_20703.method_23214(5.0f));
        poseStack.method_22905(0.375f, 0.375f, 0.375f);
        this.renderer.method_23178(fuelStack, class_809.class_811.field_4319, light, overlay, poseStack, source, 0);
        poseStack.method_22909();
    }

    private float calculateFlipProgress(float time) {
        if ((double)time <= 0.5) {
            return 1.0f - (float)Math.pow(1.0f - (time /= 0.5f), 4.0);
        }
        time -= 0.5f;
        return 1.0f - (time /= 0.5f) * time * time * time;
    }
}

