/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerSelectionList;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageHomeControl;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

public class HomeControlGraphics
extends DisplayableProgram<HomeControl> {
    public HomeControlGraphics(HomeControl program) {
        super(program, 200, 100);
        this.setScene(new Home(this));
    }

    public static class Home
    extends Scene {
        private final HomeControlGraphics graphics;
        private final ComputerSelectionList<DeviceItem> devices;
        private final ComputerButton turnOnAllButton;
        private final ComputerButton turnOffAllButton;
        private final ComputerButton infoButton;

        public Home(HomeControlGraphics graphics) {
            this.graphics = graphics;
            this.devices = this.addWidget(new ComputerSelectionList(graphics.getWidth() - 10, graphics.getHeight() - 30, 25, 100, 16));
            this.devices.method_29344(false);
            ((HomeControl)graphics.getProgram()).findDevices().forEach(device -> this.devices.method_25396().add(new DeviceItem((IHomeControlDevice)device)));
            this.turnOnAllButton = this.addWidget(new ComputerButton(60, 14, graphics.translation("turn_on_all"), btn -> Network.getPlay().sendToServer((IMessage)new MessageHomeControl.UpdateAll(true))));
            this.turnOnAllButton.setTextColour(-13147337);
            this.turnOnAllButton.setTextHighlightColour(-13147337);
            this.turnOnAllButton.setOutlineColour(-14540251);
            this.turnOnAllButton.setBackgroundHighlightColour(-13423059);
            this.turnOffAllButton = this.addWidget(new ComputerButton(60, 14, graphics.translation("turn_off_all"), btn -> Network.getPlay().sendToServer((IMessage)new MessageHomeControl.UpdateAll(false))));
            this.turnOffAllButton.setTextColour(-10143432);
            this.turnOffAllButton.setTextHighlightColour(-10143432);
            this.turnOffAllButton.setOutlineColour(-14540251);
            this.turnOffAllButton.setBackgroundHighlightColour(-13423059);
            this.infoButton = this.addWidget(new ComputerButton(13, 14, (class_2561)class_2561.method_43470((String)"i"), btn -> graphics.setScene(new Info(graphics))));
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.devices.setPosition(contentStart + 5, contentTop + 25);
            this.turnOnAllButton.field_22760 = contentStart + 5;
            this.turnOnAllButton.field_22761 = contentTop + 3;
            this.turnOffAllButton.field_22760 = contentStart + 5 + this.turnOnAllButton.method_25368() + 2;
            this.turnOffAllButton.field_22761 = contentTop + 3;
            this.infoButton.field_22760 = contentStart + this.graphics.getWidth() - 5 - this.infoButton.method_25368();
            this.infoButton.field_22761 = contentTop + 3;
        }

        @Override
        public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            class_332.method_25294((class_4587)poseStack, (int)0, (int)0, (int)this.graphics.getWidth(), (int)20, (int)-14277082);
        }
    }

    private static class DeviceItem
    extends class_4280.class_4281<DeviceItem> {
        private final IHomeControlDevice device;
        private final ComputerButton button;

        public DeviceItem(IHomeControlDevice device) {
            this.device = device;
            this.button = new ComputerButton(50, 14, (class_2561)class_2561.method_43470((String)"Toggle"), btn -> Network.getPlay().sendToServer((IMessage)new MessageHomeControl.Toggle(this.device.getDevicePos())));
            this.button.setBackgroundHighlightColour(-13423059);
            this.updateButtonLabel();
        }

        private void updateButtonLabel() {
            this.button.method_25355(this.device.isDeviceEnabled() ? class_5244.field_24332 : class_5244.field_24333);
            this.button.setTextColour(this.device.isDeviceEnabled() ? -13147337 : -10143432);
            this.button.setTextHighlightColour(this.device.isDeviceEnabled() ? -13147337 : -10143432);
        }

        public void method_25343(class_4587 poseStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.updateButtonLabel();
            class_332.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + rowWidth), (int)(top + rowHeight), (int)-12107714);
            ScreenHelper.drawString(poseStack, this.device.getDeviceName(), left + 5, top + 4, -14540251, false);
            this.button.field_22760 = left + rowWidth - this.button.method_25368() - 1;
            this.button.field_22761 = top + 1;
            this.button.method_25394(poseStack, mouseX, mouseY, partialTick);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.button.method_25402(mouseX, mouseY, button);
            return true;
        }

        public class_2561 method_37006() {
            return this.device.getDeviceName();
        }
    }

    public static class Info
    extends Scene {
        private final HomeControlGraphics graphics;
        private final ComputerButton backButton;
        private final class_2561 infoText;

        public Info(HomeControlGraphics graphics) {
            this.graphics = graphics;
            this.backButton = this.addWidget(new ComputerButton(14, 14, (class_2561)class_2561.method_43470((String)"<"), btn -> graphics.setScene(new Home(graphics))));
            this.infoText = graphics.translation("info");
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.backButton.field_22760 = contentStart + 5;
            this.backButton.field_22761 = contentTop + 3;
        }

        @Override
        public void render(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
            class_332.method_25294((class_4587)poseStack, (int)0, (int)0, (int)this.graphics.getWidth(), (int)20, (int)-14277082);
            class_327 font = class_310.method_1551().field_1772;
            font.method_1712((class_5348)this.infoText, 5, 25, this.graphics.getWidth() - 10, -12107714);
        }
    }
}

