/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeSerializers;
import com.mrcrayfish.furniture.refurbished.core.ModRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_184;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2444;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5797;

public class CuttingBoardCombiningRecipe
implements class_1860<class_1263> {
    public static final int MAX_INGREDIENTS = 5;
    protected final class_2960 id;
    protected final class_2371<class_1856> ingredients;
    protected final class_1799 result;

    public CuttingBoardCombiningRecipe(class_2960 id, class_2371<class_1856> ingredients, class_1799 result) {
        this.id = id;
        this.ingredients = ingredients;
        this.result = result;
    }

    public boolean method_8115(class_1263 container, class_1937 level) {
        for (int i = 0; i < this.ingredients.size() && i < container.method_5439(); ++i) {
            if (((class_1856)this.ingredients.get(i)).method_8093(container.method_5438(i))) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_8116(class_1263 container) {
        return this.result.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.result;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return (class_1865)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
    }

    public class_3956<?> method_17716() {
        return (class_3956)ModRecipeTypes.CUTTING_BOARD_COMBINING.get();
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public class_1799 getResult() {
        return this.result;
    }

    public boolean completelyMatches(class_1263 container) {
        if (this.ingredients.size() <= container.method_5439()) {
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (((class_1856)this.ingredients.get(i)).method_8093(container.method_5438(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class Result
    implements class_2444 {
        private final class_2960 id;
        private final class_1856[] ingredients;
        private final class_1799 result;

        public Result(class_2960 id, class_1856[] ingredients, class_1799 result) {
            this.id = id;
            this.ingredients = ingredients;
            this.result = result;
        }

        public class_2960 method_10417() {
            return this.id;
        }

        public class_1865<?> method_17800() {
            return (class_1865)ModRecipeSerializers.CUTTING_BOARD_COMBINING_RECIPE.get();
        }

        public void method_10416(JsonObject object) {
            Serializer.toJson(this, object);
        }

        @Nullable
        public JsonObject method_10415() {
            return null;
        }

        @Nullable
        public class_2960 method_10418() {
            return null;
        }
    }

    public static class Builder
    implements class_5797 {
        private final List<class_1856> ingredients = new ArrayList<class_1856>();
        private final class_1799 result;

        public Builder(class_1799 result) {
            this.result = result;
        }

        public Builder add(class_1856 ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public class_5797 method_33530(String name, class_184 trigger) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support unlocking");
        }

        public class_5797 method_33529(@Nullable String group) {
            throw new UnsupportedOperationException("Cutting Board combining recipes don't support setting the group");
        }

        public class_1792 method_36441() {
            return this.result.method_7909();
        }

        public void method_17972(Consumer<class_2444> consumer, class_2960 id) {
            this.validate(id);
            consumer.accept(new Result(id, (class_1856[])this.ingredients.toArray(class_1856[]::new), this.result));
        }

        private void validate(class_2960 id) {
            if (this.ingredients.size() < 2) {
                throw new IllegalStateException("Cutting Board combining recipe must have at least 2 input ingredients");
            }
            if (this.ingredients.size() > 5) {
                throw new IllegalStateException("Cutting Board combining recipe only supports up to 5 input ingredients");
            }
        }
    }

    public static class Serializer
    implements class_1865<CuttingBoardCombiningRecipe> {
        public static void toJson(Result result, JsonObject object) {
            JsonArray inputArray = new JsonArray();
            for (class_1856 ingredient : result.ingredients) {
                inputArray.add(ingredient.method_8089());
            }
            object.add("ingredients", (JsonElement)inputArray);
            object.addProperty("result", class_2378.field_11142.method_10221((Object)result.result.method_7909()).toString());
            object.addProperty("count", (Number)result.result.method_7947());
        }

        public CuttingBoardCombiningRecipe fromJson(class_2960 id, JsonObject object) {
            JsonArray inputArray = class_3518.method_15261((JsonObject)object, (String)"ingredients");
            Object[] ingredients = (class_1856[])StreamSupport.stream(inputArray.spliterator(), false).map(element -> class_1856.method_8102((JsonElement)element)).toArray(class_1856[]::new);
            String resultString = class_3518.method_15265((JsonObject)object, (String)"result");
            class_1792 item = (class_1792)class_2378.field_11142.method_17966(new class_2960(resultString)).orElseThrow(() -> new IllegalStateException("Item: " + resultString + " does not exist"));
            int count = class_3518.method_15282((JsonObject)object, (String)"count", (int)1);
            class_1799 result = new class_1799((class_1935)item, count);
            return new CuttingBoardCombiningRecipe(id, (class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients), result);
        }

        public CuttingBoardCombiningRecipe fromNetwork(class_2960 id, class_2540 buffer) {
            int inputCount = buffer.readInt();
            Object[] ingredients = (class_1856[])IntStream.range(0, inputCount).mapToObj(val -> class_1856.method_8086((class_2540)buffer)).toArray(class_1856[]::new);
            class_1799 result = buffer.method_10819();
            return new CuttingBoardCombiningRecipe(id, (class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients), result);
        }

        public void toNetwork(class_2540 buffer, CuttingBoardCombiningRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.result);
        }
    }
}

