/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.data.model;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.data.model.ParentModel;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4936;
import net.minecraft.class_4945;
import org.apache.commons.lang3.ArrayUtils;

public class PreparedVariantBlockState {
    private final class_2248 block;
    private final List<Entry> entries = new ArrayList<Entry>();

    public PreparedVariantBlockState(class_2248 block) {
        this.block = block;
    }

    public class_2248 getBlock() {
        return this.block;
    }

    public List<Entry> getVariants() {
        this.block.method_9595().method_11662().forEach(state -> {
            if (this.entries.stream().noneMatch(entry -> entry.is((class_2680)state))) {
                class_2960 key = class_2378.field_11146.method_10221((Object)this.block);
                throw new IllegalStateException("Missing variant for " + String.valueOf(key) + state.toString());
            }
        });
        return List.copyOf(this.entries);
    }

    public Entry getVariantForItem() {
        return this.entries.stream().filter(entry -> entry.useForItem).findFirst().orElse(null);
    }

    public Entry createVariant() {
        Entry states = Entry.of(this.block);
        this.entries.add(states);
        return states;
    }

    public static class Entry {
        private final class_2248 block;
        private final Map<class_2769, Comparable> map = new TreeMap<class_2769, Comparable>(Comparator.comparing(class_2769::method_11899));
        private Model[] models = new Model[0];
        private boolean useForItem;

        private Entry(class_2248 block) {
            this.block = block;
        }

        public <T extends Comparable<T>> Entry prop(class_2769<T> key, T value) {
            Preconditions.checkArgument((boolean)this.block.method_9595().method_11659().contains(key));
            this.map.put(key, value);
            return this;
        }

        public Entry addExistingModel(Model builder) {
            this.models = (Model[])ArrayUtils.add((Object[])this.models, (Object)builder);
            return this;
        }

        public Entry addTexturedModel(Model builder) {
            builder.markAsChild();
            this.models = (Model[])ArrayUtils.add((Object[])this.models, (Object)builder);
            return this;
        }

        public void markAsItem() {
            this.useForItem = true;
        }

        public Model[] getModels() {
            return this.models;
        }

        public Map<class_2769, Comparable> getValueMap() {
            return this.map;
        }

        public int hashCode() {
            return Objects.hash(this.block, this.map);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry that = (Entry)o;
            return this.block.equals(that.block);
        }

        public static Entry of(class_2248 block) {
            return new Entry(block);
        }

        public boolean is(class_2680 state) {
            return this.map.entrySet().stream().allMatch(entry -> Objects.equals(state.method_11654((class_2769)entry.getKey()), entry.getValue()));
        }
    }

    public static class Model
    extends ParentModel<Model> {
        private class_4936.class_4937 xRotation = class_4936.class_4937.field_22890;
        private class_4936.class_4937 yRotation = class_4936.class_4937.field_22890;

        private Model(String name, class_2960 model, class_4945[] slots) {
            super(name, model, slots);
        }

        @Override
        public Model self() {
            return this;
        }

        public class_4936.class_4937 getXRotation() {
            return this.xRotation;
        }

        public Model setXRotation(class_4936.class_4937 rotation) {
            this.xRotation = rotation;
            return this;
        }

        public class_4936.class_4937 getYRotation() {
            return this.yRotation;
        }

        public Model setYRotation(class_4936.class_4937 rotation) {
            this.yRotation = rotation;
            return this;
        }

        public static Model create(String name, class_2960 model, class_4945[] slots) {
            return new Model(name, model, slots);
        }
    }
}

