/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.block;

import net.mcreator.luminousworld.procedures.BirchtreemushroomsBlockDestroyedByPlayerProcedure;
import net.mcreator.luminousworld.procedures.BirchtreemushroomsUpdateTickProcedure;
import net.mcreator.luminousworld.procedures.WallleavesBlockValidPlacementConditionProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BirchtreemushroomsBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public BirchtreemushroomsBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.0f, 10.0f).noOcclusion().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)BirchtreemushroomsBlock.box((double)7.0, (double)1.0, (double)0.0, (double)13.0, (double)3.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BirchtreemushroomsBlock.box((double)1.0, (double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0), BirchtreemushroomsBlock.box((double)8.0, (double)13.0, (double)0.0, (double)15.0, (double)15.0, (double)3.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)BirchtreemushroomsBlock.box((double)3.0, (double)1.0, (double)14.0, (double)9.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BirchtreemushroomsBlock.box((double)6.0, (double)7.0, (double)12.0, (double)15.0, (double)9.0, (double)16.0), BirchtreemushroomsBlock.box((double)1.0, (double)13.0, (double)13.0, (double)8.0, (double)15.0, (double)16.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)BirchtreemushroomsBlock.box((double)0.0, (double)1.0, (double)3.0, (double)2.0, (double)3.0, (double)9.0), (VoxelShape[])new VoxelShape[]{BirchtreemushroomsBlock.box((double)0.0, (double)7.0, (double)6.0, (double)4.0, (double)9.0, (double)15.0), BirchtreemushroomsBlock.box((double)0.0, (double)13.0, (double)1.0, (double)3.0, (double)15.0, (double)8.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)BirchtreemushroomsBlock.box((double)14.0, (double)1.0, (double)7.0, (double)16.0, (double)3.0, (double)13.0), (VoxelShape[])new VoxelShape[]{BirchtreemushroomsBlock.box((double)12.0, (double)7.0, (double)1.0, (double)16.0, (double)9.0, (double)10.0), BirchtreemushroomsBlock.box((double)13.0, (double)13.0, (double)8.0, (double)16.0, (double)15.0, (double)15.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return WallleavesBlockValidPlacementConditionProcedure.execute(world, x, y, z, blockstate);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        BirchtreemushroomsUpdateTickProcedure.execute();
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        BirchtreemushroomsBlockDestroyedByPlayerProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
        return retval;
    }
}

