/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.luminousworld.network.BeastBook9ButtonMessage;
import net.mcreator.luminousworld.procedures.ReturnWitchDoctorProcedure;
import net.mcreator.luminousworld.world.inventory.BeastBook9Menu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BeastBook9Screen
extends AbstractContainerScreen<BeastBook9Menu> {
    private static final HashMap<String, Object> guistate = BeastBook9Menu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    ImageButton imagebutton_larrowoff;
    ImageButton imagebutton_rarrowoff;

    public BeastBook9Screen(BeastBook9Menu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 315;
        this.imageHeight = 170;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        Entity entity = ReturnWitchDoctorProcedure.execute((LevelAccessor)this.world);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.renderEntityInInventoryFollowsAngle(guiGraphics, this.leftPos + 230, this.topPos + 134, 55, 0.0f + (float)Math.atan((double)(this.leftPos + 230 - mouseX) / 40.0), (float)Math.atan((double)(this.topPos + 85 - mouseY) / 40.0), livingEntity);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(new ResourceLocation("luminousworld:textures/screens/beastgui.png"), this.leftPos + -3, this.topPos + -19, 0.0f, 0.0f, 320, 198, 320, 198);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_bone_stalker"), 44, -10, -12363225, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_health"), 14, 6, -12363225, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_location"), 14, 26, -12363225, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_drops"), 14, 48, -12363225, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_ability"), 14, 113, -12363225, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_120"), 13, 17, -14804209, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_dark_oak_forests"), 14, 37, -14804209, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_bone_rattle"), 14, 59, -14804209, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_summons_a_phantom"), 14, 79, -14804209, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_stalker_to_fight_for"), 14, 89, -13421773, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_you_upon_death"), 14, 99, -13421773, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_goes_invisible_and"), 14, 122, -14804209, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.luminousworld.beast_book_9.label_summons_phantom_stalkers"), 14, 133, -14804209, false);
    }

    public void init() {
        super.init();
        this.imagebutton_larrowoff = new ImageButton(this.leftPos + 21, this.topPos + 149, 18, 10, new WidgetSprites(new ResourceLocation("luminousworld:textures/screens/larrowoff.png"), new ResourceLocation("luminousworld:textures/screens/larrowon.png")), e -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BeastBook9ButtonMessage(0, this.x, this.y, this.z)});
            BeastBook9ButtonMessage.handleButtonAction(this.entity, 0, this.x, this.y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:imagebutton_larrowoff", this.imagebutton_larrowoff);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_larrowoff);
        this.imagebutton_rarrowoff = new ImageButton(this.leftPos + 273, this.topPos + 150, 18, 10, new WidgetSprites(new ResourceLocation("luminousworld:textures/screens/rarrowoff.png"), new ResourceLocation("luminousworld:textures/screens/rarrowon.png")), e -> {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new BeastBook9ButtonMessage(1, this.x, this.y, this.z)});
            BeastBook9ButtonMessage.handleButtonAction(this.entity, 1, this.x, this.y, this.z);
        }){

            public void renderWidget(GuiGraphics guiGraphics, int x, int y, float partialTicks) {
                guiGraphics.blit(this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        };
        guistate.put("button:imagebutton_rarrowoff", this.imagebutton_rarrowoff);
        this.addRenderableWidget((GuiEventListener)this.imagebutton_rarrowoff);
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.yBodyRot;
        float f3 = entity.getYRot();
        float f4 = entity.getXRot();
        float f5 = entity.yHeadRotO;
        float f6 = entity.yHeadRot;
        entity.yBodyRot = 180.0f + angleXComponent * 20.0f;
        entity.setYRot(180.0f + angleXComponent * 40.0f);
        entity.setXRot(-angleYComponent * 20.0f);
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)x, (float)y, (int)scale, (Vector3f)new Vector3f(0.0f, 0.0f, 0.0f), (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.yBodyRot = f2;
        entity.setYRot(f3);
        entity.setXRot(f4);
        entity.yHeadRotO = f5;
        entity.yHeadRot = f6;
    }
}

