/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelzebra<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("luminousworld", "modelzebra"), "main");
    public final ModelPart head;
    public final ModelPart insidehead;
    public final ModelPart mane;
    public final ModelPart neck;
    public final ModelPart right_ear;
    public final ModelPart mouth;
    public final ModelPart left_ear;
    public final ModelPart headpiece;
    public final ModelPart body;
    public final ModelPart tail;
    public final ModelPart child_front_left_leg;
    public final ModelPart child_front_right_leg;
    public final ModelPart child_back_left_leg;
    public final ModelPart child_back_right_leg;

    public Modelzebra(ModelPart root) {
        this.head = root.getChild("head");
        this.insidehead = this.head.getChild("insidehead");
        this.mane = this.insidehead.getChild("mane");
        this.neck = this.insidehead.getChild("neck");
        this.right_ear = this.insidehead.getChild("right_ear");
        this.mouth = this.insidehead.getChild("mouth");
        this.left_ear = this.insidehead.getChild("left_ear");
        this.headpiece = this.insidehead.getChild("headpiece");
        this.body = root.getChild("body");
        this.tail = this.body.getChild("tail");
        this.child_front_left_leg = this.body.getChild("child_front_left_leg");
        this.child_front_right_leg = this.body.getChild("child_front_right_leg");
        this.child_back_left_leg = this.body.getChild("child_back_left_leg");
        this.child_back_right_leg = this.body.getChild("child_back_right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)-9.0f));
        PartDefinition insidehead = head.addOrReplaceChild("insidehead", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition mane = insidehead.addOrReplaceChild("mane", CubeListBuilder.create().texOffs(48, 49).addBox(-1.0f, -12.0761f, 4.6273f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-0.01f));
        PartDefinition neck = insidehead.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 0).addBox(-2.05f, -7.0761f, -2.3827f, 4.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_ear = insidehead.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(0, 0).addBox(-2.55f, -14.0761f, 3.6173f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-0.01f));
        PartDefinition mouth = insidehead.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(30, 49).addBox(-2.0f, -12.0761f, -7.3827f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_ear = insidehead.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(15, 0).addBox(0.55f, -14.0761f, 3.6173f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-0.01f));
        PartDefinition headpiece = insidehead.addOrReplaceChild("headpiece", CubeListBuilder.create().texOffs(4, 72).addBox(-3.0f, -12.0761f, -2.2827f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -9.0f, -17.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.05f)), PartPose.offset((float)0.0f, (float)11.0f, (float)6.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 49).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(67, 35).addBox(-1.5f, 10.0f, 0.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)5.0f));
        PartDefinition child_front_left_leg = body.addOrReplaceChild("child_front_left_leg", CubeListBuilder.create().texOffs(0, 43).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.0f, (float)-15.0f));
        PartDefinition child_front_right_leg = body.addOrReplaceChild("child_front_right_leg", CubeListBuilder.create().texOffs(24, 32).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)1.0f, (float)-15.0f));
        PartDefinition child_back_left_leg = body.addOrReplaceChild("child_back_left_leg", CubeListBuilder.create().texOffs(42, 0).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)1.0f, (float)3.0f));
        PartDefinition child_back_right_leg = body.addOrReplaceChild("child_back_right_leg", CubeListBuilder.create().texOffs(40, 32).addBox(-2.0f, -0.5f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)1.0f, (float)3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.child_front_right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.child_back_left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.child_front_left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.child_back_right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

