/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.configuration;

import net.neoforged.neoforge.common.ModConfigSpec;

public class LuminousConfigurationConfiguration {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.ConfigValue<Boolean> PEBBLES_SPAWN;
    public static final ModConfigSpec.ConfigValue<Double> AUBURN_TREE_SPAWN;
    public static final ModConfigSpec.ConfigValue<Double> WHITE_OAK_SPAWN;
    public static final ModConfigSpec.ConfigValue<Double> WILD_PALM_SPAWN;
    public static final ModConfigSpec.ConfigValue<Double> SOFT_BIRCH_SPAWN;
    public static final ModConfigSpec.ConfigValue<Double> TALL_TAIGA_SPAWN;
    public static final ModConfigSpec.ConfigValue<Double> BAOBAB_SPAWN;
    public static final ModConfigSpec.ConfigValue<Boolean> SAVANNA_ADDITIONS;
    public static final ModConfigSpec.ConfigValue<Boolean> SNOWY_PLANTS;
    public static final ModConfigSpec.ConfigValue<Boolean> BOULDER_SPAWNS;
    public static final ModConfigSpec.ConfigValue<Boolean> DECORATIVE_MUSHROOM_SPAWNS;
    public static final ModConfigSpec.ConfigValue<Double> TREE_ENT_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> KING_HERMIT_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> MUMMY_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> VIPER_EGG_RARITY;
    public static final ModConfigSpec.ConfigValue<Double> YETI_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> PHOENIX_EGG_RARITY;
    public static final ModConfigSpec.ConfigValue<Double> VILE_GATOR_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> BONE_STALKER_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> WITCHDOCTOR_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Boolean> BUTTERFLY_SPAWNS;
    public static final ModConfigSpec.ConfigValue<Boolean> FIREFLY_SPAWNS;
    public static final ModConfigSpec.ConfigValue<Boolean> VARIANT_SPAWNS;
    public static final ModConfigSpec.ConfigValue<Boolean> CREATURE_SPAWNS;
    public static final ModConfigSpec.ConfigValue<Double> ROOT_SLOWNESS;
    public static final ModConfigSpec.ConfigValue<Double> ROOT_TIMER;
    public static final ModConfigSpec.ConfigValue<Double> SHELLMET_SPEED;
    public static final ModConfigSpec.ConfigValue<Double> FRIGID_HORN_TIMER;
    public static final ModConfigSpec.ConfigValue<Double> VIPER_FANG_DAMAGE_TIMER;
    public static final ModConfigSpec.ConfigValue<Double> GATOR_TOOTH_POISON;
    public static final ModConfigSpec.ConfigValue<Double> GATOR_TOOTH_TIMER;
    public static final ModConfigSpec.ConfigValue<Double> TAMED_STALKER_TIMER;
    public static final ModConfigSpec.ConfigValue<Double> BEAST_TOTEM_RANGE;
    public static final ModConfigSpec.ConfigValue<Double> PENDANT_RESISTANCE;
    public static final ModConfigSpec.ConfigValue<Double> PENDANT_TIMER;
    public static final ModConfigSpec.ConfigValue<Boolean> STARTUP_MESSAGE;
    public static final ModConfigSpec.ConfigValue<Double> RARE_TREE_ENT_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> RARE_KING_HERMIT_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> RARE_MUMMY_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> RARE_VIPER_EGG_RARITY;
    public static final ModConfigSpec.ConfigValue<Double> RARE_YETI_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> RARE_PHOENIX_EGG_RARITY;
    public static final ModConfigSpec.ConfigValue<Double> RARE_VILE_GATOR_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> RARE_BONE_STALKER_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> WOODLAND_WITCHDOCTOR_SPAWNRATE;
    public static final ModConfigSpec.ConfigValue<Double> ALLOWED_PIT_NUMBER;
    public static final ModConfigSpec.ConfigValue<Double> PIT_LIGHT_TIMER;

    static {
        BUILDER.push("World Generation");
        PEBBLES_SPAWN = BUILDER.comment("Determines if ground pebbles will spawn in biomes").define("Pebble Spawns", true);
        AUBURN_TREE_SPAWN = BUILDER.comment("5 is greatest/normal, 0 is disabled").define("Auburn tree spawnrate", (Object)5.0);
        WHITE_OAK_SPAWN = BUILDER.comment("5 is greatest/normal, 0 is disabled").define("White Oak tree spawnrate", (Object)5.0);
        WILD_PALM_SPAWN = BUILDER.comment("5 is greatest/normal, 0 is disabled").define("Wild Palm tree spawnrate", (Object)5.0);
        SOFT_BIRCH_SPAWN = BUILDER.comment("5 is greatest/normal, 0 is disabled").define("Soft Birch tree spawnrate", (Object)5.0);
        TALL_TAIGA_SPAWN = BUILDER.comment("5 is greatest/normal, 0 is disabled").define("Tall Taiga tree spawnrate", (Object)5.0);
        BAOBAB_SPAWN = BUILDER.comment("5 is greatest/normal, 0 is disabled").define("Baobab tree spawnrate", (Object)5.0);
        SAVANNA_ADDITIONS = BUILDER.comment("true means enabled, false means disabled").define("Savannah Additions", true);
        SNOWY_PLANTS = BUILDER.comment("true means enabled, false means disabled").define("Snowy plant spawns", true);
        BOULDER_SPAWNS = BUILDER.comment("true means enabled, false means disabled").define("Boulder spawns", true);
        DECORATIVE_MUSHROOM_SPAWNS = BUILDER.comment("true means enabled, false means disabled").define("Decorative Mushroom Spawns", true);
        BUILDER.pop();
        BUILDER.push("Legendary Beasts");
        TREE_ENT_SPAWNRATE = BUILDER.comment("0 means disabled 1 means enabled").define("Tree Ent Spawnrate", (Object)1.0);
        KING_HERMIT_SPAWNRATE = BUILDER.define("King Hermit Spawnrate", (Object)1.0);
        MUMMY_SPAWNRATE = BUILDER.define("Mummy Spawnrate", (Object)1.0);
        VIPER_EGG_RARITY = BUILDER.comment("1 is normal 2 is doubled 3 is tripled").define("Viper Egg Rarity", (Object)1.0);
        YETI_SPAWNRATE = BUILDER.define("Yeti Spawnrate", (Object)1.0);
        PHOENIX_EGG_RARITY = BUILDER.comment("1 is normal 2 is doubled 3 is tripled").define("Phoenix Egg Rarity", (Object)1.0);
        VILE_GATOR_SPAWNRATE = BUILDER.define("Vile Gator Spawnrate", (Object)1.0);
        BONE_STALKER_SPAWNRATE = BUILDER.define("Bone Stalker spawnrate", (Object)1.0);
        WITCHDOCTOR_SPAWNRATE = BUILDER.define("Witchdoctor spawnrate", (Object)1.0);
        BUILDER.pop();
        BUILDER.push("Mob Spawns");
        BUTTERFLY_SPAWNS = BUILDER.comment("true means enabled, false means disabled").define("Butterfly spawns", true);
        FIREFLY_SPAWNS = BUILDER.define("Firefly spawns", true);
        VARIANT_SPAWNS = BUILDER.define("Variant spawns", true);
        CREATURE_SPAWNS = BUILDER.define("Creature spawns", true);
        BUILDER.pop();
        BUILDER.push("Legendary Beast Items");
        ROOT_SLOWNESS = BUILDER.comment("Determines the level of slowness granted by the Enchanted Root").define("Root Slowness", (Object)1.0);
        ROOT_TIMER = BUILDER.comment("Determines the amount of time an enemy will be slowed by the root's attacks (in seconds)").define("Root Timer", (Object)4.0);
        SHELLMET_SPEED = BUILDER.comment("Determines the level of speed granted when wearing the shellmet").define("Shellmet Speed", (Object)1.0);
        FRIGID_HORN_TIMER = BUILDER.comment("Determines the amount of seconds between each heal while holding the Frigid Horn").define("Frigid Horn Timer", (Object)10.0);
        VIPER_FANG_DAMAGE_TIMER = BUILDER.comment("Determines the amount of time before the viper fang ticks damage onto itself in seconds").define("Viper Fang Damage Timer", (Object)10.0);
        GATOR_TOOTH_POISON = BUILDER.comment("Determines the level of poison given to mobs with the gator tooth").define("Gator Tooth Poison Level", (Object)1.0);
        GATOR_TOOTH_TIMER = BUILDER.comment("Determines the amount of time a mob is effected with the gator tooth's poison").define("Gator Tooth Timer", (Object)5.0);
        TAMED_STALKER_TIMER = BUILDER.comment("Determines how long a spawned phantom stalker will stay alive for (in seconds)").define("Tamed Stalker Timer", (Object)300.0);
        BEAST_TOTEM_RANGE = BUILDER.comment("Determines the range of the Totem of Beasts (150 is default)").define("Beast Totem Range", (Object)150.0);
        PENDANT_RESISTANCE = BUILDER.comment("Determines the level of resistance granted by the Jungle Pendant").define("Jungle Pendant Resistance", (Object)1.0);
        PENDANT_TIMER = BUILDER.comment("Determines the duration of resistance granted to the player").define("Jungle Pendant Timer", (Object)6.0);
        BUILDER.pop();
        BUILDER.push("Other");
        STARTUP_MESSAGE = BUILDER.comment("true means enabled, false means disabled").define("Startup_message", true);
        BUILDER.pop();
        BUILDER.push("Rare Legendary Beasts");
        RARE_TREE_ENT_SPAWNRATE = BUILDER.comment("0 means disabled 1 means enabled").define("Rare Tree Ent Spawnrate", (Object)1.0);
        RARE_KING_HERMIT_SPAWNRATE = BUILDER.define("Rare Rare King Hermit Spawnrate", (Object)1.0);
        RARE_MUMMY_SPAWNRATE = BUILDER.define("Rare Mummy Spawnrate", (Object)1.0);
        RARE_VIPER_EGG_RARITY = BUILDER.comment("1 is normal 2 is doubled 3 is tripled").define("Rare Sea Viper Egg Rarity", (Object)1.0);
        RARE_YETI_SPAWNRATE = BUILDER.define("Rare Yeti Spawnrate", (Object)1.0);
        RARE_PHOENIX_EGG_RARITY = BUILDER.comment("1 is normal 2 is doubled 3 is tripled").define("Rare Phoenix Egg Rarity", (Object)1.0);
        RARE_VILE_GATOR_SPAWNRATE = BUILDER.define("Rare Vile Gator Spawnrate", (Object)1.0);
        RARE_BONE_STALKER_SPAWNRATE = BUILDER.define("Rare Bone Stalker Spawnrate", (Object)1.0);
        WOODLAND_WITCHDOCTOR_SPAWNRATE = BUILDER.define("Woodland Witchdoctor Spawnrate", (Object)1.0);
        BUILDER.pop();
        BUILDER.push("Beast Pit Configuration");
        ALLOWED_PIT_NUMBER = BUILDER.comment("Determines the max number of Beast pits that can be lit at any given time per world").define("Allowed Beast Pit Number", (Object)2.0);
        PIT_LIGHT_TIMER = BUILDER.comment("Determines how long the Beast Pit stays lit (in ticks, default is 300)").define("Beast Pit Lit Timer", (Object)100.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

