/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousworld.network;

import java.util.function.Supplier;
import net.mcreator.luminousworld.LuminousworldMod;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LuminousworldModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"luminousworld");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LuminousworldMod.addNetworkMessage(SavedDataSyncMessage.ID, SavedDataSyncMessage::new, SavedDataSyncMessage::handleData);
        LuminousworldMod.addNetworkMessage(PlayerVariablesSyncMessage.ID, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    public static class SavedDataSyncMessage
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("luminousworld", "saved_data_sync");
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.type);
            if (this.data != null) {
                buffer.writeNbt((Tag)this.data.save(new CompoundTag()));
            }
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(SavedDataSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> {
                    if (message.type == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag()));
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag()));
                    }
                }).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final ResourceLocation ID = new ResourceLocation("luminousworld", "player_variables_sync");

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.readNbt());
        }

        public void write(FriendlyByteBuf buffer) {
            buffer.writeNbt((Tag)this.data.serializeNBT());
        }

        public ResourceLocation id() {
            return ID;
        }

        public static void handleData(PlayerVariablesSyncMessage message, PlayPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.workHandler().submitAsync(() -> ((PlayerVariables)Minecraft.getInstance().player.getData(PLAYER_VARIABLES)).deserializeNBT(message.data.serializeNBT())).exceptionally(e -> {
                    context.packetHandler().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public boolean Monarch = false;
        public boolean Blackswallowtail = false;
        public boolean Springazure = false;
        public boolean YellowSwallowtail = false;
        public boolean Buckeye = false;
        public boolean Hairstreak = false;
        public boolean Whitehairstreak = false;
        public boolean Bluemonarch = false;
        public boolean EmeraldSwallowtail = false;
        public boolean Rustypage = false;
        public boolean Littlewood = false;
        public boolean Zebralongwing = false;
        public boolean Orangetip = false;
        public boolean Mourningcloak = false;
        public boolean Charaxes = false;
        public boolean Ringlet = false;
        public boolean Cherryrose = false;
        public boolean Birdwing = false;
        public boolean SoulMonarch = false;
        public boolean CrimsonMonarch = false;
        public boolean GlowstoneMorpho = false;
        public boolean Enderfly = false;
        public boolean ChorusMorpho = false;
        public boolean HasKilledTreeEnt = false;
        public boolean HasKilledKingHermit = false;
        public boolean HasKilledMummy = false;
        public boolean HasKilledSeaViper = false;
        public boolean HasKilledYeti = false;
        public boolean HasKilledPhoenix = false;
        public boolean HasKilledBoneStalker = false;
        public boolean HasKilledVileGator = false;
        public boolean HasKilledWitchdoctor = false;
        public boolean Firefly = false;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("Monarch", this.Monarch);
            nbt.putBoolean("Blackswallowtail", this.Blackswallowtail);
            nbt.putBoolean("Springazure", this.Springazure);
            nbt.putBoolean("YellowSwallowtail", this.YellowSwallowtail);
            nbt.putBoolean("Buckeye", this.Buckeye);
            nbt.putBoolean("Hairstreak", this.Hairstreak);
            nbt.putBoolean("Whitehairstreak", this.Whitehairstreak);
            nbt.putBoolean("Bluemonarch", this.Bluemonarch);
            nbt.putBoolean("EmeraldSwallowtail", this.EmeraldSwallowtail);
            nbt.putBoolean("Rustypage", this.Rustypage);
            nbt.putBoolean("Littlewood", this.Littlewood);
            nbt.putBoolean("Zebralongwing", this.Zebralongwing);
            nbt.putBoolean("Orangetip", this.Orangetip);
            nbt.putBoolean("Mourningcloak", this.Mourningcloak);
            nbt.putBoolean("Charaxes", this.Charaxes);
            nbt.putBoolean("Ringlet", this.Ringlet);
            nbt.putBoolean("Cherryrose", this.Cherryrose);
            nbt.putBoolean("Birdwing", this.Birdwing);
            nbt.putBoolean("SoulMonarch", this.SoulMonarch);
            nbt.putBoolean("CrimsonMonarch", this.CrimsonMonarch);
            nbt.putBoolean("GlowstoneMorpho", this.GlowstoneMorpho);
            nbt.putBoolean("Enderfly", this.Enderfly);
            nbt.putBoolean("ChorusMorpho", this.ChorusMorpho);
            nbt.putBoolean("HasKilledTreeEnt", this.HasKilledTreeEnt);
            nbt.putBoolean("HasKilledKingHermit", this.HasKilledKingHermit);
            nbt.putBoolean("HasKilledMummy", this.HasKilledMummy);
            nbt.putBoolean("HasKilledSeaViper", this.HasKilledSeaViper);
            nbt.putBoolean("HasKilledYeti", this.HasKilledYeti);
            nbt.putBoolean("HasKilledPhoenix", this.HasKilledPhoenix);
            nbt.putBoolean("HasKilledBoneStalker", this.HasKilledBoneStalker);
            nbt.putBoolean("HasKilledVileGator", this.HasKilledVileGator);
            nbt.putBoolean("HasKilledWitchdoctor", this.HasKilledWitchdoctor);
            nbt.putBoolean("Firefly", this.Firefly);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.Monarch = nbt.getBoolean("Monarch");
            this.Blackswallowtail = nbt.getBoolean("Blackswallowtail");
            this.Springazure = nbt.getBoolean("Springazure");
            this.YellowSwallowtail = nbt.getBoolean("YellowSwallowtail");
            this.Buckeye = nbt.getBoolean("Buckeye");
            this.Hairstreak = nbt.getBoolean("Hairstreak");
            this.Whitehairstreak = nbt.getBoolean("Whitehairstreak");
            this.Bluemonarch = nbt.getBoolean("Bluemonarch");
            this.EmeraldSwallowtail = nbt.getBoolean("EmeraldSwallowtail");
            this.Rustypage = nbt.getBoolean("Rustypage");
            this.Littlewood = nbt.getBoolean("Littlewood");
            this.Zebralongwing = nbt.getBoolean("Zebralongwing");
            this.Orangetip = nbt.getBoolean("Orangetip");
            this.Mourningcloak = nbt.getBoolean("Mourningcloak");
            this.Charaxes = nbt.getBoolean("Charaxes");
            this.Ringlet = nbt.getBoolean("Ringlet");
            this.Cherryrose = nbt.getBoolean("Cherryrose");
            this.Birdwing = nbt.getBoolean("Birdwing");
            this.SoulMonarch = nbt.getBoolean("SoulMonarch");
            this.CrimsonMonarch = nbt.getBoolean("CrimsonMonarch");
            this.GlowstoneMorpho = nbt.getBoolean("GlowstoneMorpho");
            this.Enderfly = nbt.getBoolean("Enderfly");
            this.ChorusMorpho = nbt.getBoolean("ChorusMorpho");
            this.HasKilledTreeEnt = nbt.getBoolean("HasKilledTreeEnt");
            this.HasKilledKingHermit = nbt.getBoolean("HasKilledKingHermit");
            this.HasKilledMummy = nbt.getBoolean("HasKilledMummy");
            this.HasKilledSeaViper = nbt.getBoolean("HasKilledSeaViper");
            this.HasKilledYeti = nbt.getBoolean("HasKilledYeti");
            this.HasKilledPhoenix = nbt.getBoolean("HasKilledPhoenix");
            this.HasKilledBoneStalker = nbt.getBoolean("HasKilledBoneStalker");
            this.HasKilledVileGator = nbt.getBoolean("HasKilledVileGator");
            this.HasKilledWitchdoctor = nbt.getBoolean("HasKilledWitchdoctor");
            this.Firefly = nbt.getBoolean("Firefly");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.PLAYER.with((Object)serverPlayer).send(new CustomPacketPayload[]{new PlayerVariablesSyncMessage(this)});
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "luminousworld_mapvars";
        public double pebbleamount = 0.0;
        public double pit_number = 0.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.pebbleamount = nbt.getDouble("pebbleamount");
            this.pit_number = nbt.getDouble("pit_number");
        }

        public CompoundTag save(CompoundTag nbt) {
            nbt.putDouble("pebbleamount", this.pebbleamount);
            nbt.putDouble("pit_number", this.pit_number);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{new SavedDataSyncMessage(0, this)});
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "luminousworld_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag save(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.setDirty();
            if (world instanceof Level && !(level = (Level)world).isClientSide()) {
                PacketDistributor.DIMENSION.with((Object)level.dimension()).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, this)});
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.Monarch = original.Monarch;
            clone.Blackswallowtail = original.Blackswallowtail;
            clone.Springazure = original.Springazure;
            clone.YellowSwallowtail = original.YellowSwallowtail;
            clone.Buckeye = original.Buckeye;
            clone.Hairstreak = original.Hairstreak;
            clone.Whitehairstreak = original.Whitehairstreak;
            clone.Bluemonarch = original.Bluemonarch;
            clone.EmeraldSwallowtail = original.EmeraldSwallowtail;
            clone.Rustypage = original.Rustypage;
            clone.Littlewood = original.Littlewood;
            clone.Zebralongwing = original.Zebralongwing;
            clone.Orangetip = original.Orangetip;
            clone.Mourningcloak = original.Mourningcloak;
            clone.Charaxes = original.Charaxes;
            clone.Ringlet = original.Ringlet;
            clone.Cherryrose = original.Cherryrose;
            clone.Birdwing = original.Birdwing;
            clone.SoulMonarch = original.SoulMonarch;
            clone.CrimsonMonarch = original.CrimsonMonarch;
            clone.GlowstoneMorpho = original.GlowstoneMorpho;
            clone.Enderfly = original.Enderfly;
            clone.ChorusMorpho = original.ChorusMorpho;
            clone.HasKilledTreeEnt = original.HasKilledTreeEnt;
            clone.HasKilledKingHermit = original.HasKilledKingHermit;
            clone.HasKilledMummy = original.HasKilledMummy;
            clone.HasKilledSeaViper = original.HasKilledSeaViper;
            clone.HasKilledYeti = original.HasKilledYeti;
            clone.HasKilledPhoenix = original.HasKilledPhoenix;
            clone.HasKilledBoneStalker = original.HasKilledBoneStalker;
            clone.HasKilledVileGator = original.HasKilledVileGator;
            clone.HasKilledWitchdoctor = original.HasKilledWitchdoctor;
            clone.Firefly = original.Firefly;
            if (!event.isWasDeath()) {
                // empty if block
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(0, mapdata)});
                }
                if (worlddata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, worlddata)});
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SavedDataSyncMessage(1, worlddata)});
                }
            }
        }
    }
}

