/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.particle.configurations.properties;

import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.documentation.DocClientUtils;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleConfigWidgetProvider;
import com.hollingsworth.arsnouveau.api.particle.configurations.ParticleMotion;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.client.gui.HorizontalSlider;
import com.hollingsworth.arsnouveau.client.gui.buttons.SelectedParticleButton;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public class ParticleDensityProperty
extends BaseProperty<ParticleDensityProperty> {
    public static MapCodec<ParticleDensityProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("density").forGetter(i -> i.density), (App)Codec.DOUBLE.fieldOf("radius").forGetter(i -> i.radius), (App)ANCodecs.createEnumCodec(ParticleMotion.SpawnType.class).optionalFieldOf("spawnType").forGetter(ParticleDensityProperty::spawnType)).apply((Applicative)instance, ParticleDensityProperty::new));
    public static StreamCodec<RegistryFriendlyByteBuf, ParticleDensityProperty> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ParticleDensityProperty::density, (StreamCodec)ByteBufCodecs.DOUBLE, ParticleDensityProperty::radius, (StreamCodec)ByteBufCodecs.optional(ANCodecs.createEnumStreamCodec(ParticleMotion.SpawnType.class)), ParticleDensityProperty::spawnType, ParticleDensityProperty::new);
    private int density;
    private double radius;
    private int maxDensity = 500;
    private int minDensity = 10;
    private double minRadius = 0.05;
    private double maxRadius = 1.0;
    private double initialRadius = 0.1f;
    private int densityStepSize = 10;
    private boolean supportsShapes = true;
    private boolean supportsRadius = true;
    private ParticleMotion.SpawnType spawnType;

    public ParticleDensityProperty() {
        this.density = 10;
        this.radius = 0.3f;
        this.spawnType = ParticleMotion.SpawnType.SPHERE;
    }

    public ParticleDensityProperty(int density, double radius, ParticleMotion.SpawnType spawnType) {
        this.density = density;
        this.radius = radius;
        this.spawnType = spawnType;
    }

    public ParticleDensityProperty(int density, double radius, Optional<ParticleMotion.SpawnType> spawnType) {
        this.density = density;
        this.radius = radius;
        this.spawnType = spawnType.orElse(ParticleMotion.SpawnType.SPHERE);
    }

    public ParticleDensityProperty minDensity(int minDensity) {
        this.minDensity = minDensity;
        return this;
    }

    public ParticleDensityProperty maxDensity(int maxDensity) {
        this.maxDensity = maxDensity;
        return this;
    }

    public ParticleDensityProperty densityStepSize(int stepSize) {
        this.densityStepSize = stepSize;
        return this;
    }

    public ParticleDensityProperty supportsShapes(boolean supportsShapes) {
        this.supportsShapes = supportsShapes;
        return this;
    }

    public ParticleDensityProperty supportsRadius(boolean supportsRadius) {
        this.supportsRadius = supportsRadius;
        return this;
    }

    public ParticleDensityProperty minRadius(double minRadius) {
        this.minRadius = minRadius;
        return this;
    }

    public ParticleDensityProperty maxRadius(double maxRadius) {
        this.maxRadius = maxRadius;
        return this;
    }

    public int density() {
        return this.density;
    }

    public Optional<ParticleMotion.SpawnType> spawnType() {
        return Optional.ofNullable(this.spawnType);
    }

    public double radius() {
        return this.radius;
    }

    @Override
    public ParticleConfigWidgetProvider buildWidgets(int x, int y, int width, int height) {
        return new ParticleConfigWidgetProvider(x, y, width, height){
            HorizontalSlider densitySlider;
            HorizontalSlider radiusSlider;
            SelectedParticleButton selectedButton;

            @Override
            public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.drawHeader(ParticleDensityProperty.this.getName(), graphics, this.x, this.y, this.width, mouseX, mouseY, partialTicks);
                int yOffset = 20;
                if (ParticleDensityProperty.this.supportsShapes) {
                    DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.spawn_header", (Object[])new Object[]{Component.translatable((String)("ars_nouveau.spawn." + ParticleDensityProperty.this.spawnType.name().toLowerCase()))}), graphics, this.x, this.y + yOffset, this.width, mouseX, mouseY, partialTicks);
                    DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.density_slider", (Object[])new Object[]{this.densitySlider.getValueString()}), graphics, this.x, this.y + (yOffset += 32), this.width, mouseX, mouseY, partialTicks);
                } else {
                    DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.density_slider", (Object[])new Object[]{this.densitySlider.getValueString()}), graphics, this.x, this.y + (yOffset += 2), this.width, mouseX, mouseY, partialTicks);
                }
                int sliderSpacing = 25;
                if (ParticleDensityProperty.this.supportsRadius) {
                    DocClientUtils.drawHeaderNoUnderline((Component)Component.translatable((String)"ars_nouveau.radius_slider", (Object[])new Object[]{this.radiusSlider.getValueString()}), graphics, this.x, this.y + (yOffset += sliderSpacing), this.width, mouseX, mouseY, partialTicks);
                }
            }

            @Override
            public void addWidgets(List<AbstractWidget> widgets) {
                ParticleMotion.SpawnType[] values = ParticleMotion.SpawnType.values();
                int yOffset = 30;
                if (ParticleDensityProperty.this.supportsShapes) {
                    for (int i = 0; i < values.length; ++i) {
                        ParticleMotion.SpawnType spawnType1 = values[i];
                        SelectedParticleButton spawnTypeButton = new SelectedParticleButton(this.x + 10 + 20 * i, this.y + yOffset, this.fromShape(spawnType1), button -> {
                            ParticleDensityProperty.this.spawnType = spawnType1;
                            if (button instanceof SelectedParticleButton) {
                                SelectedParticleButton selectedParticleButton = (SelectedParticleButton)button;
                                if (this.selectedButton != null) {
                                    this.selectedButton.selected = false;
                                }
                                this.selectedButton = selectedParticleButton;
                                selectedParticleButton.selected = true;
                            }
                        });
                        spawnTypeButton.withTooltip((Component)Component.translatable((String)("ars_nouveau.spawn." + spawnType1.name().toLowerCase())));
                        if (ParticleDensityProperty.this.spawnType == spawnType1) {
                            spawnTypeButton.selected = true;
                            this.selectedButton = spawnTypeButton;
                        }
                        widgets.add((AbstractWidget)spawnTypeButton);
                    }
                    yOffset += 30;
                }
                int xSliderOffset = this.x + 4;
                this.densitySlider = this.buildSlider(xSliderOffset, this.y + (yOffset += 4), ParticleDensityProperty.this.minDensity, ParticleDensityProperty.this.maxDensity, ParticleDensityProperty.this.densityStepSize, 1, (Component)Component.translatable((String)"ars_nouveau.density_slider"), (Component)Component.empty(), Math.floor((double)(ParticleDensityProperty.this.maxDensity + ParticleDensityProperty.this.minDensity) / 2.0), value -> {
                    ParticleDensityProperty.this.density = this.densitySlider.getValueInt();
                });
                int sliderSpacing = 25;
                this.densitySlider.setValue(Mth.clamp((int)ParticleDensityProperty.this.density, (int)ParticleDensityProperty.this.minDensity, (int)ParticleDensityProperty.this.maxDensity));
                widgets.add((AbstractWidget)this.densitySlider);
                this.radiusSlider = this.buildSlider(xSliderOffset, this.y + (yOffset += sliderSpacing), ParticleDensityProperty.this.minRadius, ParticleDensityProperty.this.maxRadius, 0.05, 1, (Component)Component.translatable((String)"ars_nouveau.radius_slider"), (Component)Component.empty(), ParticleDensityProperty.this.initialRadius, value -> {
                    ParticleDensityProperty.this.radius = this.radiusSlider.getValue();
                });
                this.radiusSlider.setValue(ParticleDensityProperty.this.radius);
                if (ParticleDensityProperty.this.supportsRadius) {
                    widgets.add((AbstractWidget)this.radiusSlider);
                    yOffset += sliderSpacing;
                }
            }

            public HorizontalSlider buildSlider(int x, int y, double min, double max, double stepSize, int precision, Component prefix, Component suffix, double currentVal, Consumer<Double> onValueChange) {
                return new HorizontalSlider(x, y, DocAssets.SLIDER_BAR_FILLED, DocAssets.SLIDER, prefix, suffix, min, max, currentVal, stepSize, precision, false, onValueChange);
            }

            @Override
            public void renderIcon(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, float partialTicks) {
                DocClientUtils.blit(graphics, this.fromShape(ParticleDensityProperty.this.spawnType), x, y);
            }

            public DocAssets.BlitInfo fromShape(ParticleMotion.SpawnType spawnType) {
                if (spawnType == null) {
                    return DocAssets.STYLE_ICON_SPHERE;
                }
                return switch (spawnType) {
                    default -> throw new MatchException(null, null);
                    case ParticleMotion.SpawnType.SPHERE -> DocAssets.STYLE_ICON_SPHERE;
                    case ParticleMotion.SpawnType.CUBE -> DocAssets.STYLE_ICON_CUBE;
                };
            }

            @Override
            public Component getButtonTitle() {
                return ParticleDensityProperty.this.getName();
            }

            @Override
            public void getButtonTooltips(List<Component> tooltip) {
                super.getButtonTooltips(tooltip);
                tooltip.add((Component)Component.translatable((String)"ars_nouveau.density_tooltip"));
            }
        };
    }

    @Override
    public IPropertyType<ParticleDensityProperty> getType() {
        return (IPropertyType)ParticlePropertyRegistry.DENSITY_PROPERTY.get();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticleDensityProperty that = (ParticleDensityProperty)o;
        return this.density == that.density && this.spawnType == that.spawnType && Double.compare(that.radius, this.radius) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.density, this.spawnType, this.radius});
    }

    @Override
    public boolean survivesMotionChange() {
        return false;
    }
}

