/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.hollingsworth.arsnouveau.client.emi.EmiArsNouveauPlugin;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ScryRitualRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EmiScryRitualRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final ScryRitualRecipe recipe;

    public EmiScryRitualRecipe(ResourceLocation id, ScryRitualRecipe recipe) {
        this.id = id;
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiArsNouveauPlugin.SCRY_RITUAL_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of(this.recipe.augment()));
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        for (Holder blockHolder : BuiltInRegistries.BLOCK.getTagOrEmpty(this.recipe.highlight())) {
            outputs.add(EmiStack.of((ItemLike)((ItemLike)blockHolder.value())));
        }
        return outputs;
    }

    public int getDisplayWidth() {
        return 120;
    }

    public int getDisplayHeight() {
        return 24;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addSlot(EmiIngredient.of(this.getInputs()), 6, 4);
        widgets.addFillingArrow(48, 5, 2000);
        widgets.addSlot(EmiIngredient.of(this.getOutputs()), 98, 4).recipeContext((EmiRecipe)this);
    }
}

