/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.block.tile;

import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.timelines.PrestidigitationTimeline;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;

public class ParticleTile
extends ModdedTile
implements ITickable {
    protected PrestidigitationTimeline timeline = new PrestidigitationTimeline();
    public ParticleEmitter particleEmitter;
    public boolean isTemporary;
    public int ticksRemaining;

    public ParticleTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)BlockRegistry.PARTICLE_TILE.get(), pos, state);
    }

    public ParticleTile(BlockEntityType<?> lightTile, BlockPos pos, BlockState state) {
        super(lightTile, pos, state);
    }

    @Override
    public void tick(Level level, BlockState state, BlockPos pos) {
        if (!level.isClientSide && this.isTemporary) {
            if (this.ticksRemaining <= 0) {
                level.removeBlock(pos, false);
                return;
            }
            --this.ticksRemaining;
        }
        if (level.isClientSide && this.particleEmitter != null) {
            this.particleEmitter.tick(level);
        }
    }

    public void playSound() {
        if (this.timeline.randomSound != null && this.timeline.randomSound.sound != null) {
            this.timeline.randomSound.sound.playSound(this.level, this.getX(), this.getY(), this.getZ());
        }
    }

    protected void loadAdditional(@NotNull CompoundTag compound, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.loadAdditional(compound, pRegistries);
        this.timeline = (PrestidigitationTimeline)ANCodecs.decode(PrestidigitationTimeline.CODEC.codec(), (Tag)compound.getCompound("timeline"));
        this.particleEmitter = new ParticleEmitter(() -> this.getBlockPos().getCenter(), () -> new Vec2(0.0f, 0.0f), this.timeline.onTickEffect);
        this.isTemporary = compound.getBoolean("isTemporary");
        this.ticksRemaining = compound.getInt("ticksRemaining");
    }

    public void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("timeline", ANCodecs.encode(PrestidigitationTimeline.CODEC.codec(), this.timeline));
        tag.putBoolean("isTemporary", this.isTemporary);
        tag.putInt("ticksRemaining", this.ticksRemaining);
    }

    public void setTimeline(PrestidigitationTimeline timeline) {
        this.timeline = timeline;
        this.particleEmitter = new ParticleEmitter(() -> this.getBlockPos().getCenter(), () -> new Vec2(0.0f, 0.0f), timeline.onTickEffect);
        this.updateBlock();
    }
}

