/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.particle.timelines.PrestidigitationTimeline;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ReactiveEnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.items.data.PrestidigitationData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrestidigitationRecipe
extends EnchantingApparatusRecipe {
    public PrestidigitationRecipe(List<Ingredient> pedestalItems, int cost) {
        super(Ingredient.EMPTY, ItemStack.EMPTY, pedestalItems, cost, true);
    }

    @Override
    public boolean excludeJei() {
        return true;
    }

    @Override
    public boolean doesReagentMatch(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        return true;
    }

    @Override
    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_346030_) {
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(input.pedestals());
        AbstractCaster<?> caster = SpellCasterRegistry.from(parchment);
        ItemStack result = input.catalyst().copy();
        PrestidigitationData data = new PrestidigitationData((PrestidigitationTimeline)caster.getSpell().particleTimeline().get(ParticleTimelineRegistry.PRESTIDIGITATION_TIMELINE));
        result.set(DataComponentRegistry.PRESTIDIGITATION, (Object)data);
        return result;
    }

    @Override
    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.PRESTIDIGITATION_TYPE.get();
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.PRESTIDIGITATION_SERIALIZER.get();
    }

    public static class Serializer
    implements RecipeSerializer<PrestidigitationRecipe> {
        public static final MapCodec<PrestidigitationRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost)).apply((Applicative)instance, PrestidigitationRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PrestidigitationRecipe> STREAM = CheatSerializer.create(CODEC);

        @NotNull
        public MapCodec<PrestidigitationRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, PrestidigitationRecipe> streamCodec() {
            return STREAM;
        }
    }
}

