/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CheatSerializer;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ITextOutput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ReactiveEnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.items.data.ReactiveCasterData;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpellWriteRecipe
extends EnchantingApparatusRecipe
implements ITextOutput {
    public SpellWriteRecipe(List<Ingredient> pedestalItems, int cost) {
        super(Ingredient.EMPTY, ItemStack.EMPTY, pedestalItems, cost, true);
    }

    @Override
    public boolean excludeJei() {
        return true;
    }

    @Override
    public boolean doesReagentMatch(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        return true;
    }

    @Override
    public boolean matches(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        ItemEnchantments enchantments = (ItemEnchantments)input.catalyst().get(DataComponents.ENCHANTMENTS);
        if (enchantments == null) {
            return false;
        }
        int level1 = enchantments.getLevel(HolderHelper.unwrap(level, EnchantmentRegistry.REACTIVE_ENCHANTMENT));
        if (level1 < 1) {
            return false;
        }
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(input.pedestals());
        return !parchment.isEmpty() && !SpellCasterRegistry.from(parchment).getSpell().isEmpty() && super.matches(input, level, player);
    }

    @Override
    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider p_346030_) {
        ItemStack parchment = ReactiveEnchantmentRecipe.getParchment(input.pedestals());
        AbstractCaster<?> caster = SpellCasterRegistry.from(parchment);
        ItemStack result = input.catalyst().copy();
        ReactiveCasterData data = new ReactiveCasterData((Integer)0, null, (Boolean)false, null, 1, caster.getSpells());
        result.set(DataComponentRegistry.REACTIVE_CASTER, (Object)data);
        return result;
    }

    @Override
    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.SPELL_WRITE_TYPE.get();
    }

    @Override
    public Component getOutputComponent() {
        return Component.translatable((String)"ars_nouveau.spell_write.book_desc");
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.SPELL_WRITE_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<SpellWriteRecipe> {
        public static final MapCodec<SpellWriteRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost)).apply((Applicative)instance, SpellWriteRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SpellWriteRecipe> STREAM = CheatSerializer.create(CODEC);

        @NotNull
        public MapCodec<SpellWriteRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SpellWriteRecipe> streamCodec() {
            return STREAM;
        }
    }
}

