/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity;

import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.entity.goal.chimera.WildenSummon;
import com.hollingsworth.arsnouveau.setup.config.Config;
import com.hollingsworth.arsnouveau.setup.registry.ModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WildenHunter
extends Monster
implements GeoEntity,
IAnimationListener {
    public static final EntityDataAccessor<String> ANIM_STATE = SynchedEntityData.defineId(WildenHunter.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    AnimatableInstanceCache manager = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int ramCooldown = 0;
    public int summonCooldown = 0;
    AnimationController<WildenHunter> controller;
    AnimationController<WildenHunter> runController;
    AnimationController<WildenHunter> idleController;

    public WildenHunter(EntityType<? extends Monster> type, Level worldIn) {
        super(type, worldIn);
    }

    public WildenHunter(Level worldIn) {
        this((EntityType<? extends Monster>)((EntityType)ModEntities.WILDEN_HUNTER.get()), worldIn);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(3, (Goal)new WildenSummon(this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.3f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        if (((Boolean)Config.HUNTER_ATTACK_ANIMALS.get()).booleanValue()) {
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, entity -> !(entity instanceof SummonWolf) || !((SummonWolf)entity).isWildenSummon));
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ANIM_STATE, (Object)Animations.IDLE.name());
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.WOLF_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WOLF_DEATH;
    }

    public int getBaseExperienceReward() {
        return 5;
    }

    protected float getSoundVolume() {
        return 0.4f;
    }

    public void playSound(SoundEvent soundIn, float volume, float pitch) {
        super.playSound(soundIn, volume, pitch - 0.5f);
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WOLF_GROWL;
    }

    public static AttributeSupplier.Builder getModdedAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.6f).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.ATTACK_DAMAGE, 4.5).add(Attributes.ARMOR, 2.0);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.ramCooldown > 0) {
            --this.ramCooldown;
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
    }

    @Override
    public void startAnimation(int arg) {
        try {
            if (this.controller == null) {
                return;
            }
            if (arg == Animations.HOWL.ordinal()) {
                this.controller.forceAnimationReset();
                this.controller.setAnimation(RawAnimation.begin().thenPlay("howl_master").thenPlay("idle"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PlayState attackPredicate(AnimationState<?> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar animatableManager) {
        this.controller = new AnimationController((GeoAnimatable)this, "attackController", 1, this::attackPredicate);
        this.runController = new AnimationController((GeoAnimatable)this, "runController", 1, this::runPredicate);
        this.idleController = new AnimationController((GeoAnimatable)this, "idleController", 1, this::idlePredicate);
        animatableManager.add(this.controller);
        animatableManager.add(this.runController);
        animatableManager.add(this.idleController);
    }

    private <T extends GeoAnimatable> PlayState runPredicate(AnimationState<T> tAnimationState) {
        if (((String)this.getEntityData().get(ANIM_STATE)).equals(Animations.HOWL.name())) {
            return PlayState.STOP;
        }
        if (tAnimationState.isMoving()) {
            tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("run"));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private <T extends GeoAnimatable> PlayState idlePredicate(AnimationState<T> tAnimationState) {
        if (((String)this.getEntityData().get(ANIM_STATE)).equals(Animations.HOWL.name())) {
            return PlayState.STOP;
        }
        if (tAnimationState.isMoving()) {
            return PlayState.STOP;
        }
        tAnimationState.getController().setAnimation(RawAnimation.begin().thenPlay("idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.manager;
    }

    public boolean save(CompoundTag pCompound) {
        pCompound.putInt("summonCooldown", this.summonCooldown);
        return super.save(pCompound);
    }

    public void load(CompoundTag pCompound) {
        super.load(pCompound);
        this.summonCooldown = pCompound.getInt("summonCooldown");
    }

    public static enum Animations {
        ATTACK,
        RAM,
        HOWL,
        IDLE;

    }
}

