/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.TravelToPosState;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HarvestBerryState
extends TravelToPosState {
    public HarvestBerryState(Starbuncle starbuncle, StarbyTransportBehavior behavior, BlockPos target) {
        super(starbuncle, behavior, target, new DecideStarbyActionState(starbuncle, behavior));
    }

    @Override
    public StarbyState onDestinationReached() {
        if (this.level.getBlockState(this.targetPos).getBlock() instanceof SourceBerryBush) {
            int i = (Integer)this.level.getBlockState(this.targetPos).getValue((Property)SourceBerryBush.AGE);
            boolean flag = i == 3;
            this.starbuncle.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ()));
            int j = 1 + this.level.random.nextInt(2);
            SourceBerryBush.popResource((Level)this.level, (BlockPos)this.targetPos, (ItemStack)new ItemStack(BlockRegistry.SOURCEBERRY_BUSH, j + (flag ? 1 : 0)));
            this.level.playSound(null, this.targetPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + this.level.random.nextFloat() * 0.4f);
            this.level.setBlock(this.targetPos, (BlockState)this.level.getBlockState(this.targetPos).setValue((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(1)), 2);
            this.starbuncle.addGoalDebug(this, new DebugEvent("PickedBerry", "Popped berries at " + this.targetPos.getX() + "," + this.targetPos.getY() + "," + this.targetPos.getZ()));
            for (ItemEntity itemEntity : this.level.getEntitiesOfClass(ItemEntity.class, this.starbuncle.getBoundingBox().inflate(2.0))) {
                if (itemEntity.getItem().getItem() != BlockRegistry.SOURCEBERRY_BUSH.asItem()) continue;
                this.starbuncle.pickUpItem(itemEntity);
                break;
            }
            this.starbuncle.getNavigation().stop();
        }
        return super.onDestinationReached();
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return !this.behavior.isPickupDisabled() && this.starbuncle.getHeldStack().isEmpty() && this.level.getBlockState(pos).getBlock() instanceof SourceBerryBush && (Integer)this.level.getBlockState(pos).getValue((Property)SourceBerryBush.AGE) > 1;
    }

    public static BlockPos getNearbyManaBerry(Level world, Starbuncle entity) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.withinManhattan((BlockPos)entity.blockPosition(), (int)10, (int)3, (int)10)) {
            Block state = world.getBlockState(blockpos).getBlock();
            if (!(state instanceof SourceBerryBush) || (Integer)world.getBlockState(blockpos).getValue((Property)SourceBerryBush.AGE) <= 1) continue;
            posList.add(blockpos.immutable());
        }
        return posList.isEmpty() ? null : (BlockPos)posList.get(world.random.nextInt(posList.size()));
    }
}

