/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.entity.IDecoratable;
import com.hollingsworth.arsnouveau.api.item.IRadialProvider;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.GuiRadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenu;
import com.hollingsworth.arsnouveau.client.gui.radial_menu.RadialMenuSlot;
import com.hollingsworth.arsnouveau.client.gui.utils.RenderUtils;
import com.hollingsworth.arsnouveau.client.particle.ColorPos;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.data.DominionWandData;
import com.hollingsworth.arsnouveau.common.network.HighlightAreaPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateDominionWand;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import com.hollingsworth.arsnouveau.setup.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DominionWand
extends ModItem
implements IRadialProvider {
    public DominionWand() {
        super(ItemsRegistry.defaultItemProperties().stacksTo(1).component(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData()));
    }

    public void inventoryTick(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        if (!pIsSelected || pLevel.isClientSide || pLevel.getGameTime() % 5L != 0L) {
            return;
        }
        DominionWandData data = (DominionWandData)pStack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.storedPos().isPresent()) {
            BlockEntity blockEntity = pLevel.getBlockEntity(data.storedPos().get().pos());
            if (blockEntity instanceof IWandable) {
                IWandable wandable = (IWandable)blockEntity;
                Networking.sendToPlayerClient(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
            }
            return;
        }
        Entity entity = pLevel.getEntity(data.getStoredEntity());
        if (entity instanceof IWandable) {
            IWandable wandable = (IWandable)entity;
            Networking.sendToPlayerClient(new HighlightAreaPacket(wandable.getWandHighlight(new ArrayList<ColorPos>()), 10), (ServerPlayer)pEntity);
        }
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack doNotUseStack, Player playerEntity, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        IWandable.Result result;
        IWandable wandable;
        BlockEntity blockEntity;
        Level world;
        if (playerEntity.level.isClientSide || hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = playerEntity.getItemInHand(hand);
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        Level level = playerEntity.level;
        if (playerEntity.isShiftKeyDown() && target instanceof IWandable) {
            IWandable wandable2 = (IWandable)target;
            IWandable.Result result2 = wandable2.onClearConnections(playerEntity);
            this.playSoundFromResult(level, target.getOnPos(), result2);
            this.clear(stack, playerEntity);
            return InteractionResult.SUCCESS;
        }
        if (!data.hasStoredData()) {
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data.storeEntity(target.getId()));
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.stored_entity"));
            return InteractionResult.SUCCESS;
        }
        Object object = world = data.storedPos().isPresent() ? playerEntity.getServer().getLevel(data.storedPos().get().dimension()) : playerEntity.getCommandSenderWorld();
        if (data.storedPos().isPresent() && (blockEntity = world.getBlockEntity(data.storedPos().get().pos())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            result = wandable.onFirstConnection(data.storedPos().orElse(null), data.face().orElse(null), target, playerEntity);
            this.playSoundFromResult(world, target.getOnPos(), result);
        }
        if (target instanceof IWandable) {
            wandable = (IWandable)target;
            result = wandable.onLastConnection(data.storedPos().orElse(null), data.face().orElse(null), target, playerEntity);
            this.playSoundFromResult(world, target.getOnPos(), result);
            this.clear(stack, playerEntity);
        }
        if (playerEntity.isShiftKeyDown() && target instanceof IDecoratable) {
            IDecoratable coolBoy = (IDecoratable)target;
            coolBoy.setCosmeticItem(ItemStack.EMPTY);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean doesSneakBypassUse(@NotNull ItemStack stack, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
        return false;
    }

    public void clear(ItemStack stack, Player player) {
        DominionWandData data = ((DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData())).setFace(null).storeEntity(-1).storePos(null);
        stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Object result;
        IWandable wandable;
        BlockEntity blockEntity;
        BlockEntity blockEntity2;
        Level world;
        if (context.getLevel().isClientSide || context.getPlayer() == null) {
            return super.useOn(context);
        }
        BlockPos pos = context.getClickedPos();
        Direction face = context.getClickedFace();
        Player playerEntity = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        Object object = world = data.storedPos().isPresent() ? playerEntity.getServer().getLevel(data.storedPos().get().dimension()) : context.getLevel();
        if (playerEntity.isShiftKeyDown() && (blockEntity2 = world.getBlockEntity(pos)) instanceof IWandable) {
            IWandable wandable2 = (IWandable)blockEntity2;
            if (!data.hasStoredData()) {
                IWandable.Result result2 = wandable2.onClearConnections(playerEntity);
                this.playSoundFromResult(world, pos, result2);
                this.clear(stack, playerEntity);
                world.playSound(null, pos, (SoundEvent)SoundRegistry.DOMINION_WAND_CLEAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
        }
        if (!data.hasStoredData()) {
            if ((data = data.storePos(new GlobalPos(context.getLevel().dimension(), pos))).strict()) {
                data = data.setFace(face);
            }
            stack.set(DataComponentRegistry.DOMINION_WAND, (Object)data);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_set"));
            this.playSoundFromResult(playerEntity.level, pos, IWandable.Result.SELECT);
            return InteractionResult.SUCCESS;
        }
        GlobalPos storedPos = data.storedPos().orElse(null);
        Direction storedDirection = data.face().orElse(null);
        if (storedPos != null && (blockEntity = world.getBlockEntity(storedPos.pos())) instanceof IWandable) {
            wandable = (IWandable)blockEntity;
            result = wandable.onFirstConnection(new GlobalPos(world.dimension(), pos), storedDirection, (LivingEntity)world.getEntity(data.storedEntityId()), playerEntity);
            this.playSoundFromResult(world, pos, (IWandable.Result)((Object)result));
        }
        if ((result = world.getBlockEntity(pos)) instanceof IWandable) {
            wandable = (IWandable)result;
            result = wandable.onLastConnection(storedPos, storedDirection, (LivingEntity)world.getEntity(data.storedEntityId()), playerEntity);
            this.playSoundFromResult(world, pos, (IWandable.Result)((Object)result));
        }
        if (data.storedEntityId() != -1 && (result = world.getEntity(data.storedEntityId())) instanceof IWandable) {
            wandable = (IWandable)result;
            result = wandable.onFirstConnection(new GlobalPos(world.dimension(), pos), (Direction)(data.strict() ? face : null), null, playerEntity);
            this.playSoundFromResult(world, pos, (IWandable.Result)((Object)result));
        }
        this.clear(stack, playerEntity);
        return super.useOn(context);
    }

    @NotNull
    public String getDescriptionId(ItemStack pStack) {
        DominionWandData data = (DominionWandData)pStack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.strict()) {
            return super.getDescriptionId(pStack) + ".strict";
        }
        return super.getDescriptionId(pStack);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext world, @NotNull List<Component> tooltip, @NotNull TooltipFlag p_77624_4_) {
        DominionWandData data = (DominionWandData)stack.getOrDefault(DataComponentRegistry.DOMINION_WAND, (Object)new DominionWandData());
        if (data.storedEntityId() == -1) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.no_entity"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.entity_stored"));
        }
        if (data.storedPos().isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.no_location"));
        } else {
            tooltip.add((Component)Component.translatable((String)"ars_nouveau.dominion_wand.position_stored", (Object[])new Object[]{DominionWand.getGlobalPosString(data.getValidPos())}));
        }
        if (data.strict()) {
            tooltip.add((Component)Component.literal((String)"Side-Sensitive"));
        }
    }

    public static String getPosString(BlockPos pos) {
        return Component.translatable((String)"ars_nouveau.position", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).getString();
    }

    public static String getGlobalPosString(GlobalPos globalPos) {
        BlockPos pos = globalPos.pos();
        ResourceLocation dimLoc = globalPos.dimension().location();
        String translationKey = dimLoc.getPath() + "." + dimLoc.getNamespace() + ".name";
        String translation = Component.translatable((String)translationKey).getString();
        return Component.translatable((String)"ars_nouveau.global_position", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), translation.equals(translationKey) ? dimLoc.toString() : translation}).getString();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRadialKeyPressed(ItemStack stack, Player player) {
        Minecraft.getInstance().setScreen(new GuiRadialMenu<String>(this.getRadialMenuProviderForDominion(stack)));
    }

    public RadialMenu<String> getRadialMenuProviderForDominion(ItemStack stack) {
        return new RadialMenu<String>(slot -> Networking.sendToServer(new PacketUpdateDominionWand(slot)), this.getRadialMenuSlotsForDominion(stack), RenderUtils::drawString, 0);
    }

    public List<RadialMenuSlot<String>> getRadialMenuSlotsForDominion(ItemStack stack) {
        ArrayList<RadialMenuSlot<String>> radialMenuSlots = new ArrayList<RadialMenuSlot<String>>();
        radialMenuSlots.add(new RadialMenuSlot<String>(DominionSlots.CLEAR.translatable().getString(), DominionSlots.CLEAR.key));
        radialMenuSlots.add(new RadialMenuSlot<String>(DominionSlots.NORMAL.translatable().getString(), DominionSlots.NORMAL.key));
        radialMenuSlots.add(new RadialMenuSlot<String>(DominionSlots.STRICT.translatable().getString(), DominionSlots.STRICT.key));
        return radialMenuSlots;
    }

    public void playSoundFromResult(Level level, BlockPos at, IWandable.Result result) {
        switch (result) {
            case SUCCESS: {
                level.playSound(null, at, (SoundEvent)SoundRegistry.DOMINION_WAND_SUCCESS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case FAIL: {
                level.playSound(null, at, (SoundEvent)SoundRegistry.DOMINION_WAND_FAIL.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case SELECT: {
                level.playSound(null, at, (SoundEvent)SoundRegistry.DOMINION_WAND_SELECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case CLEAR: {
                level.playSound(null, at, (SoundEvent)SoundRegistry.DOMINION_WAND_CLEAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
        }
    }

    public static enum DominionSlots {
        CLEAR("ars_nouveau.dominion_wand.clear"),
        NORMAL("ars_nouveau.dominion_wand.normal"),
        STRICT("ars_nouveau.dominion_wand.strict");

        public final String key;

        private DominionSlots(String key) {
            this.key = key;
        }

        public Component translatable() {
            return Component.translatable((String)this.key);
        }
    }
}

