/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.item.ICasterTool;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.PlayerCaster;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.entity.EntitySpellArrow;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SpellArrow
extends ArrowItem {
    public AbstractSpellPart part;
    public int numParts;

    public SpellArrow(AbstractAugment augment, int numParts) {
        super(ItemsRegistry.defaultItemProperties());
        this.part = augment;
        this.numParts = numParts;
    }

    public void modifySpell(Spell.Mutable spell) {
        for (int i = 0; i < this.numParts; ++i) {
            spell.recipe.add(this.part);
        }
    }

    public AbstractArrow createArrow(Level world, ItemStack stack, LivingEntity shooter, @Nullable ItemStack bowStack) {
        Item item;
        Player entity;
        EntitySpellArrow spellArrow;
        block5: {
            block4: {
                ManaCap mana = CapabilityRegistry.getMana(shooter);
                if (mana == null) {
                    return new Arrow(world, shooter, new ItemStack((ItemLike)Items.ARROW), bowStack);
                }
                spellArrow = new EntitySpellArrow(world, shooter, ItemStack.EMPTY, bowStack);
                if (!(shooter instanceof Player)) break block4;
                entity = (Player)shooter;
                item = shooter.getMainHandItem().getItem();
                if (item instanceof ICasterTool) break block5;
            }
            return super.createArrow(world, stack, shooter, bowStack);
        }
        ICasterTool caster = (ICasterTool)item;
        AbstractCaster<?> spellCaster = caster.getSpellCaster(entity.getMainHandItem());
        Spell.Mutable mutableSpell = spellCaster.getSpell().mutable();
        this.modifySpell(mutableSpell);
        spellArrow.setResolver(new SpellResolver(new SpellContext(world, mutableSpell.immutable(), (LivingEntity)entity, new PlayerCaster(entity), shooter.getMainHandItem())).withSilent(true));
        spellArrow.pierceLeft = mutableSpell.immutable().getBuffsAtIndex(0, shooter, AugmentPierce.INSTANCE);
        return spellArrow;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        pTooltipComponents.add((Component)Component.translatable((String)"ars_nouveau.spell_arrow.desc"));
        Spell.Mutable spell = new Spell().mutable();
        for (int i = 0; i < this.numParts; ++i) {
            spell.recipe.add(this.part);
        }
        pTooltipComponents.add((Component)Component.literal((String)spell.immutable().getDisplayString()));
    }
}

