/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.network;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.registry.ParticleColorRegistry;
import com.hollingsworth.arsnouveau.api.registry.SpellCasterRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractCaster;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOpenSpellBook;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateBookGUI;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class PacketUpdateSpellColors
extends AbstractPacket {
    int castSlot;
    ParticleColor color;
    boolean mainHand;
    public static final CustomPacketPayload.Type<PacketUpdateSpellColors> TYPE = new CustomPacketPayload.Type(ArsNouveau.prefix("update_spell_colors"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateSpellColors> CODEC = StreamCodec.ofMember(PacketUpdateSpellColors::toBytes, PacketUpdateSpellColors::new);

    public PacketUpdateSpellColors(int slot, ParticleColor color, boolean mainHand) {
        this.castSlot = slot;
        this.color = color;
        this.mainHand = mainHand;
    }

    public PacketUpdateSpellColors(RegistryFriendlyByteBuf buf) {
        this.castSlot = buf.readInt();
        this.color = ParticleColorRegistry.from(buf.readNbt());
        this.mainHand = buf.readBoolean();
    }

    @Override
    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.castSlot);
        buf.writeNbt((Tag)this.color.serialize());
        buf.writeBoolean(this.mainHand);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        ItemStack stack = player.getItemInHand(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        if (stack.getItem() instanceof SpellBook) {
            AbstractCaster<?> caster = SpellCasterRegistry.from(stack);
            ((AbstractCaster)((AbstractCaster)caster.setColor(this.color, this.castSlot)).setCurrentSlot(this.castSlot)).saveToStack(stack);
            Networking.sendToPlayerClient(new PacketUpdateBookGUI(stack), player);
            Networking.sendToPlayerClient(new PacketOpenSpellBook(this.mainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND), player);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

