/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.analysis.synonym;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.analysis.synonym.SynonymMap;
import org.apache.lucene.ars_nouveau.util.CharsRef;
import org.apache.lucene.ars_nouveau.util.CharsRefBuilder;

public class SolrSynonymParser
extends SynonymMap.Parser {
    private final boolean expand;

    public SolrSynonymParser(boolean dedup, boolean expand, Analyzer analyzer) {
        super(dedup, analyzer);
        this.expand = expand;
    }

    @Override
    public void parse(Reader in) throws IOException, ParseException {
        try (LineNumberReader br = new LineNumberReader(in);){
            this.addInternal(br);
        }
    }

    private void addInternal(BufferedReader in) throws IOException {
        String line = null;
        while ((line = in.readLine()) != null) {
            int i;
            CharsRef[] inputs;
            String[] inputStrings;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] sides = SolrSynonymParser.split(line, "=>");
            if (sides.length > 1) {
                int i2;
                if (sides.length != 2) {
                    throw new IllegalArgumentException("more than one explicit mapping specified on the same line");
                }
                inputStrings = SolrSynonymParser.split(sides[0], ",");
                inputs = new CharsRef[inputStrings.length];
                for (int i3 = 0; i3 < inputs.length; ++i3) {
                    inputs[i3] = this.analyze(this.unescape(inputStrings[i3]).trim(), new CharsRefBuilder());
                }
                String[] outputStrings = SolrSynonymParser.split(sides[1], ",");
                CharsRef[] outputs = new CharsRef[outputStrings.length];
                for (i2 = 0; i2 < outputs.length; ++i2) {
                    outputs[i2] = this.analyze(this.unescape(outputStrings[i2]).trim(), new CharsRefBuilder());
                }
                for (i2 = 0; i2 < inputs.length; ++i2) {
                    for (int j = 0; j < outputs.length; ++j) {
                        this.add(inputs[i2], outputs[j], false);
                    }
                }
                continue;
            }
            inputStrings = SolrSynonymParser.split(line, ",");
            inputs = new CharsRef[inputStrings.length];
            for (i = 0; i < inputs.length; ++i) {
                inputs[i] = this.analyze(this.unescape(inputStrings[i]).trim(), new CharsRefBuilder());
            }
            if (this.expand) {
                for (i = 0; i < inputs.length; ++i) {
                    for (int j = 0; j < inputs.length; ++j) {
                        if (i == j) continue;
                        this.add(inputs[i], inputs[j], true);
                    }
                }
                continue;
            }
            for (i = 0; i < inputs.length; ++i) {
                this.add(inputs[i], inputs[0], false);
            }
        }
    }

    private static String[] split(String s, String separator) {
        ArrayList<String> list = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s.length();
        while (pos < end) {
            char ch;
            if (s.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    list.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s.charAt(pos++)) == '\\') {
                sb.append(ch);
                if (pos >= end) break;
                ch = s.charAt(pos++);
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    private String unescape(String s) {
        if (s.indexOf(92) >= 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                if (ch == '\\' && i < s.length() - 1) {
                    sb.append(s.charAt(++i));
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return s;
    }
}

