/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.index;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.lucene.ars_nouveau.analysis.Analyzer;
import org.apache.lucene.ars_nouveau.codecs.Codec;
import org.apache.lucene.ars_nouveau.index.ConcurrentMergeScheduler;
import org.apache.lucene.ars_nouveau.index.FlushByRamOrCountsPolicy;
import org.apache.lucene.ars_nouveau.index.FlushPolicy;
import org.apache.lucene.ars_nouveau.index.IndexCommit;
import org.apache.lucene.ars_nouveau.index.IndexDeletionPolicy;
import org.apache.lucene.ars_nouveau.index.IndexWriter;
import org.apache.lucene.ars_nouveau.index.IndexWriterConfig;
import org.apache.lucene.ars_nouveau.index.IndexWriterEventListener;
import org.apache.lucene.ars_nouveau.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.ars_nouveau.index.LeafReader;
import org.apache.lucene.ars_nouveau.index.MergePolicy;
import org.apache.lucene.ars_nouveau.index.MergeScheduler;
import org.apache.lucene.ars_nouveau.index.TieredMergePolicy;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.Sort;
import org.apache.lucene.ars_nouveau.search.similarities.Similarity;
import org.apache.lucene.ars_nouveau.util.InfoStream;
import org.apache.lucene.ars_nouveau.util.Version;

public class LiveIndexWriterConfig {
    private final Analyzer analyzer;
    private volatile int maxBufferedDocs;
    private volatile double ramBufferSizeMB;
    private volatile IndexWriter.IndexReaderWarmer mergedSegmentWarmer;
    protected volatile IndexDeletionPolicy delPolicy;
    protected volatile IndexCommit commit;
    protected volatile IndexWriterConfig.OpenMode openMode;
    protected int createdVersionMajor;
    protected volatile Similarity similarity;
    protected volatile MergeScheduler mergeScheduler;
    protected volatile Codec codec;
    protected volatile InfoStream infoStream;
    protected volatile MergePolicy mergePolicy;
    protected volatile boolean readerPooling;
    protected volatile FlushPolicy flushPolicy;
    protected volatile int perThreadHardLimitMB;
    protected volatile boolean useCompoundFile;
    protected boolean commitOnClose;
    protected Sort indexSort;
    protected Comparator<LeafReader> leafSorter;
    protected Set<String> indexSortFields;
    protected String parentField;
    protected volatile boolean checkPendingFlushOnUpdate;
    protected String softDeletesField;
    protected volatile long maxFullFlushMergeWaitMillis;
    protected IndexWriterEventListener eventListener;

    LiveIndexWriterConfig(Analyzer analyzer) {
        this.createdVersionMajor = Version.LATEST.major;
        this.commitOnClose = true;
        this.indexSort = null;
        this.indexSortFields = Collections.emptySet();
        this.parentField = null;
        this.checkPendingFlushOnUpdate = true;
        this.softDeletesField = null;
        this.analyzer = analyzer;
        this.ramBufferSizeMB = 16.0;
        this.maxBufferedDocs = -1;
        this.mergedSegmentWarmer = null;
        this.delPolicy = new KeepOnlyLastCommitDeletionPolicy();
        this.commit = null;
        this.useCompoundFile = true;
        this.openMode = IndexWriterConfig.OpenMode.CREATE_OR_APPEND;
        this.similarity = IndexSearcher.getDefaultSimilarity();
        this.mergeScheduler = new ConcurrentMergeScheduler();
        this.codec = Codec.getDefault();
        if (this.codec == null) {
            throw new NullPointerException();
        }
        this.infoStream = InfoStream.getDefault();
        this.mergePolicy = new TieredMergePolicy();
        this.flushPolicy = new FlushByRamOrCountsPolicy();
        this.readerPooling = true;
        this.perThreadHardLimitMB = 1945;
        this.maxFullFlushMergeWaitMillis = 500L;
        this.eventListener = IndexWriterEventListener.NO_OP_LISTENER;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public synchronized LiveIndexWriterConfig setRAMBufferSizeMB(double ramBufferSizeMB) {
        if (ramBufferSizeMB != -1.0 && ramBufferSizeMB <= 0.0) {
            throw new IllegalArgumentException("ramBufferSize should be > 0.0 MB when enabled");
        }
        if (ramBufferSizeMB == -1.0 && this.maxBufferedDocs == -1) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.ramBufferSizeMB = ramBufferSizeMB;
        return this;
    }

    public double getRAMBufferSizeMB() {
        return this.ramBufferSizeMB;
    }

    public synchronized LiveIndexWriterConfig setMaxBufferedDocs(int maxBufferedDocs) {
        if (maxBufferedDocs != -1 && maxBufferedDocs < 2) {
            throw new IllegalArgumentException("maxBufferedDocs must at least be 2 when enabled");
        }
        if (maxBufferedDocs == -1 && this.ramBufferSizeMB == -1.0) {
            throw new IllegalArgumentException("at least one of ramBufferSize and maxBufferedDocs must be enabled");
        }
        this.maxBufferedDocs = maxBufferedDocs;
        return this;
    }

    public int getMaxBufferedDocs() {
        return this.maxBufferedDocs;
    }

    public LiveIndexWriterConfig setMergePolicy(MergePolicy mergePolicy) {
        if (mergePolicy == null) {
            throw new IllegalArgumentException("mergePolicy must not be null");
        }
        this.mergePolicy = mergePolicy;
        return this;
    }

    public LiveIndexWriterConfig setMergedSegmentWarmer(IndexWriter.IndexReaderWarmer mergeSegmentWarmer) {
        this.mergedSegmentWarmer = mergeSegmentWarmer;
        return this;
    }

    public IndexWriter.IndexReaderWarmer getMergedSegmentWarmer() {
        return this.mergedSegmentWarmer;
    }

    public IndexWriterConfig.OpenMode getOpenMode() {
        return this.openMode;
    }

    public int getIndexCreatedVersionMajor() {
        return this.createdVersionMajor;
    }

    public IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.delPolicy;
    }

    public IndexCommit getIndexCommit() {
        return this.commit;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public MergeScheduler getMergeScheduler() {
        return this.mergeScheduler;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public MergePolicy getMergePolicy() {
        return this.mergePolicy;
    }

    public boolean getReaderPooling() {
        return this.readerPooling;
    }

    public int getRAMPerThreadHardLimitMB() {
        return this.perThreadHardLimitMB;
    }

    FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    public LiveIndexWriterConfig setUseCompoundFile(boolean useCompoundFile) {
        this.useCompoundFile = useCompoundFile;
        return this;
    }

    public boolean getUseCompoundFile() {
        return this.useCompoundFile;
    }

    public boolean getCommitOnClose() {
        return this.commitOnClose;
    }

    public Sort getIndexSort() {
        return this.indexSort;
    }

    public Set<String> getIndexSortFields() {
        return this.indexSortFields;
    }

    public Comparator<LeafReader> getLeafSorter() {
        return this.leafSorter;
    }

    public boolean isCheckPendingFlushOnUpdate() {
        return this.checkPendingFlushOnUpdate;
    }

    public LiveIndexWriterConfig setCheckPendingFlushUpdate(boolean checkPendingFlushOnUpdate) {
        this.checkPendingFlushOnUpdate = checkPendingFlushOnUpdate;
        return this;
    }

    public String getSoftDeletesField() {
        return this.softDeletesField;
    }

    public long getMaxFullFlushMergeWaitMillis() {
        return this.maxFullFlushMergeWaitMillis;
    }

    public IndexWriterEventListener getIndexWriterEventListener() {
        return this.eventListener;
    }

    public String getParentField() {
        return this.parentField;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("analyzer=").append(this.analyzer == null ? "null" : this.analyzer.getClass().getName()).append("\n");
        sb.append("ramBufferSizeMB=").append(this.getRAMBufferSizeMB()).append("\n");
        sb.append("maxBufferedDocs=").append(this.getMaxBufferedDocs()).append("\n");
        sb.append("mergedSegmentWarmer=").append(this.getMergedSegmentWarmer()).append("\n");
        sb.append("delPolicy=").append(this.getIndexDeletionPolicy().getClass().getName()).append("\n");
        IndexCommit commit = this.getIndexCommit();
        sb.append("commit=").append(commit == null ? "null" : commit).append("\n");
        sb.append("openMode=").append((Object)this.getOpenMode()).append("\n");
        sb.append("similarity=").append(this.getSimilarity().getClass().getName()).append("\n");
        sb.append("mergeScheduler=").append(this.getMergeScheduler()).append("\n");
        sb.append("codec=").append(this.getCodec()).append("\n");
        sb.append("infoStream=").append(this.getInfoStream().getClass().getName()).append("\n");
        sb.append("mergePolicy=").append(this.getMergePolicy()).append("\n");
        sb.append("readerPooling=").append(this.getReaderPooling()).append("\n");
        sb.append("perThreadHardLimitMB=").append(this.getRAMPerThreadHardLimitMB()).append("\n");
        sb.append("useCompoundFile=").append(this.getUseCompoundFile()).append("\n");
        sb.append("commitOnClose=").append(this.getCommitOnClose()).append("\n");
        sb.append("indexSort=").append(this.getIndexSort()).append("\n");
        sb.append("checkPendingFlushOnUpdate=").append(this.isCheckPendingFlushOnUpdate()).append("\n");
        sb.append("softDeletesField=").append(this.getSoftDeletesField()).append("\n");
        sb.append("maxFullFlushMergeWaitMillis=").append(this.getMaxFullFlushMergeWaitMillis()).append("\n");
        sb.append("leafSorter=").append(this.getLeafSorter()).append("\n");
        sb.append("eventListener=").append(this.getIndexWriterEventListener()).append("\n");
        sb.append("parentField=").append(this.getParentField()).append("\n");
        return sb.toString();
    }
}

