/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.index.ByteVectorValues;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.search.AbstractVectorSimilarityQuery;
import org.apache.lucene.ars_nouveau.search.KnnCollector;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.TopDocs;
import org.apache.lucene.ars_nouveau.search.VectorScorer;
import org.apache.lucene.ars_nouveau.search.knn.KnnCollectorManager;
import org.apache.lucene.ars_nouveau.util.Bits;

public class ByteVectorSimilarityQuery
extends AbstractVectorSimilarityQuery {
    private final byte[] target;

    public ByteVectorSimilarityQuery(String field, byte[] target, float traversalSimilarity, float resultSimilarity, Query filter) {
        super(field, traversalSimilarity, resultSimilarity, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float traversalSimilarity, float resultSimilarity) {
        this(field, target, traversalSimilarity, resultSimilarity, null);
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float resultSimilarity, Query filter) {
        this(field, target, resultSimilarity, resultSimilarity, filter);
    }

    public ByteVectorSimilarityQuery(String field, byte[] target, float resultSimilarity) {
        this(field, target, resultSimilarity, resultSimilarity, null);
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context) throws IOException {
        ByteVectorValues vectorValues = context.reader().getByteVectorValues(this.field);
        if (vectorValues == null) {
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        KnnCollector collector = knnCollectorManager.newCollector(visitLimit, context);
        context.reader().searchNearestVectors(this.field, this.target, collector, acceptDocs);
        return collector.topDocs();
    }

    @Override
    public String toString(String field) {
        return String.format(Locale.ROOT, "%s[field=%s target=[%d...] traversalSimilarity=%f resultSimilarity=%f filter=%s]", this.getClass().getSimpleName(), field, this.target[0], Float.valueOf(this.traversalSimilarity), Float.valueOf(this.resultSimilarity), this.filter);
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o) && super.equals(o) && Arrays.equals(this.target, ((ByteVectorSimilarityQuery)o).target);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.target);
        return result;
    }
}

