/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.Scorable;
import org.apache.lucene.ars_nouveau.search.ScoreMode;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.TwoPhaseIterator;

class ReqOptSumScorer
extends Scorer {
    private final Scorer reqScorer;
    private final Scorer optScorer;
    private final DocIdSetIterator reqApproximation;
    private final DocIdSetIterator optApproximation;
    private final TwoPhaseIterator optTwoPhase;
    private final DocIdSetIterator approximation;
    private final TwoPhaseIterator twoPhase;
    private float minScore = 0.0f;
    private final float reqMaxScore;
    private boolean optIsRequired;

    public ReqOptSumScorer(final Scorer reqScorer, Scorer optScorer, ScoreMode scoreMode) throws IOException {
        assert (reqScorer != null);
        assert (optScorer != null);
        this.reqScorer = reqScorer;
        this.optScorer = optScorer;
        final TwoPhaseIterator reqTwoPhase = reqScorer.twoPhaseIterator();
        this.optTwoPhase = optScorer.twoPhaseIterator();
        this.reqApproximation = reqTwoPhase == null ? reqScorer.iterator() : reqTwoPhase.approximation();
        this.optApproximation = this.optTwoPhase == null ? optScorer.iterator() : this.optTwoPhase.approximation();
        if (scoreMode != ScoreMode.TOP_SCORES) {
            this.approximation = this.reqApproximation;
            this.reqMaxScore = Float.POSITIVE_INFINITY;
        } else {
            reqScorer.advanceShallow(0);
            optScorer.advanceShallow(0);
            this.reqMaxScore = reqScorer.getMaxScore(Integer.MAX_VALUE);
            this.approximation = new DocIdSetIterator(){
                int upTo = -1;
                float maxScore;

                private void moveToNextBlock(int target) throws IOException {
                    this.upTo = ReqOptSumScorer.this.advanceShallow(target);
                    float reqMaxScoreBlock = reqScorer.getMaxScore(this.upTo);
                    this.maxScore = ReqOptSumScorer.this.getMaxScore(this.upTo);
                    ReqOptSumScorer.this.optIsRequired = reqMaxScoreBlock < ReqOptSumScorer.this.minScore;
                }

                private int advanceImpacts(int target) throws IOException {
                    if (target > this.upTo) {
                        this.moveToNextBlock(target);
                    }
                    while (!(this.maxScore >= ReqOptSumScorer.this.minScore)) {
                        if (this.upTo == Integer.MAX_VALUE) {
                            return Integer.MAX_VALUE;
                        }
                        target = this.upTo + 1;
                        this.moveToNextBlock(target);
                    }
                    return target;
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advanceInternal(ReqOptSumScorer.this.reqApproximation.docID() + 1);
                }

                @Override
                public int advance(int target) throws IOException {
                    return this.advanceInternal(target);
                }

                /*
                 * Unable to fully structure code
                 */
                private int advanceInternal(int target) throws IOException {
                    if (target == 0x7FFFFFFF) {
                        ReqOptSumScorer.this.reqApproximation.advance(target);
                        return 0x7FFFFFFF;
                    }
                    reqDoc = target;
                    block0: while (true) {
                        if (ReqOptSumScorer.this.minScore != 0.0f) {
                            reqDoc = this.advanceImpacts(reqDoc);
                        }
                        if (ReqOptSumScorer.this.reqApproximation.docID() < reqDoc) {
                            reqDoc = ReqOptSumScorer.this.reqApproximation.advance(reqDoc);
                        }
                        if (reqDoc == 0x7FFFFFFF || !ReqOptSumScorer.this.optIsRequired) {
                            return reqDoc;
                        }
                        upperBound = ReqOptSumScorer.this.reqMaxScore < ReqOptSumScorer.this.minScore ? 0x7FFFFFFF : this.upTo;
                        if (reqDoc > upperBound) continue;
                        do {
                            if ((optDoc = ReqOptSumScorer.this.optApproximation.docID()) < reqDoc) {
                                optDoc = ReqOptSumScorer.this.optApproximation.advance(reqDoc);
                            }
                            if (optDoc > upperBound) {
                                reqDoc = upperBound + 1;
                                continue block0;
                            }
                            if (optDoc == reqDoc || (reqDoc = ReqOptSumScorer.this.reqApproximation.advance(optDoc)) <= upperBound) ** break;
                            continue block0;
                        } while (reqDoc != 0x7FFFFFFF && optDoc != reqDoc);
                        break;
                    }
                    return reqDoc;
                }

                @Override
                public int docID() {
                    return ReqOptSumScorer.this.reqApproximation.docID();
                }

                @Override
                public long cost() {
                    return ReqOptSumScorer.this.reqApproximation.cost();
                }
            };
        }
        this.twoPhase = reqTwoPhase == null && this.optTwoPhase == null ? null : new TwoPhaseIterator(this.approximation){

            @Override
            public boolean matches() throws IOException {
                if (reqTwoPhase != null && !reqTwoPhase.matches()) {
                    return false;
                }
                if (ReqOptSumScorer.this.optTwoPhase != null) {
                    if (ReqOptSumScorer.this.optIsRequired) {
                        if (reqScorer.docID() != ReqOptSumScorer.this.optApproximation.docID()) {
                            if (ReqOptSumScorer.this.optApproximation.docID() < reqScorer.docID()) {
                                ReqOptSumScorer.this.optApproximation.advance(reqScorer.docID());
                            }
                            if (reqScorer.docID() != ReqOptSumScorer.this.optApproximation.docID()) {
                                return false;
                            }
                        }
                        if (!ReqOptSumScorer.this.optTwoPhase.matches()) {
                            ReqOptSumScorer.this.optApproximation.nextDoc();
                            return false;
                        }
                    } else if (ReqOptSumScorer.this.optApproximation.docID() == reqScorer.docID() && !ReqOptSumScorer.this.optTwoPhase.matches()) {
                        ReqOptSumScorer.this.optApproximation.nextDoc();
                    }
                }
                return true;
            }

            @Override
            public float matchCost() {
                float matchCost = 1.0f;
                if (reqTwoPhase != null) {
                    matchCost += reqTwoPhase.matchCost();
                }
                if (ReqOptSumScorer.this.optTwoPhase != null) {
                    matchCost += ReqOptSumScorer.this.optTwoPhase.matchCost();
                }
                return matchCost;
            }
        };
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        return this.twoPhase;
    }

    @Override
    public DocIdSetIterator iterator() {
        if (this.twoPhase == null) {
            return this.approximation;
        }
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhase);
    }

    @Override
    public int docID() {
        return this.reqScorer.docID();
    }

    @Override
    public float score() throws IOException {
        int curDoc = this.reqScorer.docID();
        float score = this.reqScorer.score();
        int optScorerDoc = this.optApproximation.docID();
        if (optScorerDoc < curDoc) {
            optScorerDoc = this.optApproximation.advance(curDoc);
            if (this.optTwoPhase != null && optScorerDoc == curDoc && !this.optTwoPhase.matches()) {
                optScorerDoc = this.optApproximation.nextDoc();
            }
        }
        if (optScorerDoc == curDoc) {
            score += this.optScorer.score();
        }
        return score;
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        int upTo = this.reqScorer.advanceShallow(target);
        if (this.optScorer.docID() <= target) {
            upTo = Math.min(upTo, this.optScorer.advanceShallow(target));
        } else if (this.optScorer.docID() != Integer.MAX_VALUE) {
            upTo = Math.min(upTo, this.optScorer.docID() - 1);
        }
        return upTo;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        float maxScore = this.reqScorer.getMaxScore(upTo);
        if (this.optScorer.docID() <= upTo) {
            maxScore += this.optScorer.getMaxScore(upTo);
        }
        return maxScore;
    }

    @Override
    public void setMinCompetitiveScore(float minScore) throws IOException {
        this.minScore = minScore;
        if (this.reqMaxScore < minScore) {
            this.optIsRequired = true;
            if (this.reqMaxScore == 0.0f) {
                this.optScorer.setMinCompetitiveScore(minScore);
            }
        }
    }

    @Override
    public Collection<Scorable.ChildScorable> getChildren() {
        ArrayList<Scorable.ChildScorable> children = new ArrayList<Scorable.ChildScorable>(2);
        children.add(new Scorable.ChildScorable(this.reqScorer, "MUST"));
        children.add(new Scorable.ChildScorable(this.optScorer, "SHOULD"));
        return children;
    }
}

