/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.config.ConfigScreens;
import pigcart.cosycritters.mixin.access.ParticleEngineAccessor;

public class CosyCritters {
    public static final String MOD_ID = "cosycritters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cosycritters");
    public static class_2400 BIRD;
    public static class_2400 HAT_MAN;
    public static class_2400 MOTH;
    public static class_2400 SPIDER;
    private static boolean wasSleeping;

    private static List<String> getDebugStrings() {
        return List.of(String.format("Birds: %d/%d", Util.getCount(ConfigManager.birdGroup), Util.getLimit(ConfigManager.birdGroup)), String.format("Moths: %d/%d", Util.getCount(ConfigManager.mothGroup), Util.getLimit(ConfigManager.mothGroup)), String.format("Spiders: %d/%d", Util.getCount(ConfigManager.spiderGroup), Util.getLimit(ConfigManager.spiderGroup)), "Tracked: " + ((ParticleEngineAccessor)class_310.method_1551().field_1713).getTrackedParticleCounts().toString());
    }

    public static void onInitializeClient() {
        ConfigManager.loadConfig();
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            Util.schedule(() -> class_310.method_1551().method_1507(ConfigScreens.generateMainConfigScreen(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            CosyCritters.getDebugStrings().forEach(Util::addChatMsg);
            return 0;
        }));
    }

    public static void doAnimateTick(class_2338 blockPos, class_2680 state) {
        CosyCritters.trySpawnMoth((class_1937)class_310.method_1551().field_1687, blockPos);
    }

    public static void onTick(class_310 minecraft) {
        if (minecraft.field_1724 != null) {
            CosyCritters.tickHatManSpawnConditions(minecraft);
        }
    }

    private static void tickHatManSpawnConditions(class_310 minecraft) {
        if (minecraft.field_1687.method_8597().method_28531(minecraft.field_1687.method_30271()) == 4) {
            if (minecraft.field_1724.method_6113()) {
                if (!wasSleeping) {
                    CosyCritters.trySpawnHatman(minecraft);
                    wasSleeping = true;
                }
            } else if (wasSleeping) {
                wasSleeping = false;
            }
        }
    }

    private static void trySpawnHatman(class_310 minecraft) {
        class_2753 property;
        class_2680 state;
        if (!ConfigManager.config.spawnHatman) {
            return;
        }
        Optional sleepingPos = minecraft.field_1724.method_18398();
        if (sleepingPos.isPresent() && (state = minecraft.field_1687.method_8320((class_2338)sleepingPos.get())).method_28498((class_2769)(property = class_2741.field_12481))) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)property);
            class_2338 blockPos = class_2338.method_49638((class_2374)minecraft.field_1724.method_19538()).method_10079(direction.method_10153(), 2);
            class_243 pos = blockPos.method_46558();
            class_5819 random = minecraft.field_1724.method_59922();
            class_243 randomPos = new class_243(pos.field_1352 + (double)random.method_43048(2) - 1.0, pos.field_1351, pos.field_1350 + (double)random.method_43048(2) - 1.0);
            if (minecraft.field_1687.method_8320(class_2338.method_49638((class_2374)randomPos)).method_26215()) {
                minecraft.field_1713.method_3056((class_2394)HAT_MAN, randomPos.field_1352, randomPos.field_1351 + 0.5, randomPos.field_1350, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void trySpawnBird(class_2680 state, class_1937 level, class_2338 blockPos) {
        if (ConfigManager.config.spawnBird && Util.isDay(level) && Util.hasSpace(ConfigManager.birdGroup) && level.method_8320(blockPos.method_10084()).method_26215() && !class_310.method_1551().field_1724.method_19538().method_24802((class_2374)blockPos.method_46558(), (double)ConfigManager.config.birdReactionDistance)) {
            class_243 pos = blockPos.method_46558();
            class_3965 hitResult = state.method_26220((class_1922)level, blockPos).method_1092(pos.method_1031(0.0, 2.0, 0.0), pos.method_1031(0.0, -0.6, 0.0), blockPos);
            if (hitResult == null) {
                return;
            }
            pos = hitResult.method_17784();
            class_243 spawnFrom = pos.method_1031((double)(level.field_9229.method_43048(10) - 5), (double)level.field_9229.method_43048(5), (double)(level.field_9229.method_43048(10) - 5));
            if (Util.isExposed(level, (int)spawnFrom.field_1352, (int)spawnFrom.field_1351, (int)spawnFrom.field_1350) && level.method_17742(Util.getClipContext(spawnFrom, pos)).method_17783().equals((Object)class_239.class_240.field_1333)) {
                level.method_8406((class_2394)BIRD, spawnFrom.field_1352, spawnFrom.field_1351, spawnFrom.field_1350, pos.field_1352, pos.field_1351, pos.field_1350);
            }
        }
    }

    public static void trySpawnMoth(class_1937 level, class_2338 blockPos) {
        if (ConfigManager.config.spawnMoth && Util.hasSpace(ConfigManager.mothGroup) && !Util.isDay(level) && level.method_8314(class_1944.field_9282, blockPos) > 13 && Util.isExposed(level, blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260())) {
            level.method_8406((class_2394)MOTH, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 0.0, 0.0, 0.0);
        }
    }

    public static void trySpawnSpider(class_1937 level, class_2338 blockPos) {
        if (ConfigManager.config.spawnSpider && Util.hasSpace(ConfigManager.spiderGroup) && !class_310.method_1551().field_1724.method_19538().method_24802((class_2374)blockPos.method_46558(), 2.0)) {
            if (class_310.method_1551().field_1724.method_19538().method_24802((class_2374)blockPos.method_46558(), 2.0)) {
                return;
            }
            class_2350 direction = class_2350.method_10162((class_5819)level.field_9229);
            class_2680 state = level.method_8320(blockPos = blockPos.method_10093(direction));
            if (state.method_26206((class_1922)level, blockPos, direction.method_10153())) {
                class_243 spawnPos = blockPos.method_46558().method_1019(new class_243(direction.method_23955()).method_18805((double)-0.6f, (double)-0.6f, (double)-0.6f));
                level.method_8406((class_2394)SPIDER, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, (double)direction.method_10146(), 0.0, 0.0);
            }
        }
    }

    static {
        wasSleeping = false;
    }
}

