/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.config.ConfigScreens;
import pigcart.cosycritters.mixin.access.ParticleEngineAccessor;

public class CosyCritters {
    public static final String MOD_ID = "cosycritters";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cosycritters");
    public static SimpleParticleType BIRD;
    public static SimpleParticleType HAT_MAN;
    public static SimpleParticleType MOTH;
    public static SimpleParticleType SPIDER;
    private static boolean wasSleeping;

    private static List<String> getDebugStrings() {
        return List.of(String.format("Birds: %d/%d", Util.getCount(ConfigManager.birdGroup), Util.getLimit(ConfigManager.birdGroup)), String.format("Moths: %d/%d", Util.getCount(ConfigManager.mothGroup), Util.getLimit(ConfigManager.mothGroup)), String.format("Spiders: %d/%d", Util.getCount(ConfigManager.spiderGroup), Util.getLimit(ConfigManager.spiderGroup)), "Tracked: " + ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).getTrackedParticleCounts().toString());
    }

    public static void onInitializeClient() {
        ConfigManager.loadConfig();
    }

    public static <S> LiteralArgumentBuilder<S> getCommands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).executes(ctx -> {
            Util.schedule(() -> Minecraft.m_91087_().m_91152_(ConfigScreens.generateMainConfigScreen(null)));
            return 0;
        })).then(LiteralArgumentBuilder.literal((String)"debug").executes(ctx -> {
            CosyCritters.getDebugStrings().forEach(Util::addChatMsg);
            return 0;
        }));
    }

    public static void doAnimateTick(BlockPos blockPos, BlockState state) {
        CosyCritters.trySpawnMoth((Level)Minecraft.m_91087_().f_91073_, blockPos);
    }

    public static void onTick(Minecraft minecraft) {
        if (minecraft.f_91074_ != null) {
            CosyCritters.tickHatManSpawnConditions(minecraft);
        }
    }

    private static void tickHatManSpawnConditions(Minecraft minecraft) {
        if (minecraft.f_91073_.m_6042_().m_63936_(minecraft.f_91073_.m_8044_()) == 4) {
            if (minecraft.f_91074_.m_5803_()) {
                if (!wasSleeping) {
                    CosyCritters.trySpawnHatman(minecraft);
                    wasSleeping = true;
                }
            } else if (wasSleeping) {
                wasSleeping = false;
            }
        }
    }

    private static void trySpawnHatman(Minecraft minecraft) {
        DirectionProperty property;
        BlockState state;
        if (!ConfigManager.config.spawnHatman) {
            return;
        }
        Optional sleepingPos = minecraft.f_91074_.m_21257_();
        if (sleepingPos.isPresent() && (state = minecraft.f_91073_.m_8055_((BlockPos)sleepingPos.get())).m_61138_((Property)(property = BlockStateProperties.f_61374_))) {
            Direction direction = (Direction)state.m_61143_((Property)property);
            BlockPos blockPos = BlockPos.m_274446_((Position)minecraft.f_91074_.m_20182_()).m_5484_(direction.m_122424_(), 2);
            Vec3 pos = blockPos.m_252807_();
            RandomSource random = minecraft.f_91074_.m_217043_();
            Vec3 randomPos = new Vec3(pos.f_82479_ + (double)random.m_188503_(2) - 1.0, pos.f_82480_, pos.f_82481_ + (double)random.m_188503_(2) - 1.0);
            if (minecraft.f_91073_.m_8055_(BlockPos.m_274446_((Position)randomPos)).m_60795_()) {
                minecraft.f_91061_.m_107370_((ParticleOptions)HAT_MAN, randomPos.f_82479_, randomPos.f_82480_ + 0.5, randomPos.f_82481_, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void trySpawnBird(BlockState state, Level level, BlockPos blockPos) {
        if (ConfigManager.config.spawnBird && Util.isDay(level) && Util.hasSpace(ConfigManager.birdGroup) && level.m_8055_(blockPos.m_7494_()).m_60795_() && !Minecraft.m_91087_().f_91074_.m_20182_().m_82509_((Position)blockPos.m_252807_(), (double)ConfigManager.config.birdReactionDistance)) {
            Vec3 pos = blockPos.m_252807_();
            BlockHitResult hitResult = state.m_60812_((BlockGetter)level, blockPos).m_83220_(pos.m_82520_(0.0, 2.0, 0.0), pos.m_82520_(0.0, -0.6, 0.0), blockPos);
            if (hitResult == null) {
                return;
            }
            pos = hitResult.m_82450_();
            Vec3 spawnFrom = pos.m_82520_((double)(level.f_46441_.m_188503_(10) - 5), (double)level.f_46441_.m_188503_(5), (double)(level.f_46441_.m_188503_(10) - 5));
            if (Util.isExposed(level, (int)spawnFrom.f_82479_, (int)spawnFrom.f_82480_, (int)spawnFrom.f_82481_) && level.m_45547_(Util.getClipContext(spawnFrom, pos)).m_6662_().equals((Object)HitResult.Type.MISS)) {
                level.m_7106_((ParticleOptions)BIRD, spawnFrom.f_82479_, spawnFrom.f_82480_, spawnFrom.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
            }
        }
    }

    public static void trySpawnMoth(Level level, BlockPos blockPos) {
        if (ConfigManager.config.spawnMoth && Util.hasSpace(ConfigManager.mothGroup) && !Util.isDay(level) && level.m_45517_(LightLayer.BLOCK, blockPos) > 13 && Util.isExposed(level, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())) {
            level.m_7106_((ParticleOptions)MOTH, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 0.0, 0.0, 0.0);
        }
    }

    public static void trySpawnSpider(Level level, BlockPos blockPos) {
        if (ConfigManager.config.spawnSpider && Util.hasSpace(ConfigManager.spiderGroup) && !Minecraft.m_91087_().f_91074_.m_20182_().m_82509_((Position)blockPos.m_252807_(), 2.0)) {
            if (Minecraft.m_91087_().f_91074_.m_20182_().m_82509_((Position)blockPos.m_252807_(), 2.0)) {
                return;
            }
            Direction direction = Direction.m_235672_((RandomSource)level.f_46441_);
            BlockState state = level.m_8055_(blockPos = blockPos.m_121945_(direction));
            if (state.m_60783_((BlockGetter)level, blockPos, direction.m_122424_())) {
                Vec3 spawnPos = blockPos.m_252807_().m_82549_(new Vec3(direction.m_253071_()).m_82542_((double)-0.6f, (double)-0.6f, (double)-0.6f));
                level.m_7106_((ParticleOptions)SPIDER, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, (double)direction.m_122411_(), 0.0, 0.0);
            }
        }
    }

    static {
        wasSleeping = false;
    }
}

