/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.config;

import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.ButtonOption;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.ListOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.DropdownStringControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.StringControllerBuilder;
import dev.isxander.yacl3.gui.YACLScreen;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import pigcart.cosycritters.CosyCritters;
import pigcart.cosycritters.config.ConfigManager;

public class ConfigScreens {
    private static Screen screenToOpen;
    private static String lastScreenInitialized;

    public static void regenerateScreen(YACLScreen thisScreen, Supplier<Screen> generator) {
        String key = ((TranslatableContents)thisScreen.m_96636_().m_214077_()).m_237508_();
        if (!lastScreenInitialized.equals(key)) {
            lastScreenInitialized = key;
            if (generator != null) {
                Minecraft.m_91087_().m_91152_(generator.get());
            }
        }
    }

    public static Screen generateScreen(String titleKey, Collection<OptionGroup> groups, Collection<Option<?>> options, Supplier<Screen> generator, Screen parent) {
        ConfigCategory.Builder categoryBuilder = ConfigCategory.createBuilder();
        if (groups != null && !groups.isEmpty()) {
            categoryBuilder.groups(groups);
        }
        if (options != null && !options.isEmpty()) {
            categoryBuilder.options(options);
        }
        return YetAnotherConfigLib.createBuilder().title(ConfigScreens.getComponent(titleKey)).category(categoryBuilder.name(ConfigScreens.getComponent(titleKey)).build()).save(ConfigManager::saveConfig).screenInit(thisScreen -> ConfigScreens.regenerateScreen(thisScreen, generator)).build().generateScreen(parent);
    }

    public static Screen generateMainConfigScreen(Screen prevScreen) {
        return ConfigScreens.generateScreen("title", ConfigScreens.collectGroups(ConfigManager.defaultConfig, ConfigManager.config), ConfigScreens.collectOptions(ConfigManager.defaultConfig, ConfigManager.config), () -> ConfigScreens.generateMainConfigScreen(prevScreen), prevScreen);
    }

    private static ButtonOption getScreenButtonOption(Component name, String text, Supplier<Screen> screenSupplier) {
        return ButtonOption.createBuilder().name(name).text((Component)Component.m_237113_((String)text)).action((yaclScreen, buttonOption) -> Minecraft.m_91087_().m_91152_((Screen)screenSupplier.get())).build();
    }

    private static ButtonOption getScreenButtonOption(Component name, String text, Runnable runnable) {
        return ButtonOption.createBuilder().name(name).text((Component)Component.m_237113_((String)text)).action((yaclScreen, buttonOption) -> {
            runnable.run();
            Minecraft.m_91087_().m_91152_(screenToOpen);
        }).build();
    }

    static <T> ButtonOption getListButtonOption(Object instance, Field field, ListOption<T> listOption) {
        String listText = "";
        try {
            listText = ConfigScreens.cropText(field.get(instance).toString());
        }
        catch (IllegalAccessException e) {
            CosyCritters.LOGGER.error(e.getMessage());
        }
        return ConfigScreens.getScreenButtonOption(ConfigScreens.getComponent(instance.getClass().getSimpleName() + "." + field.getName()), listText, () -> {
            screenToOpen = ConfigScreens.generateScreen("editList", List.of(listOption), null, null, Minecraft.m_91087_().f_91080_);
            return screenToOpen;
        });
    }

    static List<OptionGroup> collectGroups(Object defaultInstance, Object instance) {
        Field[] fields;
        ArrayList<OptionGroup> groups = new ArrayList<OptionGroup>();
        for (Field field : fields = instance.getClass().getFields()) {
            if (!field.isAnnotationPresent(ConfigManager.Group.class)) continue;
            if (field.isAnnotationPresent(ConfigManager.Dropdown.class)) {
                ConfigManager.Dropdown annotation = field.getAnnotation(ConfigManager.Dropdown.class);
                try {
                    List strings = (List)((Supplier)annotation.supplier().getConstructors()[0].newInstance(new Object[0])).get();
                    groups.add((OptionGroup)ConfigScreens.getStringDropdownListOption(defaultInstance, instance, field, strings));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (field.getType().equals(List.class)) {
                groups.add((OptionGroup)ConfigScreens.getListOption(defaultInstance, instance, field));
                continue;
            }
            field.setAccessible(true);
            try {
                groups.add(OptionGroup.createBuilder().name(ConfigScreens.getComponent(field.getType().getSimpleName())).description(OptionDescription.of((Component[])new Component[]{ConfigScreens.getComponentWithFallback(field.getName() + ".description")})).options(ConfigScreens.collectOptions(field.get(defaultInstance), field.get(instance))).build());
            }
            catch (IllegalAccessException e) {
                CosyCritters.LOGGER.error(e.toString());
            }
        }
        return groups;
    }

    static List<Option<?>> collectOptions(Object defaultInstance, Object instance) {
        Field[] fields;
        ArrayList options = new ArrayList();
        for (Field field : fields = instance.getClass().getFields()) {
            if (field.isAnnotationPresent(ConfigManager.NoGUI.class) || field.isAnnotationPresent(ConfigManager.Group.class)) continue;
            if (field.isAnnotationPresent(ConfigManager.Label.class)) {
                options.add((Option<?>)LabelOption.create((Component)ConfigScreens.getComponent(instance.getClass().getSimpleName() + "." + field.getDeclaredAnnotation(ConfigManager.Label.class).key())));
            }
            field.setAccessible(true);
            Class<?> type = field.getType();
            if (type.equals(Boolean.TYPE)) {
                options.add(ConfigScreens.getBoolOption(defaultInstance, instance, field).build());
                continue;
            }
            if (type.equals(Float.TYPE)) {
                if (field.isAnnotationPresent(ConfigManager.Percentage.class)) {
                    options.add(ConfigScreens.getPercentOption(defaultInstance, instance, field));
                    continue;
                }
                options.add(ConfigScreens.getFloatOption(defaultInstance, instance, field));
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                options.add(ConfigScreens.getIntOption(defaultInstance, instance, field));
                continue;
            }
            if (field.isAnnotationPresent(ConfigManager.Dropdown.class)) {
                ConfigManager.Dropdown annotation = field.getAnnotation(ConfigManager.Dropdown.class);
                try {
                    List strings = (List)((Supplier)annotation.supplier().getConstructors()[0].newInstance(new Object[0])).get();
                    if (type.equals(List.class)) {
                        options.add((Option<?>)ConfigScreens.getStringDropdownListOption(defaultInstance, instance, field, strings));
                        continue;
                    }
                    options.add(ConfigScreens.getStringDropdownOption(defaultInstance, instance, field, strings));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
            if (type.equals(String.class) || field.isAnnotationPresent(ConfigManager.EditAsString.class)) {
                options.add(ConfigScreens.getStringOption(defaultInstance, instance, field));
                continue;
            }
            if (type.isEnum()) {
                options.add(ConfigScreens.getEnumOption(defaultInstance, instance, field, type));
                continue;
            }
            if (type.equals(URI.class)) {
                options.add((Option<?>)ConfigScreens.getLinkButtonOption(instance, field));
                continue;
            }
            if (type.equals(Color.class)) {
                options.add(ConfigScreens.getColorOption(defaultInstance, instance, field));
                continue;
            }
            if (type.equals(List.class)) {
                ListOption<?> listOption = ConfigScreens.getListOption(defaultInstance, instance, field);
                if (listOption == null) continue;
                options.add((Option<?>)ConfigScreens.getListButtonOption(instance, field, listOption));
                continue;
            }
            if (type.getFields().length != 0) {
                options.add((Option<?>)ConfigScreens.getObjectOption(defaultInstance, instance, field));
                continue;
            }
            CosyCritters.LOGGER.error("Unable to create option for field {}", (Object)field.getName());
        }
        options.add((Option<?>)LabelOption.create((Component)CommonComponents.f_237098_));
        return options;
    }

    private static ListOption<?> getListOption(Object defaultInstance, Object instance, Field field) {
        Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        if (listType.equals(String.class)) {
            return ConfigScreens.getStringListOption(defaultInstance, instance, field);
        }
        if (listType.isEnum()) {
            return ConfigScreens.getEnumListOption(defaultInstance, instance, field, listType);
        }
        CosyCritters.LOGGER.error("Unable to create list for field {}", (Object)field.getName());
        return null;
    }

    private static ButtonOption getObjectOption(Object defaultInstance, Object instance, Field field) {
        try {
            Object newDefaultInstance = field.get(defaultInstance);
            Object newInstance = field.get(instance);
            Component name = ConfigScreens.getComponent(field.getName());
            String text = "";
            if (!newInstance.toString().startsWith(newInstance.getClass().getName())) {
                text = ConfigScreens.cropText(newInstance.toString());
            }
            return ConfigScreens.getScreenButtonOption(name, text, () -> ConfigScreens.generateScreen("cosycritters." + field.getName(), ConfigScreens.collectGroups(newDefaultInstance, newInstance), ConfigScreens.collectOptions(newDefaultInstance, newInstance), null, Minecraft.m_91087_().f_91080_));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static ButtonOption getLinkButtonOption(Object instance, Field field) {
        String groupName = instance.getClass().getSimpleName();
        if (instance.getClass().isAnnotationPresent(ConfigManager.OverrideName.class)) {
            groupName = instance.getClass().getAnnotation(ConfigManager.OverrideName.class).newName();
        }
        String fieldName = field.getName();
        try {
            return ButtonOption.createBuilder().name(ConfigScreens.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((Component[])new Component[]{Component.m_237113_((String)field.get(instance).toString())})).text((Component)Component.m_237113_((String)"")).action((yaclScreen, buttonOption) -> {
                Minecraft minecraft = Minecraft.m_91087_();
                try {
                    minecraft.m_91152_((Screen)new ConfirmLinkScreen(result -> {
                        try {
                            if (result) {
                                Util.m_137581_().m_137648_((URI)field.get(instance));
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                        minecraft.m_91152_((Screen)yaclScreen);
                    }, field.get(instance).toString(), true));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }).build();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Option<Color> getColorOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(ColorControllerBuilder::create).build();
    }

    private static <T extends Enum<T>> Option<T> getEnumOption(Object defaultInstance, Object instance, Field field, Class<?> eClass) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(eClass)).build();
    }

    private static <T extends Enum<T>> ListOption<T> getEnumListOption(Object defaultInstance, Object instance, Field field, Class<?> eClass) {
        return ConfigScreens.getListOptionBuilder(defaultInstance, instance, field).controller(opt -> EnumControllerBuilder.create((Option)opt).enumClass(eClass)).build();
    }

    private static ListOption<String> getStringListOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getListOptionBuilder(defaultInstance, instance, field).controller(StringControllerBuilder::create).initial((Object)"").build();
    }

    private static Option.Builder<Boolean> getBoolOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> {
            if (field.isAnnotationPresent(ConfigManager.BooleanFormat.class)) {
                return BooleanControllerBuilder.create((Option)opt).formatValue(val -> ConfigScreens.getComponent(val != false ? field.getAnnotation(ConfigManager.BooleanFormat.class).t() : field.getAnnotation(ConfigManager.BooleanFormat.class).f()));
            }
            return BooleanControllerBuilder.create((Option)opt).coloured(true);
        });
    }

    private static Option<Float> getFloatOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> FloatFieldControllerBuilder.create((Option)opt).formatValue(val -> Component.m_237113_((String)val.toString()))).build();
    }

    private static Option<Float> getPercentOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)opt).range((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f))).step((Number)Float.valueOf(0.01f))).formatValue(val -> Component.m_237113_((String)NumberFormat.getPercentInstance().format(val)))).build();
    }

    private static Option<Integer> getIntOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(IntegerFieldControllerBuilder::create).build();
    }

    private static Option<String> getStringOption(Object defaultInstance, Object instance, Field field) {
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(StringControllerBuilder::create).build();
    }

    private static Option<String> getStringDropdownOption(Object defaultInstance, Object instance, Field field, List<String> strings) {
        BuiltInRegistries.f_257034_.m_6566_();
        return ConfigScreens.getOptionBuilder(defaultInstance, instance, field).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(false).allowEmptyValue(false).values(strings)).build();
    }

    private static ListOption<String> getStringDropdownListOption(Object defaultInstance, Object instance, Field field, List<String> strings) {
        BuiltInRegistries.f_257034_.m_6566_();
        return ConfigScreens.getListOptionBuilder(defaultInstance, instance, field).controller(opt -> DropdownStringControllerBuilder.create((Option)opt).allowAnyValue(false).allowEmptyValue(true).values(strings)).initial((Object)"").build();
    }

    private static <T> Option.Builder<T> getOptionBuilder(Object defaultInstance, Object instance, Field field) {
        String groupName = instance.getClass().getSimpleName();
        if (instance.getClass().isAnnotationPresent(ConfigManager.OverrideName.class)) {
            groupName = instance.getClass().getAnnotation(ConfigManager.OverrideName.class).newName();
        }
        String fieldName = field.getName();
        Binding<T> binding = ConfigScreens.getBinding(defaultInstance, instance, field);
        Option.Builder optionBuilder = Option.createBuilder().name(ConfigScreens.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((Component[])new Component[]{ConfigScreens.getComponentWithFallback(groupName + "." + fieldName + ".description")}));
        optionBuilder.stateManager(StateManager.createInstant(binding));
        return optionBuilder;
    }

    private static <T> ListOption.Builder<T> getListOptionBuilder(Object defaultGroup, Object group, Field field) {
        String groupName = group.getClass().getSimpleName();
        String fieldName = field.getName();
        return ListOption.createBuilder().name(ConfigScreens.getComponent(groupName + "." + fieldName)).description(OptionDescription.of((Component[])new Component[]{ConfigScreens.getComponentWithFallback(groupName + "." + fieldName + ".description")})).binding(ConfigScreens.getBinding(defaultGroup, group, field)).initial(() -> {
            try {
                Field defaultField = defaultGroup.getClass().getField(field.getName());
                defaultField.setAccessible(true);
                return ((List)defaultField.get(defaultGroup)).get(0);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static <T> Binding<T> getBinding(Object defaultGroup, Object group, Field field) {
        Object defaultValue;
        try {
            Field defaultField = defaultGroup.getClass().getField(field.getName());
            defaultField.setAccessible(true);
            defaultValue = defaultField.get(defaultGroup);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        return Binding.generic((Object)defaultValue, () -> {
            try {
                Object value = field.get(group);
                if (field.isAnnotationPresent(ConfigManager.EditAsString.class)) {
                    if (field.getType().equals(List.class)) {
                        ArrayList<String> list = new ArrayList<String>();
                        for (Object object : (List)value) {
                            list.add(ConfigManager.GSON.getAdapter(object.getClass()).toJson(object).replace("\"", ""));
                        }
                        return list;
                    }
                    return ConfigManager.GSON.getAdapter(field.getType()).toJson(value).replace("\"", "");
                }
                return value;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, newVal -> {
            try {
                String oleVal;
                Object oldVal = field.get(group);
                String string = oleVal = oldVal == null ? "" : oldVal.toString();
                if (!newVal.toString().equals(oleVal)) {
                    if (field.isAnnotationPresent(ConfigManager.EditAsString.class)) {
                        if (field.getType().equals(List.class)) {
                            Class listType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                            ArrayList<Object> list = new ArrayList<Object>();
                            for (String string2 : (List)newVal) {
                                list.add(ConfigManager.GSON.getAdapter(listType).fromJson("\"" + string2 + "\""));
                            }
                            field.set(group, list);
                        } else {
                            field.set(group, ConfigManager.GSON.getAdapter(field.getType()).fromJson("\"" + String.valueOf(newVal) + "\""));
                        }
                    } else {
                        field.set(group, newVal);
                    }
                    ConfigManager.OnChange annotation = field.getDeclaredAnnotation(ConfigManager.OnChange.class);
                    if (annotation != null) {
                        ((Runnable)annotation.runnable().getConstructors()[0].newInstance(new Object[0])).run();
                    }
                }
            }
            catch (IOException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                CosyCritters.LOGGER.error(e.getMessage());
            }
        });
    }

    protected static Component getComponent(String translationKey) {
        return Component.m_237115_((String)("cosycritters." + translationKey));
    }

    private static Component getComponentWithFallback(String translationKey) {
        return Component.m_264568_((String)("cosycritters." + translationKey), (String)"");
    }

    private static String cropText(String text) {
        if (((String)text).length() > 42) {
            text = ((String)text).substring(0, 42) + "...";
        }
        return text;
    }

    static {
        lastScreenInitialized = "";
    }
}

