/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.loaders.forge;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import pigcart.cosycritters.CosyCritters;
import pigcart.cosycritters.config.ConfigScreens;
import pigcart.cosycritters.particle.BirdParticle;
import pigcart.cosycritters.particle.HatManParticle;
import pigcart.cosycritters.particle.MothParticle;
import pigcart.cosycritters.particle.SpiderParticle;

@Mod(value="cosycritters")
public class ForgeEntrypoint {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256890_, (String)"cosycritters");
    public static final RegistryObject<SimpleParticleType> BIRD = ForgeEntrypoint.registerParticle("bird");
    public static final RegistryObject<SimpleParticleType> HAT_MAN = ForgeEntrypoint.registerParticle("hat_man");
    public static final RegistryObject<SimpleParticleType> MOTH = ForgeEntrypoint.registerParticle("moth");
    public static final RegistryObject<SimpleParticleType> SPIDER = ForgeEntrypoint.registerParticle("spider");

    private static RegistryObject<SimpleParticleType> registerParticle(String name) {
        return PARTICLE_TYPES.register(name, () -> new SimpleParticleType(true));
    }

    public static void onTick(TickEvent.ClientTickEvent event) {
        CosyCritters.onTick(Minecraft.m_91087_());
    }

    public static void onRegisterCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register(CosyCritters.getCommands());
    }

    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)BIRD.get(), BirdParticle.Provider::new);
        event.registerSpriteSet((ParticleType)HAT_MAN.get(), HatManParticle.Provider::new);
        event.registerSpriteSet((ParticleType)MOTH.get(), MothParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SPIDER.get(), SpiderParticle.Provider::new);
        CosyCritters.BIRD = (SimpleParticleType)BIRD.get();
        CosyCritters.HAT_MAN = (SimpleParticleType)HAT_MAN.get();
        CosyCritters.MOTH = (SimpleParticleType)MOTH.get();
        CosyCritters.SPIDER = (SimpleParticleType)SPIDER.get();
    }

    public ForgeEntrypoint() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.addListener(ForgeEntrypoint::onTick);
        MinecraftForge.EVENT_BUS.addListener(ForgeEntrypoint::onRegisterCommands);
        PARTICLE_TYPES.register(eventBus);
        eventBus.addListener(ForgeEntrypoint::onRegisterParticleProviders);
        CosyCritters.onInitializeClient();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((client, parent) -> ConfigScreens.generateMainConfigScreen(parent)));
    }
}

