/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector2f;
import org.joml.Vector3f;
import pigcart.cosycritters.Util;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.particle.CritterParticle;

public class BirdParticle
extends CritterParticle {
    int spawnAnimationLength;
    int spawnAnimationTime;
    Vec3 spawnAnimationStart;
    Vec3 spawnAnimationEnd;
    Vector3f facing;
    Behaviour behaviour;
    BlockState perch;

    private BirdParticle(ClientLevel level, double x, double y, double z, double landAtX, double landAtY, double landAtZ) {
        super(level, x, y, z, Util.getSprite("crow_left"));
        this.spawnAnimationTime = this.spawnAnimationLength = 40;
        if (this.entitiesNearby(new Vec3(landAtX, landAtY, landAtZ))) {
            this.m_107274_();
        }
        this.f_107219_ = false;
        this.f_107663_ = 0.0f;
        this.f_107225_ = 6000;
        this.facing = new Vector3f(this.f_107223_.m_188501_() - 0.5f, this.f_107223_.m_188501_(), this.f_107223_.m_188501_() - 0.5f).normalize().mul(0.5f);
        this.spawnAnimationStart = new Vec3(x, y, z);
        this.spawnAnimationEnd = new Vec3(landAtX, landAtY, landAtZ);
        this.setBehaviour(Behaviour.SPAWNING);
    }

    public Optional<ParticleGroup> m_142654_() {
        return Optional.of(ConfigManager.birdGroup);
    }

    private void setBehaviour(Behaviour behaviour) {
        this.behaviour = behaviour;
        switch (behaviour) {
            case PERCHED: {
                this.perch = this.f_107208_.m_8055_(BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ - 0.5), (double)this.f_107214_));
                break;
            }
            case FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE: {
                this.f_107225_ = 100;
                this.f_107224_ = 0;
                this.m_107264_(this.spawnAnimationEnd.f_82479_, this.spawnAnimationEnd.f_82480_, this.spawnAnimationEnd.f_82481_);
            }
        }
    }

    private String getRelativeDirection() {
        float b;
        Vector2f birdFacing = new Vector2f(this.facing.x, this.facing.z).normalize();
        Vec3 camPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vector2f relativeDirection = new Vector2f((float)(this.f_107212_ - camPos.m_7096_()), (float)(this.f_107214_ - camPos.m_7094_())).normalize();
        float a = Math.atan2((float)relativeDirection.y, (float)relativeDirection.x);
        float c = a - (b = Math.atan2((float)birdFacing.y, (float)birdFacing.x));
        if (c > (float)java.lang.Math.PI) {
            c -= (float)java.lang.Math.PI * 2;
        } else if (c < (float)(-java.lang.Math.PI)) {
            c += (float)java.lang.Math.PI * 2;
        }
        if (c < 0.0f) {
            return "right";
        }
        return "left";
    }

    private void reactToDisturbances() {
        if (!this.perch.equals(this.f_107208_.m_8055_(BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ - 0.5), (double)this.f_107214_)))) {
            this.setBehaviour(Behaviour.FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE);
        } else if (this.f_107224_ % ConfigManager.config.birdReactionSpeed == 0) {
            Vec3 birdPos = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
            if (this.entitiesNearby(birdPos)) {
                this.setBehaviour(Behaviour.FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE);
            } else if (!Util.getCameraPos().m_82509_((Position)birdPos, (double)ConfigManager.config.birdDespawnDistance)) {
                this.m_107274_();
            }
        }
    }

    private boolean entitiesNearby(Vec3 pos) {
        List nearbyEntities = this.f_107208_.m_45976_(Entity.class, AABB.m_165882_((Vec3)pos, (double)ConfigManager.config.birdReactionDistance, (double)ConfigManager.config.birdReactionDistance, (double)ConfigManager.config.birdReactionDistance));
        return !nearbyEntities.isEmpty();
    }

    public void m_5989_() {
        super.m_5989_();
        switch (this.behaviour) {
            case SPAWNING: {
                this.m_108337_(Util.getSprite("crow_flying_%s_%d".formatted(this.getRelativeDirection(), this.f_107224_ / 2 % 2)));
                if (this.spawnAnimationTime != 0) {
                    --this.spawnAnimationTime;
                    this.f_107212_ = Mth.m_14139_((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.f_82479_, (double)this.spawnAnimationStart.f_82479_);
                    this.f_107213_ = Mth.m_14139_((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.f_82480_, (double)this.spawnAnimationStart.f_82480_);
                    this.f_107214_ = Mth.m_14139_((double)((double)this.spawnAnimationTime / (double)this.spawnAnimationLength), (double)this.spawnAnimationEnd.f_82481_, (double)this.spawnAnimationStart.f_82481_);
                    this.f_107663_ = Mth.m_14179_((float)((float)this.spawnAnimationTime / (float)this.spawnAnimationLength), (float)0.5f, (float)0.0f);
                    break;
                }
                this.setBehaviour(Behaviour.PERCHED);
                break;
            }
            case PERCHED: {
                if ((double)this.f_107223_.m_188501_() < 0.01) {
                    this.setBehaviour(Behaviour.CHECKING);
                }
                this.m_108337_(Util.getSprite("crow_" + this.getRelativeDirection()));
                this.reactToDisturbances();
                break;
            }
            case CHECKING: {
                if ((double)this.f_107223_.m_188501_() < 0.02) {
                    this.setBehaviour(Behaviour.PERCHED);
                }
                this.m_108337_(Util.getSprite("crow_checking_" + this.getRelativeDirection()));
                this.reactToDisturbances();
                break;
            }
            case FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE: {
                this.m_108337_(Util.getSprite("crow_flying_%s_%d".formatted(this.getRelativeDirection(), this.f_107224_ / 2 % 2)));
                this.f_107663_ = Mth.m_14179_((float)((float)this.f_107224_ / (float)this.f_107225_), (float)0.5f, (float)0.0f);
                this.f_107215_ = this.facing.x;
                this.f_107216_ = this.facing.y;
                this.f_107217_ = this.facing.z;
            }
        }
    }

    private static enum Behaviour {
        SPAWNING,
        PERCHED,
        CHECKING,
        FLY_UP_AWAY_TO_THE_SUN_LIKE_A_FEATHERY_PIECE_OF_GARGBAGE;

    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new BirdParticle(level, x, y, z, velocityX, velocityY, velocityZ);
        }
    }
}

