/*
 * Decompiled with CFR 0.152.
 */
package pigcart.cosycritters.particle;

import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleGroup;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.cosycritters.config.ConfigManager;
import pigcart.cosycritters.particle.ComplexCritterParticle;
import pigcart.cosycritters.particle.CritterParticle;

public class MothParticle
extends ComplexCritterParticle {
    private final Vec3 targetLamp;

    private MothParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet) {
        super(level, x, y, z, spriteSet.m_213979_(level.f_46441_));
        this.f_107663_ = 0.1f;
        this.f_107225_ = 500;
        this.targetLamp = BlockPos.m_274561_((double)x, (double)y, (double)z).m_252807_();
        this.f_107215_ = 0.5;
    }

    public Optional<ParticleGroup> m_142654_() {
        return Optional.of(ConfigManager.mothGroup);
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107212_ == this.f_107209_ && this.f_107213_ == this.f_107210_ && this.f_107214_ == this.f_107211_) {
            this.m_107274_();
        }
        float centeringFactor = 5.0E-5f;
        Vec3 vec3 = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
        if (this.targetLamp.m_82554_(vec3) > 1.0) {
            this.f_107215_ = (this.targetLamp.f_82479_ - this.f_107212_) * (double)centeringFactor;
            this.f_107216_ = (this.targetLamp.f_82480_ - this.f_107213_) * (double)centeringFactor;
            this.f_107217_ = (this.targetLamp.f_82481_ - this.f_107214_) * (double)centeringFactor;
        } else {
            Vec3 vec32 = new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
            if (this.targetLamp.m_82554_(vec32) < 0.5) {
                this.f_107215_ = -(this.targetLamp.f_82479_ - this.f_107212_) * (double)centeringFactor;
                this.f_107216_ = -(this.targetLamp.f_82480_ - this.f_107213_) * (double)centeringFactor;
                this.f_107217_ = -(this.targetLamp.f_82481_ - this.f_107214_) * (double)centeringFactor;
            }
        }
        float speed = Mth.m_14116_((float)((float)(this.f_107215_ * this.f_107215_ + this.f_107216_ * this.f_107216_ + this.f_107217_ * this.f_107217_)));
        float maxSpeed = 0.1f;
        float minSpeed = 0.05f;
        if (speed > maxSpeed) {
            this.f_107215_ = this.f_107215_ / (double)speed * (double)maxSpeed;
            this.f_107216_ = this.f_107216_ / (double)speed * (double)maxSpeed;
            this.f_107217_ = this.f_107217_ / (double)speed * (double)maxSpeed;
        } else if (speed < minSpeed) {
            this.f_107215_ = this.f_107215_ / (double)speed * (double)minSpeed;
            this.f_107216_ = this.f_107216_ / (double)speed * (double)minSpeed;
            this.f_107217_ = this.f_107217_ / (double)speed * (double)minSpeed;
        }
        this.f_107215_ *= (double)this.f_107223_.m_188501_() + 0.5;
        this.f_107216_ *= (double)this.f_107223_.m_188501_() + 0.5;
        this.f_107217_ *= (double)this.f_107223_.m_188501_() + 0.5;
    }

    @Override
    public <T> void renderCustom(T renderInfo, Camera camera, float partialTick) {
        Vec3 vec3 = camera.m_90583_();
        float x = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float y = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float z = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Vector3f cameraOffset = new Vector3f(x, y, z);
        float lerpedAge = Mth.m_14179_((float)partialTick, (float)(this.f_107224_ - 1), (float)this.f_107224_);
        float wingsPos = Mth.m_14031_((float)(lerpedAge * 1.5f)) * 0.7f;
        Quaternionf leftWing = new Quaternionf(new AxisAngle4d((double)(wingsPos * 1.5707964f - 1.5707964f), 1.0, 0.0, 0.0));
        Quaternionf rightWing = new Quaternionf(new AxisAngle4d((double)(wingsPos * 1.5707964f - 1.5707964f), -1.0, 0.0, 0.0));
        Vector3f leftWingOffset = new Vector3f(0.0f, -this.f_107663_ * wingsPos, this.f_107663_ - this.f_107663_ * Mth.m_14154_((float)wingsPos));
        Vector3f rightWingOffset = new Vector3f(0.0f, -this.f_107663_ * wingsPos, this.f_107663_ * Mth.m_14154_((float)wingsPos) - this.f_107663_);
        Vector3f delta = new Vector3f((float)this.f_107215_, (float)this.f_107216_, (float)this.f_107217_);
        float angle = (float)Math.acos(new Vector3f((Vector3fc)delta).normalize().y);
        Vector3f axis = new Vector3f(-delta.z(), 0.0f, delta.x()).normalize();
        Quaternionf quaternion = new Quaternionf(new AxisAngle4f(-angle, (Vector3fc)axis));
        leftWing.mul((Quaternionfc)quaternion);
        rightWing.mul((Quaternionfc)quaternion);
        leftWingOffset.rotate((Quaternionfc)quaternion);
        rightWingOffset.rotate((Quaternionfc)quaternion);
        leftWingOffset.add((Vector3fc)cameraOffset);
        rightWingOffset.add((Vector3fc)cameraOffset);
        this.flipItTurnwaysIfBackfaced(leftWing, leftWingOffset);
        this.flipItTurnwaysIfBackfaced(rightWing, rightWingOffset);
        this.renderCustomQuad(renderInfo, leftWing, leftWingOffset.x, leftWingOffset.y, leftWingOffset.z, partialTick);
        this.renderCustomQuad(renderInfo, rightWing, rightWingOffset.x, rightWingOffset.y, rightWingOffset.z, partialTick);
    }

    protected void flipItTurnwaysIfBackfaced(Quaternionf quaternion, Vector3f toCamera) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)toCamera);
        if (dot > 0.0f) {
            quaternion.rotateY((float)Math.PI);
        }
    }

    public static class Provider
    extends CritterParticle.CritterProvider {
        public Provider(SpriteSet spriteSet) {
            super(spriteSet);
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new MothParticle(level, x, y, z, this.spriteSet);
        }
    }
}

