/*
 * Decompiled with CFR 0.152.
 */
package net.ayoubmrz.battletotemmod.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.ayoubmrz.battletotemmod.block.custom.BattleTotemBlock;
import net.ayoubmrz.battletotemmod.block.entity.ModBlockEntities;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BattleTotemBlockEntity
extends class_2586 {
    private Set<UUID> spawnedMobs = new HashSet<UUID>();
    private boolean isActive = false;
    private int tickCounter = 0;
    private int initialMobCount = 0;
    private int lastMobCount = -1;
    private boolean destroy = false;
    private int destroyDelay = 0;

    public BattleTotemBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BATTLE_TOTEM, pos, state);
    }

    public void addSpawnedMobs(List<UUID> mobs) {
        this.spawnedMobs.addAll(mobs);
        this.isActive = true;
        this.method_5431();
    }

    public void setInitialMobCount(int count) {
        this.initialMobCount = count;
        this.lastMobCount = count;
        this.method_5431();
    }

    public List<UUID> getSpawnedMobs() {
        return new ArrayList<UUID>(this.spawnedMobs);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BattleTotemBlockEntity blockEntity) {
        if (blockEntity.destroy) {
            ++blockEntity.destroyDelay;
        }
        if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10382)) {
            world.method_8501(pos.method_10074(), class_2246.field_10340.method_9564());
        }
        if (blockEntity.destroyDelay == 30) {
            blockEntity.destroyTotem(world);
            world.method_60511(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_6880)class_3417.field_23117, class_3419.field_15245, 2.0f, 0.6f);
        }
        if (world.field_9236 || !blockEntity.isActive) {
            return;
        }
        ++blockEntity.tickCounter;
        if (blockEntity.tickCounter % 5 == 0) {
            blockEntity.checkSpawnedMobs(world, pos, state);
        }
    }

    private void checkSpawnedMobs(class_1937 world, class_2338 pos, class_2680 state) {
        BattleTotemBlock totemBlock;
        class_2248 class_22482;
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        Iterator<UUID> iterator = this.spawnedMobs.iterator();
        while (iterator.hasNext()) {
            UUID mobId = iterator.next();
            class_1297 entity = serverWorld.method_14190(mobId);
            if (entity != null && entity.method_5805()) continue;
            iterator.remove();
        }
        int currentMobCount = this.spawnedMobs.size();
        if (currentMobCount != this.lastMobCount && (class_22482 = state.method_26204()) instanceof BattleTotemBlock) {
            totemBlock = (BattleTotemBlock)class_22482;
            totemBlock.updateStage(world, pos, currentMobCount, this.initialMobCount);
            this.lastMobCount = currentMobCount;
        }
        if (this.spawnedMobs.isEmpty() && this.isActive) {
            class_22482 = state.method_26204();
            if (class_22482 instanceof BattleTotemBlock) {
                totemBlock = (BattleTotemBlock)class_22482;
                totemBlock.updateStage(world, pos, 0, this.initialMobCount);
            }
            this.destroy = true;
        }
    }

    private void destroyTotem(class_1937 world) {
        class_2338 bottomPos = this.field_11867;
        class_2338 topPos = this.field_11867.method_10084();
        class_2680 currentState = world.method_8320(this.field_11867);
        if (currentState.method_26204().method_63499().contains("top")) {
            bottomPos = this.field_11867.method_10074();
            topPos = this.field_11867;
        }
        world.method_8501(topPos, class_2246.field_10124.method_9564());
        world.method_8501(bottomPos, class_2246.field_10124.method_9564());
        this.spawnFireworks(world, bottomPos);
        this.giveLoot(world, bottomPos);
        world.method_20290(2001, topPos, class_2248.method_9507((class_2680)currentState));
        world.method_20290(2001, bottomPos, class_2248.method_9507((class_2680)currentState));
        this.isActive = false;
    }

    private void giveLoot(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            return;
        }
        class_2338 chestPos = pos;
        world.method_8501(chestPos, class_2246.field_10034.method_9564());
        class_2586 blockEntity = world.method_8321(chestPos);
        if (blockEntity instanceof class_2595) {
            class_2595 chestEntity = (class_2595)blockEntity;
            List<class_1792> possibleItems = Arrays.asList(class_1802.field_8477, class_1802.field_8695, class_1802.field_8620, class_1802.field_8687, class_1802.field_8463, class_1802.field_8367, class_1802.field_8634, class_1802.field_8894, class_1802.field_8287, class_1802.field_8175, class_1802.field_8448, class_1802.field_8229, class_1802.field_8107);
            int numItems = world.field_9229.method_43048(16) + 8;
            HashSet<Integer> usedSlots = new HashSet<Integer>();
            for (int i = 0; i < numItems; ++i) {
                int slot;
                while (usedSlots.contains(slot = world.field_9229.method_43048(27))) {
                }
                usedSlots.add(slot);
                class_1792 selectedItem = possibleItems.get(world.field_9229.method_43048(possibleItems.size()));
                class_1799 lootItem = this.createRandomItemStack(world, selectedItem);
                chestEntity.method_5447(slot, lootItem);
            }
            chestEntity.method_5431();
        }
    }

    private class_1799 createRandomItemStack(class_1937 world, class_1792 item) {
        int amount = item == class_1802.field_8477 ? world.field_9229.method_43048(8) + 1 : (item == class_1802.field_8695 ? world.field_9229.method_43048(12) + 1 : (item == class_1802.field_8620 ? world.field_9229.method_43048(14) + 1 : (item == class_1802.field_8687 ? world.field_9229.method_43048(9) + 1 : (item == class_1802.field_8463 ? world.field_9229.method_43048(5) + 1 : (item == class_1802.field_8367 ? world.field_9229.method_43048(2) : (item == class_1802.field_8634 ? world.field_9229.method_43048(6) + 1 : (item == class_1802.field_8894 ? world.field_9229.method_43048(4) + 1 : (item == class_1802.field_8287 ? world.field_9229.method_43048(5) + 1 : (item == class_1802.field_8229 ? world.field_9229.method_43048(24) + 1 : (item == class_1802.field_8107 ? world.field_9229.method_43048(32) + 1 : 1))))))))));
        return new class_1799((class_1935)item, amount);
    }

    private void spawnFireworks(class_1937 world, class_2338 pos) {
        if (!world.field_9236) {
            double velocityZ;
            double velocityY;
            double velocityX;
            int i;
            class_3218 serverWorld = (class_3218)world;
            double x = (double)pos.method_10263() + 0.5;
            double y = pos.method_10264() + 5;
            double z = (double)pos.method_10260() + 0.5;
            for (i = 0; i < 50; ++i) {
                velocityX = (world.field_9229.method_43058() - 0.5) * 2.0;
                velocityY = (world.field_9229.method_43058() - 0.5) * 2.0;
                velocityZ = (world.field_9229.method_43058() - 0.5) * 2.0;
                serverWorld.method_14199((class_2394)class_2398.field_11248, x, y, z, 5, velocityX, velocityY, velocityZ, 0.1);
            }
            for (i = 0; i < 30; ++i) {
                velocityX = (world.field_9229.method_43058() - 0.5) * 1.5;
                velocityY = (world.field_9229.method_43058() - 0.5) * 1.5;
                velocityZ = (world.field_9229.method_43058() - 0.5) * 1.5;
                serverWorld.method_14199((class_2394)class_2398.field_11207, x, y, z, 5, velocityX, velocityY, velocityZ, 0.05);
            }
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2499 mobsList = new class_2499();
        for (UUID uuid : this.spawnedMobs) {
            mobsList.add((Object)class_2519.method_23256((String)uuid.toString()));
        }
        nbt.method_10566("SpawnedMobs", (class_2520)mobsList);
        nbt.method_10556("IsActive", this.isActive);
        nbt.method_10569("InitialMobCount", this.initialMobCount);
        nbt.method_10569("LastMobCount", this.lastMobCount);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.spawnedMobs.clear();
        class_2499 mobsList = nbt.method_10554("SpawnedMobs", 8);
        for (int i = 0; i < mobsList.size(); ++i) {
            this.spawnedMobs.add(UUID.fromString(mobsList.method_10608(i)));
        }
        this.isActive = nbt.method_10577("IsActive");
        this.initialMobCount = nbt.method_10550("InitialMobCount");
        this.lastMobCount = nbt.method_10550("LastMobCount");
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }
}

