/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration;

import com.shim.celestialexploration.config.CelestialClientConfig;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.entity.mob.Gust;
import com.shim.celestialexploration.entity.mob.piglins.VoidedPiglin;
import com.shim.celestialexploration.entity.mob.slimes.LunarSlime;
import com.shim.celestialexploration.entity.mob.slimes.MarsMallow;
import com.shim.celestialexploration.entity.mob.slimes.QuicksilverSlime;
import com.shim.celestialexploration.entity.mob.slimes.RustSlime;
import com.shim.celestialexploration.entity.mob.slimes.SulfurCube;
import com.shim.celestialexploration.entity.mob.slimes.ViscousSlime;
import com.shim.celestialexploration.packets.CelestialPacketHandler;
import com.shim.celestialexploration.registry.BiomeRegistry;
import com.shim.celestialexploration.registry.BlockEntityRegistry;
import com.shim.celestialexploration.registry.BlockRegistry;
import com.shim.celestialexploration.registry.CapabilityRegistry;
import com.shim.celestialexploration.registry.CelestialStructurePieceType;
import com.shim.celestialexploration.registry.DimensionRegistry;
import com.shim.celestialexploration.registry.EffectRegistry;
import com.shim.celestialexploration.registry.EntityRegistry;
import com.shim.celestialexploration.registry.FeatureRegistry;
import com.shim.celestialexploration.registry.FluidRegistry;
import com.shim.celestialexploration.registry.ItemRegistry;
import com.shim.celestialexploration.registry.MenuRegistry;
import com.shim.celestialexploration.registry.NoiseGenRegistry;
import com.shim.celestialexploration.registry.ParticleRegistry;
import com.shim.celestialexploration.registry.PoiRegistry;
import com.shim.celestialexploration.registry.RecipeRegistry;
import com.shim.celestialexploration.registry.StructureRegistry;
import com.shim.celestialexploration.registry.VillagerRegistry;
import com.shim.celestialexploration.util.Keybinds;
import com.shim.celestialexploration.world.structures.ResearchTunnelPieces;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mod.azure.azurelib.AzureLib;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="celestialexploration")
public class CelestialExploration {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "celestialexploration";
    public static final CreativeModeTab CELESTIAL_BLOCKS_TAB = new CreativeModeTab("celestial_blocks_tab"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)BlockRegistry.MOON_STONE.get());
        }
    };
    public static final CreativeModeTab CELESTIAL_MISC_TAB = new CreativeModeTab("celestial_misc_tab"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemRegistry.MOON_DUST.get());
        }
    };
    public static final CreativeModeTab SPACESHIP_TAB = new CreativeModeTab("spaceship_tab"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ItemRegistry.WHITE_SPACESHIP.get());
        }
    };

    public CelestialExploration() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus bus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ItemRegistry.register(modEventBus);
        BlockRegistry.register(modEventBus);
        BlockEntityRegistry.register(modEventBus);
        MenuRegistry.register(modEventBus);
        PoiRegistry.register(modEventBus);
        EffectRegistry.register(modEventBus);
        EntityRegistry.register(modEventBus);
        FeatureRegistry.register(modEventBus);
        FluidRegistry.register(modEventBus);
        StructureRegistry.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        ParticleRegistry.register(modEventBus);
        RecipeRegistry.register(modEventBus);
        VillagerRegistry.register(modEventBus);
        BiomeRegistry.BIOMES.register(modEventBus);
        DimensionRegistry.BIOME_SOURCE.register(modEventBus);
        NoiseGenRegistry.NOISES.register(modEventBus);
        modEventBus.addListener(CapabilityRegistry::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, CapabilityRegistry::attachItemCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(BlockEntity.class, CapabilityRegistry::attachBlockCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, CapabilityRegistry::attachEntityCapabilities);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CelestialClientConfig.SPEC, "celestialexploration-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CelestialCommonConfig.SPEC, "celestialexploration-common.toml");
        AzureLib.initialize();
        bus.addListener(e -> CelestialExploration.onKeyPress(e.getKey(), e.getAction(), e.getModifiers()));
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.f_50493_.getRegistryName());
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.MARS_MALLOW.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, MarsMallow::checkMarsMallowSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.RUST_SLIME.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, RustSlime::checkRustSlimeSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.LUNAR_SLIME.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, LunarSlime::checkLunarSlimeSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.QUICKSILVER_SLIME.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, QuicksilverSlime::checkQuicksilverSlimeSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.VISCOUS_SLIME.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, ViscousSlime::checkViscousSlimeSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.LURKER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.VOIDED.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.VOIDFELLOW.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, Monster::m_33017_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.SULFUR_CUBE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, SulfurCube::checkSulfurCubeSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.VOIDED_PIGLIN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, VoidedPiglin::checkVoidedPiglinSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityRegistry.GUST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE, Gust::checkGustSpawnRules);
        CelestialPacketHandler.init();
        event.enqueueWork(() -> {
            VillagerRegistry.registerPOIs();
            CelestialStructurePieceType.RESEARCH_TUNNEL_CORRIDOR = CelestialStructurePieceType.register("RTCorridor", ResearchTunnelPieces.ResearchTunnelCorridor::new);
            CelestialStructurePieceType.RESEARCH_TUNNEL_CROSSING = CelestialStructurePieceType.register("RTCrossing", ResearchTunnelPieces.ResearchTunnelCrossing::new);
            CelestialStructurePieceType.RESEARCH_TUNNEL_ROOM = CelestialStructurePieceType.register("RTRoom", ResearchTunnelPieces.ResearchTunnelRoom::new);
            CelestialStructurePieceType.RESEARCH_TUNNEL_STAIRS = CelestialStructurePieceType.register("RTStairs", ResearchTunnelPieces.ResearchTunnelStairs::new);
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MODID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.messageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    static void onKeyPress(int key, int action, int modifiers) {
        Keybinds.handleKeyPress(key, action);
    }

    @Nullable
    public static <T> T getCapability(ItemStack stackIn, Capability<T> capability) {
        if (stackIn == null) {
            return null;
        }
        return (T)(stackIn.getCapability(capability).isPresent() ? stackIn.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }

    @Nullable
    public static <T> T getCapability(BlockEntity entityIn, Capability<T> capability) {
        if (entityIn == null) {
            return null;
        }
        return (T)(entityIn.getCapability(capability).isPresent() ? entityIn.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }

    @Nullable
    public static <T> T getCapability(Entity entityIn, Capability<T> capability) {
        if (entityIn == null) {
            return null;
        }
        return (T)(entityIn.getCapability(capability).isPresent() ? entityIn.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }
}

