/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractPortalBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected static final VoxelShape X_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    ParticleOptions particle;

    public AbstractPortalBlock(ParticleOptions particle) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76298_).m_60978_(-1.0f).m_60910_().m_60953_(state -> 10).m_60993_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X));
        this.particle = particle;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction.Axis)state.m_61143_(AXIS)) {
            case Direction.Axis.Z -> Z_AABB;
            case Direction.Axis.X -> X_AABB;
            default -> X_AABB;
        };
    }

    public abstract boolean trySpawnPortal(LevelAccessor var1, BlockPos var2);

    public abstract void m_7892_(BlockState var1, Level var2, BlockPos var3, Entity var4);

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState stateIn, Level worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            worldIn.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12286_, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.m_123341_() + rand.nextDouble();
            double y = (double)pos.m_123342_() + rand.nextDouble();
            double z = (double)pos.m_123343_() + rand.nextDouble();
            double xSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double ySpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            double zSpeed = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!worldIn.m_8055_(pos.m_142125_()).m_60713_((Block)this) && !worldIn.m_8055_(pos.m_142126_()).m_60713_((Block)this)) {
                x = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                xSpeed = rand.nextFloat() * 2.0f * (float)j;
            } else {
                z = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                zSpeed = rand.nextFloat() * 2.0f * (float)j;
            }
            worldIn.m_7106_(this.particle, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return ItemStack.f_41583_;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
    }
}

