/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks;

import com.shim.celestialexploration.blocks.MagRailState;
import com.shim.celestialexploration.entity.vehicle.AbstractMagCart;
import com.shim.celestialexploration.entity.vehicle.IBaseMagRailBlock;
import com.shim.celestialexploration.registry.TagRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseMagRailBlock
extends Block
implements SimpleWaterloggedBlock,
IBaseMagRailBlock {
    protected static final VoxelShape FLAT_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape HALF_BLOCK_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final boolean isStraight;

    public static boolean isRail(Level level, BlockPos pos) {
        return BaseMagRailBlock.isRail(level.m_8055_(pos));
    }

    public static boolean isRail(BlockState state) {
        return state.m_204336_(TagRegistry.Blocks.MAG_RAIL) && state.m_60734_() instanceof BaseMagRailBlock;
    }

    protected BaseMagRailBlock(boolean isStraight, BlockBehaviour.Properties properties) {
        super(properties);
        this.isStraight = isStraight;
    }

    public boolean isStraight() {
        return this.isStraight;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        RailShape railshape = state.m_60713_((Block)this) ? (RailShape)state.m_61143_(this.getShapeProperty()) : null;
        RailShape railShape2 = state.m_60713_((Block)this) ? this.getRailDirection(state, blockGetter, pos, null) : null;
        return railshape != null && railshape.m_61745_() ? HALF_BLOCK_AABB : FLAT_AABB;
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return BaseMagRailBlock.m_49936_((BlockGetter)reader, (BlockPos)pos.m_7495_());
    }

    public void m_6807_(BlockState p_49408_, Level level, BlockPos pos, BlockState p_49411_, boolean p_49412_) {
        if (!p_49411_.m_60713_(p_49408_.m_60734_())) {
            this.updateState(p_49408_, level, pos, p_49412_);
        }
    }

    protected BlockState updateState(BlockState state, Level level, BlockPos pos, boolean p_49393_) {
        state = this.updateDir(level, pos, state, true);
        if (this.isStraight) {
            state.m_60690_(level, pos, (Block)this, pos, p_49393_);
        }
        return state;
    }

    public void m_6861_(BlockState p_49377_, Level p_49378_, BlockPos p_49379_, Block p_49380_, BlockPos p_49381_, boolean p_49382_) {
        if (!p_49378_.f_46443_ && p_49378_.m_8055_(p_49379_).m_60713_((Block)this)) {
            RailShape railshape = this.getRailDirection(p_49377_, (BlockGetter)p_49378_, p_49379_, null);
            if (BaseMagRailBlock.shouldBeRemoved(p_49379_, p_49378_, railshape)) {
                BaseMagRailBlock.m_49950_((BlockState)p_49377_, (Level)p_49378_, (BlockPos)p_49379_);
                p_49378_.m_7471_(p_49379_, p_49382_);
            } else {
                this.updateState(p_49377_, p_49378_, p_49379_, p_49380_);
            }
        }
    }

    private static boolean shouldBeRemoved(BlockPos pos, Level level, RailShape shape) {
        if (!BaseMagRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_())) {
            return true;
        }
        switch (shape) {
            case ASCENDING_EAST: {
                return !BaseMagRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_142126_());
            }
            case ASCENDING_WEST: {
                return !BaseMagRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_142125_());
            }
            case ASCENDING_NORTH: {
                return !BaseMagRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_142127_());
            }
            case ASCENDING_SOUTH: {
                return !BaseMagRailBlock.m_49936_((BlockGetter)level, (BlockPos)pos.m_142128_());
            }
        }
        return false;
    }

    protected void updateState(BlockState state, Level level, BlockPos pos, Block block) {
    }

    protected BlockState updateDir(Level p_49368_, BlockPos p_49369_, BlockState p_49370_, boolean p_49371_) {
        if (p_49368_.f_46443_) {
            return p_49370_;
        }
        RailShape railshape = (RailShape)p_49370_.m_61143_(this.getShapeProperty());
        return new MagRailState(p_49368_, p_49369_, p_49370_).place(p_49368_.m_46753_(p_49369_), p_49371_, railshape).getState();
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.NORMAL;
    }

    public void m_6810_(BlockState p_49384_, Level level, BlockPos pos, BlockState p_49387_, boolean p_49388_) {
        if (!p_49388_) {
            super.m_6810_(p_49384_, level, pos, p_49387_, p_49388_);
            if (this.getRailDirection(p_49384_, (BlockGetter)level, pos, null).m_61745_()) {
                level.m_46672_(pos.m_7494_(), (Block)this);
            }
            if (this.isStraight) {
                level.m_46672_(pos, (Block)this);
                level.m_46672_(pos.m_7495_(), (Block)this);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        BlockState blockstate = super.m_49966_();
        Direction direction = context.m_8125_();
        boolean flag1 = direction == Direction.EAST || direction == Direction.WEST;
        return (BlockState)((BlockState)blockstate.m_61124_(this.getShapeProperty(), (Comparable)(flag1 ? RailShape.EAST_WEST : RailShape.NORTH_SOUTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Deprecated
    public abstract Property<RailShape> getShapeProperty();

    public BlockState m_7417_(BlockState p_152151_, Direction direction, BlockState p_152153_, LevelAccessor levelAccessor, BlockPos p_152155_, BlockPos p_152156_) {
        if (((Boolean)p_152151_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(p_152155_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(p_152151_, direction, p_152153_, levelAccessor, p_152155_, p_152156_);
    }

    public FluidState m_5888_(BlockState p_152158_) {
        return (Boolean)p_152158_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_152158_);
    }

    @Override
    public boolean isFlexibleRail(BlockState state, BlockGetter world, BlockPos pos) {
        return !this.isStraight;
    }

    @Override
    public RailShape getRailDirection(BlockState state, BlockGetter world, BlockPos pos, AbstractMagCart cart) {
        return (RailShape)state.m_61143_(this.getShapeProperty());
    }
}

