/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks.blockentities;

import com.shim.celestialexploration.blocks.LoxTankBlock;
import com.shim.celestialexploration.capabilities.LoxTankCapability;
import com.shim.celestialexploration.registry.BlockEntityRegistry;
import com.shim.celestialexploration.registry.CapabilityRegistry;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class LoxTankBlockEntity
extends BlockEntity {
    private final LoxTankCapability.LoxTankHandler loxTankHandler = new LoxTankCapability.LoxTankHandler(){};
    private LazyOptional<LoxTankCapability.ILoxTank> lazyLoxHandler = LazyOptional.empty();

    public LoxTankBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.LOX_TANK_BLOCK_ENTITY.get(), worldPosition, blockState);
        this.m_6596_();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityRegistry.LOX_TANK_CAPABILITY) {
            return this.lazyLoxHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyLoxHandler = LazyOptional.of(() -> this.loxTankHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyLoxHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("loxdata", (Tag)this.loxTankHandler.getLoxData());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.loxTankHandler.setLoxData(nbt.m_128469_("loxdata"));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, LoxTankBlockEntity blockEntity) {
        if (!level.f_46443_) {
            state = (BlockState)state.m_61124_((Property)LoxTankBlock.FULLNESS, (Comparable)Integer.valueOf(blockEntity.loxTankHandler.getFullness()));
            level.m_7731_(pos, state, 3);
            LoxTankBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }
}

