/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.datagen.util;

import com.google.gson.JsonObject;
import com.shim.celestialexploration.recipes.WorkbenchSmeltingRecipe;
import com.shim.celestialexploration.registry.RecipeRegistry;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class WorkbenchSmeltingRecipeBuilder
implements RecipeBuilder {
    private final Fluid result;
    private final Ingredient ingredient;
    private final float experience;
    private final int smeltingTime;
    private final float buckets;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @javax.annotation.Nullable
    private String group;
    private final WorkbenchSmeltingRecipe.Serializer serializer;

    private WorkbenchSmeltingRecipeBuilder(FlowingFluid p_126243_, Ingredient p_126244_, float experience, int smeltingTime, float buckets, WorkbenchSmeltingRecipe.Serializer p_126247_) {
        this.result = p_126243_;
        this.ingredient = p_126244_;
        this.experience = experience;
        this.smeltingTime = smeltingTime;
        this.buckets = buckets;
        this.serializer = p_126247_;
    }

    public static WorkbenchSmeltingRecipeBuilder smelting(FlowingFluid fluid, Ingredient item, float experience, int smeltingTime, float buckets) {
        return new WorkbenchSmeltingRecipeBuilder(fluid, item, experience, smeltingTime, buckets, (WorkbenchSmeltingRecipe.Serializer)RecipeRegistry.WORKBENCH_SMELTING_SERIALIZER.get());
    }

    public RecipeBuilder m_142284_(String p_176496_, CriterionTriggerInstance p_176497_) {
        this.advancement.m_138386_(p_176496_, p_176497_);
        return this;
    }

    public RecipeBuilder m_142409_(@Nullable String p_176495_) {
        this.group = p_176495_;
        return this;
    }

    public Item m_142372_() {
        return ItemStack.f_41583_.m_41720_();
    }

    public Fluid getFluidResult() {
        return this.result;
    }

    public float getBuckets() {
        return this.buckets;
    }

    public void m_142700_(Consumer<FinishedRecipe> p_176503_, ResourceLocation p_176504_) {
        this.ensureValid(p_176504_);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_176504_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_176504_)).m_138360_(RequirementsStrategy.f_15979_);
        p_176503_.accept(new Result(p_176504_, this.group == null ? "" : this.group, this.ingredient, this.result, this.experience, this.smeltingTime, this.buckets, this.advancement, new ResourceLocation("celestialexploration", "recipes/" + p_176504_.m_135815_()), this.serializer));
    }

    private void ensureValid(ResourceLocation p_126266_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126266_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Fluid result;
        private final float experience;
        private final int smeltingTime;
        private final float buckets;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final WorkbenchSmeltingRecipe.Serializer serializer;

        public Result(ResourceLocation p_126287_, String p_126288_, Ingredient ingredient, Fluid p_126290_, float experience, int smeltingTime, float buckets, Advancement.Builder p_126293_, ResourceLocation p_126294_, WorkbenchSmeltingRecipe.Serializer p_126295_) {
            this.id = p_126287_;
            this.group = p_126288_;
            this.ingredient = ingredient;
            this.result = p_126290_;
            this.experience = experience;
            this.smeltingTime = smeltingTime;
            this.buckets = buckets;
            this.advancement = p_126293_;
            this.advancementId = p_126294_;
            this.serializer = p_126295_;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.ingredient.m_43942_());
            json.addProperty("result", Registry.f_122822_.m_7981_((Object)this.result).toString());
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("smeltingTime", (Number)this.smeltingTime);
            json.addProperty("buckets", (Number)Float.valueOf(this.buckets));
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @javax.annotation.Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @javax.annotation.Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

