/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity;

import com.google.common.collect.Lists;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.capabilities.LoxTankCapability;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.inventory.menus.SpaceshipMenu;
import com.shim.celestialexploration.packets.CelestialPacketHandler;
import com.shim.celestialexploration.packets.SpaceshipFuelTickPacket;
import com.shim.celestialexploration.packets.SpaceshipInventoryPacket;
import com.shim.celestialexploration.registry.BlockRegistry;
import com.shim.celestialexploration.registry.CapabilityRegistry;
import com.shim.celestialexploration.registry.DimensionRegistry;
import com.shim.celestialexploration.registry.EntityRegistry;
import com.shim.celestialexploration.registry.ItemRegistry;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.util.Keybinds;
import com.shim.celestialexploration.world.portal.CelestialTeleporter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.AzureLibUtil;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class Spaceship
extends Entity
implements ContainerListener,
MenuProvider,
GeoEntity {
    private static final EntityDataAccessor<Integer> DATA_ID_HURT = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_HURTDIR = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DATA_ID_DAMAGE = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_LEFT = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ID_PADDLE_RIGHT = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_ID_BUBBLE_TIME = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_ID_TIME_ON_GROUND = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_INVENTORY_COOLDOWN = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_FUEL_TICKS = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_FUEL = SynchedEntityData.m_135353_(Spaceship.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float outOfControlTicks;
    public float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private Status status;
    private static final float SPACESHIP_SPEED = (float)((Double)CelestialCommonConfig.SPACESHIP_SPEED.get()).doubleValue();
    public static final float SPACESHIP_LOW_FUEL_SPEED = SPACESHIP_SPEED - 0.15f;
    private static final float SPACESHIP_NO_FUEL_SPEED = 0.2f;
    private static final float SPACESHIP_IN_SPACE_SPEED = SPACESHIP_SPEED + 0.15f;
    protected SimpleContainer inventory;
    private static final int MAX_FUEL_TICKS = (Integer)CelestialCommonConfig.SPACESHIP_FUEL_RATE.get();
    private int teleportationCooldown = 60;
    public static int maxTimeOnGround = 15;
    private final int LOW_FUEL = 300;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean inventoryOpen = false;
    private static final RawAnimation flyingAnimation = RawAnimation.begin().thenLoop("flying");
    private static final RawAnimation idleAnimation = RawAnimation.begin().thenLoop("idle");
    private LazyOptional<?> itemHandler = null;

    public Spaceship(EntityType<? extends Spaceship> p_38290_, Level p_38291_) {
        super(p_38290_, p_38291_);
        this.f_19850_ = true;
        this.createInventory();
    }

    public Spaceship(Level p_38293_, double p_38294_, double p_38295_, double p_38296_) {
        this((EntityType<? extends Spaceship>)((EntityType)EntityRegistry.SPACESHIP.get()), p_38293_);
        this.m_6034_(p_38294_, p_38295_, p_38296_);
        this.f_19854_ = p_38294_;
        this.f_19855_ = p_38295_;
        this.f_19856_ = p_38296_;
        this.m_20242_(true);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "spaceship", 0, event -> event.setAndContinue(flyingAnimation))});
    }

    public void m_5757_(Container p_18983_) {
    }

    @org.jetbrains.annotations.Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new SpaceshipMenu(containerId, inventory, this);
    }

    public Component m_5446_() {
        return new TranslatableComponent("entity.celestialexploration.spaceship");
    }

    protected float m_6380_(Pose p_38327_, EntityDimensions p_38328_) {
        return p_38328_.f_20378_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_HURT, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_HURTDIR, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_ID_TYPE, (Object)Type.WHITE.ordinal());
        this.f_19804_.m_135372_(DATA_ID_PADDLE_LEFT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_PADDLE_RIGHT, (Object)false);
        this.f_19804_.m_135372_(DATA_ID_BUBBLE_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TIME_ON_GROUND, (Object)1);
        this.f_19804_.m_135372_(DATA_ID_INVENTORY_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_FUEL_TICKS, (Object)MAX_FUEL_TICKS);
        this.f_19804_.m_135372_(DATA_ID_FUEL, (Object)0);
    }

    public boolean m_7337_(Entity p_38376_) {
        return Spaceship.canVehicleCollide(this, p_38376_);
    }

    public static boolean canVehicleCollide(Entity p_38324_, Entity p_38325_) {
        return (p_38325_.m_5829_() || p_38325_.m_6094_()) && !p_38324_.m_20365_(p_38325_);
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected Vec3 m_7643_(Direction.Axis p_38335_, BlockUtil.FoundRectangle p_38336_) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(p_38335_, p_38336_));
    }

    public boolean m_6469_(DamageSource p_38319_, float p_38320_) {
        if (this.m_6673_(p_38319_)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            boolean flag;
            this.setHurtDir(-this.getHurtDir());
            this.setHurtTime(10);
            this.setDamage(this.getDamage() + p_38320_ * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_157808_, p_38319_.m_7639_());
            boolean bl = flag = p_38319_.m_7639_() instanceof Player && ((Player)p_38319_.m_7639_()).m_150110_().f_35937_;
            if (flag || this.getDamage() > 40.0f) {
                this.m_19998_((ItemLike)this.getDropItem());
                for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                    if (this.inventory.m_8020_(i) == null) continue;
                    this.m_19983_(this.inventory.m_8020_(i));
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public Item getDropItem() {
        return switch (this.getSpaceshipType()) {
            case Type.BLACK -> (Item)ItemRegistry.BLACK_SPACESHIP.get();
            case Type.GREY -> (Item)ItemRegistry.GREY_SPACESHIP.get();
            case Type.LIGHT_GREY -> (Item)ItemRegistry.LIGHT_GREY_SPACESHIP.get();
            case Type.WHITE -> (Item)ItemRegistry.WHITE_SPACESHIP.get();
            case Type.PINK -> (Item)ItemRegistry.PINK_SPACESHIP.get();
            case Type.MAGENTA -> (Item)ItemRegistry.MAGENTA_SPACESHIP.get();
            case Type.RED -> (Item)ItemRegistry.RED_SPACESHIP.get();
            case Type.ORANGE -> (Item)ItemRegistry.ORANGE_SPACESHIP.get();
            case Type.YELLOW -> (Item)ItemRegistry.YELLOW_SPACESHIP.get();
            case Type.LIME -> (Item)ItemRegistry.LIME_SPACESHIP.get();
            case Type.GREEN -> (Item)ItemRegistry.GREEN_SPACESHIP.get();
            case Type.CYAN -> (Item)ItemRegistry.CYAN_SPACESHIP.get();
            case Type.LIGHT_BLUE -> (Item)ItemRegistry.LIGHT_BLUE_SPACESHIP.get();
            case Type.BLUE -> (Item)ItemRegistry.BLUE_SPACESHIP.get();
            case Type.PURPLE -> (Item)ItemRegistry.PURPLE_SPACESHIP.get();
            default -> (Item)ItemRegistry.WHITE_SPACESHIP.get();
        };
    }

    public void m_6053_() {
        this.setHurtDir(-this.getHurtDir());
        this.setHurtTime(10);
        this.setDamage(this.getDamage() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    public void m_6453_(double lerpX, double lerpY, double lerpZ, float lerpYRot, float lerpXRot, int p_38304_, boolean p_38305_) {
        this.lerpX = lerpX;
        this.lerpY = lerpY;
        this.lerpZ = lerpZ;
        this.lerpYRot = lerpYRot;
        this.lerpXRot = lerpXRot;
        this.lerpSteps = 10;
    }

    @NotNull
    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    public void setTimeOnGround(int time) {
        this.f_19804_.m_135381_(DATA_ID_TIME_ON_GROUND, (Object)time);
    }

    public int getTimeOnGround() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TIME_ON_GROUND);
    }

    public void setInventoryCooldown(int time) {
        this.f_19804_.m_135381_(DATA_ID_INVENTORY_COOLDOWN, (Object)time);
    }

    public int getInventoryCooldown() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_INVENTORY_COOLDOWN);
    }

    public void setFuelTicks(int ticks) {
        this.f_19804_.m_135381_(DATA_ID_FUEL_TICKS, (Object)ticks);
    }

    public int getFuelTicks() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_FUEL_TICKS);
    }

    public void setFuelDataId(int mb) {
        this.f_19804_.m_135381_(DATA_ID_FUEL, (Object)mb);
    }

    public int getFuelDataId() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_FUEL);
    }

    public boolean isFuelDataIdLowFuel() {
        return this.getFuelDataId() <= 300;
    }

    public void decrementFuelTicks() {
        this.setFuelTicks(this.getFuelTicks() - 1);
    }

    public void m_8119_() {
        this.status = this.getStatus();
        this.outOfControlTicks = this.status != Status.UNDER_WATER && this.status != Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.f_19853_.f_46443_ && this.outOfControlTicks >= 60.0f) {
            this.m_20153_();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (!this.m_20096_()) {
            this.setTimeOnGround(0);
        } else if (this.getTimeOnGround() < maxTimeOnGround) {
            this.setTimeOnGround(this.getTimeOnGround() + 1);
        }
        super.m_8119_();
        this.tickLerp();
        if (this.m_6109_()) {
            if (this.f_19853_.f_46443_) {
                this.controlSpaceship();
                if (this.m_20160_()) {
                    if (this.m_20184_().f_82481_ != 0.0 || this.m_20184_().f_82479_ != 0.0) {
                        CelestialPacketHandler.INSTANCE.sendToServer((Object)new SpaceshipFuelTickPacket(this.m_142049_(), this.getFuelTicks()));
                    }
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        if (this.m_20160_() && this.m_6688_() instanceof Player && this.f_19853_.f_46443_ && Keybinds.OPEN_SPACESHIP_INVENTORY.m_90857_()) {
            CelestialPacketHandler.INSTANCE.sendToServer((Object)new SpaceshipInventoryPacket(this.m_142049_()));
        }
        if (!this.f_19853_.f_46443_) {
            if (this.getFuelTicks() <= 0) {
                this.useFuel();
                this.setFuelTicks(MAX_FUEL_TICKS);
            }
            this.setFuelDataId(this.getFuel());
        }
        this.m_20101_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.f_19853_.f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity : list) {
                if (entity.m_20363_((Entity)this)) continue;
                if (flag && this.m_20197_().size() < 2 && !entity.m_20159_() && entity.m_20205_() < this.m_20205_() && entity instanceof LivingEntity && !(entity instanceof WaterAnimal) && !(entity instanceof Player)) {
                    entity.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity);
            }
        }
    }

    public void teleportToSpace(int planetOriginNum) {
        if (this.teleportationCooldown == 0) {
            Entity passenger = this.m_6688_();
            Entity secondPassenger = null;
            if (this.m_20197_().size() > 1) {
                secondPassenger = (Entity)this.m_20197_().get(1);
            }
            this.displayTeleportMessage(this.teleportationCooldown, DimensionRegistry.SPACE);
            assert (passenger != null);
            ResourceKey<Level> destination = DimensionRegistry.SPACE;
            Vec3 earthLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)planetOriginNum).f_82479_ * 16.0, 135.0, CelestialUtil.getPlanetaryChunkCoordinates((int)planetOriginNum).f_82481_ * 16.0);
            this.teleportSpaceship(passenger, secondPassenger, this, destination, earthLocation);
        } else {
            --this.teleportationCooldown;
            this.displayTeleportMessage(this.teleportationCooldown, DimensionRegistry.SPACE);
        }
    }

    public static ResourceKey<Level> getTeleportLocation(Spaceship spaceship, ChunkPos spaceshipChunkPos, BlockState blockWeSee) {
        Vec3 mercuryLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)1).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)1).f_82481_);
        ChunkPos planetChunkPos = new ChunkPos((int)mercuryLocation.f_82479_, (int)mercuryLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 2, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_) && (blockWeSee.m_60713_((Block)BlockRegistry.MERCURY_STONE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.MERCURY_CORE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.MERCURY_DEEPSLATE.get()))) {
            return DimensionRegistry.MERCURY;
        }
        Vec3 venusLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)2).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)2).f_82481_);
        planetChunkPos = new ChunkPos((int)venusLocation.f_82479_, (int)venusLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 2, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_) && (blockWeSee.m_60713_((Block)BlockRegistry.VENUS_STONE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.VENUS_CORE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.VENUS_DEEPSLATE.get()) || blockWeSee.m_60713_(Blocks.f_50204_))) {
            return DimensionRegistry.VENUS;
        }
        Vec3 earthLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)3).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)3).f_82481_);
        planetChunkPos = new ChunkPos((int)earthLocation.f_82479_, (int)earthLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 4, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_)) {
            if (blockWeSee.m_60713_((Block)BlockRegistry.MOON_STONE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.MOON_CORE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.MOON_DEEPSLATE.get())) {
                return DimensionRegistry.MOON;
            }
            if (blockWeSee.m_60713_(Blocks.f_50069_) || blockWeSee.m_60713_(Blocks.f_50062_) || blockWeSee.m_60713_(Blocks.f_152550_) || blockWeSee.m_60713_(Blocks.f_50147_) || blockWeSee.m_60713_(Blocks.f_50440_) || blockWeSee.m_60713_(Blocks.f_50472_) || blockWeSee.m_60713_(Blocks.f_50211_) || blockWeSee.m_60713_(Blocks.f_50126_) || blockWeSee.m_60713_(Blocks.f_50354_) || blockWeSee.m_60713_(Blocks.f_50752_)) {
                return Level.f_46428_;
            }
        }
        Vec3 marsLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)4).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)4).f_82481_);
        planetChunkPos = new ChunkPos((int)marsLocation.f_82479_, (int)marsLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 2, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_) && (blockWeSee.m_60713_((Block)BlockRegistry.MARS_STONE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.MARS_CORE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.DRY_ICE.get()) || blockWeSee.m_60713_((Block)BlockRegistry.MARS_DEEPSLATE.get()))) {
            return DimensionRegistry.MARS;
        }
        Vec3 jupiterLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)5).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)5).f_82481_);
        planetChunkPos = new ChunkPos((int)jupiterLocation.f_82479_, (int)jupiterLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 2, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_)) {
            // empty if block
        }
        Vec3 saturnLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)6).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)6).f_82481_);
        planetChunkPos = new ChunkPos((int)saturnLocation.f_82479_, (int)saturnLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 2, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_)) {
            // empty if block
        }
        Vec3 uranusLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)7).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)7).f_82481_);
        planetChunkPos = new ChunkPos((int)uranusLocation.f_82479_, (int)uranusLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 2, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_)) {
            // empty if block
        }
        Vec3 neptuneLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((int)8).f_82479_, spaceship.m_20182_().f_82480_, CelestialUtil.getPlanetaryChunkCoordinates((int)8).f_82481_);
        planetChunkPos = new ChunkPos((int)neptuneLocation.f_82479_, (int)neptuneLocation.f_82481_);
        if (CelestialUtil.isInRectangle(planetChunkPos.f_45578_, planetChunkPos.f_45579_, 2, spaceshipChunkPos.f_45578_, spaceshipChunkPos.f_45579_)) {
            // empty if block
        }
        return null;
    }

    public void displayTeleportMessage(int teleportCooldown, ResourceKey<Level> destination) {
        Entity entity = this.m_6688_();
        if (entity instanceof Player) {
            if (teleportCooldown % 20 == 0 && teleportCooldown != 0) {
                ((Player)entity).m_5661_(Component.m_130674_((String)("Teleporting to " + destination.m_135782_().m_135815_().toUpperCase() + " in\u2026 " + teleportCooldown / 20)), true);
            } else if (teleportCooldown == 0) {
                ((Player)entity).m_5661_(Component.m_130674_((String)"Teleporting!"), true);
            }
        }
    }

    public static boolean isNearBlockOfPlanet(Spaceship spaceship, Block blockToTest) {
        int i = 30;
        for (int x = -i; x <= i; ++x) {
            for (int y = -i; y <= i; ++y) {
                for (int z = -i; z <= i; ++z) {
                    BlockPos pos = new BlockPos(spaceship.m_20182_().f_82479_ + (double)x, spaceship.m_20182_().f_82480_ + (double)y, spaceship.m_20182_().f_82481_ + (double)z);
                    BlockState state = spaceship.f_19853_.m_8055_(pos);
                    if (state.m_60734_() != blockToTest) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isNearBlockOfMoon(Spaceship spaceship, Block blockToTest) {
        int i = 18;
        for (int x = -i; x <= i; ++x) {
            for (int y = -i; y <= i; ++y) {
                for (int z = -i; z <= i; ++z) {
                    BlockPos pos = new BlockPos(spaceship.m_20182_().f_82479_ + (double)x, spaceship.m_20182_().f_82480_ + (double)y, spaceship.m_20182_().f_82481_ + (double)z);
                    BlockState state = spaceship.f_19853_.m_8055_(pos);
                    if (state.m_60734_() != blockToTest) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isTeleportHeight() {
        return this.m_20160_() && this.m_20182_().f_82480_ > (double)(this.f_19853_.m_151558_() + 10);
    }

    protected void resetTelportationCooldown() {
        this.teleportationCooldown = 80;
    }

    public int getTelportationCooldown() {
        return this.teleportationCooldown;
    }

    protected void teleportSpaceship(Entity passenger, @Nullable Entity secondPassenger, Spaceship spaceship, ResourceKey<Level> destinationDim, Vec3 locationInPlace) {
        ServerLevel destinationWorld;
        Level entityWorld;
        MinecraftServer minecraftserver;
        if (passenger.m_6072_() && (minecraftserver = (entityWorld = passenger.f_19853_).m_142572_()) != null && (destinationWorld = minecraftserver.m_129880_(destinationDim)) != null) {
            this.resetTelportationCooldown();
            if (destinationDim != DimensionRegistry.SPACE) {
                locationInPlace = new Vec3(locationInPlace.f_82479_, (double)(destinationWorld.m_151558_() - 10), locationInPlace.f_82481_);
            }
            if (!this.f_19853_.f_46443_) {
                ServerLevel level = (ServerLevel)passenger.m_183503_();
                level.m_46473_().m_6180_("placing");
                this.m_20219_(locationInPlace);
                passenger.m_20219_(locationInPlace);
                if (secondPassenger != null) {
                    secondPassenger.m_20219_(locationInPlace);
                }
                level.m_46473_().m_7238_();
            }
            Entity newPassenger = null;
            Entity newSecondPassenger = null;
            if (passenger instanceof Player) {
                passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
            } else {
                newPassenger = passenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
            }
            if (secondPassenger instanceof Player) {
                secondPassenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
            } else if (secondPassenger != null) {
                newSecondPassenger = secondPassenger.changeDimension(destinationWorld, (ITeleporter)new CelestialTeleporter(destinationWorld));
            }
            Entity newSpaceship = spaceship.changeDimension(destinationWorld, new CelestialTeleporter(destinationWorld));
            if (!this.f_19853_.f_46443_) {
                assert (newSpaceship != null);
                if (passenger instanceof ServerPlayer) {
                    passenger.m_20329_(newSpaceship);
                } else {
                    newPassenger.m_20329_(newSpaceship);
                }
                if (secondPassenger instanceof ServerPlayer) {
                    secondPassenger.m_20329_(newSpaceship);
                } else if (secondPassenger != null) {
                    newSecondPassenger.m_20329_(newSpaceship);
                }
            }
        }
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d3 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d3 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    private Status getStatus() {
        Status spaceship$status = this.isUnderwater();
        if (spaceship$status != null) {
            return spaceship$status;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_142469_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.f_19853_, (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    @Nullable
    private Status isUnderwater() {
        AABB aabb = this.m_142469_();
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    public boolean hasFuel() {
        LoxTankCapability.ILoxTank firstTankCap = this.getTankCap(this.inventory.m_8020_(0));
        LoxTankCapability.ILoxTank secondTankCap = this.getTankCap(this.inventory.m_8020_(1));
        LoxTankCapability.ILoxTank thirdTankCap = this.getTankCap(this.inventory.m_8020_(2));
        LoxTankCapability.ILoxTank fourthTankCap = this.getTankCap(this.inventory.m_8020_(3));
        if (firstTankCap != null && !firstTankCap.isEmpty()) {
            return true;
        }
        if (secondTankCap != null && !secondTankCap.isEmpty()) {
            return true;
        }
        if (thirdTankCap != null && !thirdTankCap.isEmpty()) {
            return true;
        }
        if (fourthTankCap != null) {
            return !fourthTankCap.isEmpty();
        }
        return false;
    }

    private void useFuel() {
        LoxTankCapability.ILoxTank firstTankCap = this.getTankCap(this.inventory.m_8020_(0));
        LoxTankCapability.ILoxTank secondTankCap = this.getTankCap(this.inventory.m_8020_(1));
        LoxTankCapability.ILoxTank thirdTankCap = this.getTankCap(this.inventory.m_8020_(2));
        LoxTankCapability.ILoxTank fourthTankCap = this.getTankCap(this.inventory.m_8020_(3));
        if (this.hasLowFuel()) {
            if (firstTankCap != null && !firstTankCap.isEmpty()) {
                firstTankCap.decrementAmountByFifty();
            } else if (secondTankCap != null && !secondTankCap.isEmpty()) {
                secondTankCap.decrementAmountByFifty();
            } else if (thirdTankCap != null && !thirdTankCap.isEmpty()) {
                thirdTankCap.decrementAmountByFifty();
            } else if (fourthTankCap != null && !fourthTankCap.isEmpty()) {
                fourthTankCap.decrementAmountByFifty();
            }
        } else if (firstTankCap != null && !firstTankCap.isEmpty()) {
            firstTankCap.decrementAmount();
        } else if (secondTankCap != null && !secondTankCap.isEmpty()) {
            secondTankCap.decrementAmount();
        } else if (thirdTankCap != null && !thirdTankCap.isEmpty()) {
            thirdTankCap.decrementAmount();
        } else if (fourthTankCap != null && !fourthTankCap.isEmpty()) {
            fourthTankCap.decrementAmount();
        }
    }

    public boolean hasLowFuel() {
        return this.getFuel() <= 300;
    }

    private LoxTankCapability.ILoxTank getTankCap(ItemStack tank) {
        return CelestialExploration.getCapability(tank, CapabilityRegistry.LOX_TANK_CAPABILITY);
    }

    public int getFuel() {
        int totalFuel = 0;
        LoxTankCapability.ILoxTank firstTankCap = this.getTankCap(this.inventory.m_8020_(0));
        LoxTankCapability.ILoxTank secondTankCap = this.getTankCap(this.inventory.m_8020_(1));
        LoxTankCapability.ILoxTank thirdTankCap = this.getTankCap(this.inventory.m_8020_(2));
        LoxTankCapability.ILoxTank fourthTankCap = this.getTankCap(this.inventory.m_8020_(3));
        if (firstTankCap != null && !firstTankCap.isEmpty()) {
            totalFuel += firstTankCap.getAmount();
        }
        if (secondTankCap != null && !secondTankCap.isEmpty()) {
            totalFuel += secondTankCap.getAmount();
        }
        if (thirdTankCap != null && !thirdTankCap.isEmpty()) {
            totalFuel += thirdTankCap.getAmount();
        }
        if (fourthTankCap != null && !fourthTankCap.isEmpty()) {
            totalFuel += fourthTankCap.getAmount();
        }
        return totalFuel;
    }

    public float getMaxSpeed() {
        Player player;
        Entity passenger = this.m_6688_();
        if (passenger instanceof Player && (player = (Player)passenger).m_7500_()) {
            if (((Boolean)CelestialCommonConfig.SPACESHIP_FASTER_IN_SPACE.get()).booleanValue() && this.f_19853_.m_46472_() == DimensionRegistry.SPACE) {
                return SPACESHIP_IN_SPACE_SPEED;
            }
            return SPACESHIP_SPEED;
        }
        if (this.getFuelDataId() > 0) {
            if (this.getFuelDataId() <= 300) {
                return SPACESHIP_LOW_FUEL_SPEED;
            }
            if (((Boolean)CelestialCommonConfig.SPACESHIP_FASTER_IN_SPACE.get()).booleanValue() && this.f_19853_.m_46472_() == DimensionRegistry.SPACE) {
                return SPACESHIP_IN_SPACE_SPEED;
            }
            return SPACESHIP_SPEED;
        }
        return 0.2f;
    }

    public double getCurrentSpeed() {
        return this.m_20184_().f_82479_;
    }

    public static Vec3 translateWithXRotation(@Nonnull Vec3 baseIn, double rotationIn, double xOffsetIn, double yOffsetIn, double zOffsetIn) {
        double rotation = Math.toRadians(rotationIn);
        double offsetXRotated = xOffsetIn * -Math.sin(rotation) + zOffsetIn * Math.cos(rotation);
        double offsetZRotated = xOffsetIn * Math.cos(rotation) + zOffsetIn * Math.sin(rotation);
        return new Vec3(baseIn.f_82479_ + offsetXRotated, baseIn.f_82480_ + yOffsetIn, baseIn.f_82481_ + offsetZRotated);
    }

    private void controlSpaceship() {
        if (this.m_20160_()) {
            float currentSpeed = this.getMaxSpeed();
            LivingEntity passenger = (LivingEntity)this.m_6688_();
            assert (passenger != null);
            float f = passenger.f_20902_ * currentSpeed;
            if (Keybinds.TURN_LEFT_KEY.m_90857_()) {
                this.m_146922_(passenger.m_146908_());
                this.m_5618_(passenger.m_146908_());
                this.deltaRotation -= 1.0f;
            } else if (Keybinds.TURN_RIGHT_KEY.m_90857_()) {
                this.m_146922_(passenger.m_146908_());
                this.m_5618_(passenger.m_146908_());
                this.m_5616_(passenger.m_6080_());
                this.deltaRotation += 1.0f;
            } else {
                this.deltaRotation = 0.0f;
            }
            float f1 = Keybinds.ASCEND_KEY.m_90857_() ? currentSpeed : (Keybinds.DESCEND_KEY.m_90857_() ? -1.0f * SPACESHIP_SPEED : 0.0f);
            this.m_20334_(Mth.m_14031_((float)(-this.m_146908_() * ((float)Math.PI / 180))) * f, f1, Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * f);
        }
    }

    public double m_6048_() {
        return 0.45;
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            int i;
            float f = 0.9f;
            float f1 = (float)((this.m_146910_() ? (double)0.01f : this.m_6048_()) + passenger.m_6049_());
            if (this.m_20197_().size() > 1 && (i = this.m_20197_().indexOf(passenger)) == 0) {
                f = -0.5f;
            }
            if (passenger instanceof Animal) {
                f += 0.2f;
            }
            Vec3 vec3 = new Vec3((double)f, 0.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
            passenger.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)f1, this.m_20189_() + vec3.f_82481_);
            passenger.m_146922_(passenger.m_146908_() + this.deltaRotation);
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
            passenger.m_5616_(passenger.m_6080_() + this.deltaRotation);
            this.clampRotation(passenger);
        }
    }

    public Vec3 m_7688_(LivingEntity p_38357_) {
        double d1;
        Vec3 vec3 = Spaceship.m_19903_((double)(this.m_20205_() * Mth.f_13994_), (double)p_38357_.m_20205_(), (float)p_38357_.m_146908_());
        double d0 = this.m_20185_() + vec3.f_82479_;
        BlockPos blockpos = new BlockPos(d0, this.m_142469_().f_82292_, d1 = this.m_20189_() + vec3.f_82481_);
        BlockPos blockpos1 = blockpos.m_7495_();
        if (!this.f_19853_.m_46801_(blockpos1)) {
            double d3;
            ArrayList list = Lists.newArrayList();
            double d2 = this.f_19853_.m_45573_(blockpos);
            if (DismountHelper.m_38439_((double)d2)) {
                list.add(new Vec3(d0, (double)blockpos.m_123342_() + d2, d1));
            }
            if (DismountHelper.m_38439_((double)(d3 = this.f_19853_.m_45573_(blockpos1)))) {
                list.add(new Vec3(d0, (double)blockpos1.m_123342_() + d3, d1));
            }
            for (Pose pose : p_38357_.m_7431_()) {
                for (Vec3 vec31 : list) {
                    if (!DismountHelper.m_150279_((CollisionGetter)this.f_19853_, (Vec3)vec31, (LivingEntity)p_38357_, (Pose)pose)) continue;
                    p_38357_.m_20124_(pose);
                    return vec31;
                }
            }
        }
        return super.m_7688_(p_38357_);
    }

    protected void clampRotation(Entity p_38322_) {
        p_38322_.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(p_38322_.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        p_38322_.f_19859_ += f1 - f;
        p_38322_.m_146922_(p_38322_.m_146908_() + f1 - f);
        p_38322_.m_5616_(p_38322_.m_146908_());
    }

    public void m_7340_(Entity p_38383_) {
        this.clampRotation(p_38383_);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128359_("Type", this.getSpaceshipType().getName());
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        tag.m_128365_("Items", (Tag)listtag);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            tag.m_128365_("Fuel Tank 1", (Tag)this.getTankCap(this.inventory.m_8020_(0)).getLoxData());
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            tag.m_128365_("Fuel Tank 2", (Tag)this.getTankCap(this.inventory.m_8020_(1)).getLoxData());
        }
        if (!this.inventory.m_8020_(2).m_41619_()) {
            tag.m_128365_("Fuel Tank 3", (Tag)this.getTankCap(this.inventory.m_8020_(2)).getLoxData());
        }
        if (!this.inventory.m_8020_(3).m_41619_()) {
            tag.m_128365_("Fuel Tank 4", (Tag)this.getTankCap(this.inventory.m_8020_(3)).getLoxData());
        }
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setType(Type.byName(tag.m_128461_("Type")));
        }
        ListTag listtag = tag.m_128437_("Items", 10);
        this.createInventory();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        if (tag.m_128441_("Fuel Tank 1")) {
            this.getTankCap(this.inventory.m_8020_(0)).setLoxData(tag.m_128469_("Fuel Tank 1"));
        }
        if (tag.m_128441_("Fuel Tank 2")) {
            this.getTankCap(this.inventory.m_8020_(1)).setLoxData(tag.m_128469_("Fuel Tank 2"));
        }
        if (tag.m_128441_("Fuel Tank 3")) {
            this.getTankCap(this.inventory.m_8020_(2)).setLoxData(tag.m_128469_("Fuel Tank 3"));
        }
        if (tag.m_128441_("Fuel Tank 4")) {
            this.getTankCap(this.inventory.m_8020_(3)).setLoxData(tag.m_128469_("Fuel Tank 4"));
        }
        this.updateContainerEquipment();
    }

    public void m_20258_(CompoundTag tag) {
        if (tag.m_128425_("Type", 8)) {
            this.setType(Type.byName(tag.m_128461_("Type")));
        }
        ListTag listtag = tag.m_128437_("Items", 10);
        this.createInventory();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        if (tag.m_128441_("Fuel Tank 1")) {
            this.getTankCap(this.inventory.m_8020_(0)).setLoxData(tag.m_128469_("Fuel Tank 1"));
        }
        if (tag.m_128441_("Fuel Tank 2")) {
            this.getTankCap(this.inventory.m_8020_(1)).setLoxData(tag.m_128469_("Fuel Tank 2"));
        }
        if (tag.m_128441_("Fuel Tank 3")) {
            this.getTankCap(this.inventory.m_8020_(2)).setLoxData(tag.m_128469_("Fuel Tank 3"));
        }
        if (tag.m_128441_("Fuel Tank 4")) {
            this.getTankCap(this.inventory.m_8020_(3)).setLoxData(tag.m_128469_("Fuel Tank 4"));
        }
        this.updateContainerEquipment();
        super.m_20258_(tag);
    }

    protected int getInventorySize() {
        return 31;
    }

    protected void createInventory() {
        SimpleContainer simplecontainer = this.inventory;
        this.inventory = new SimpleContainer(this.getInventorySize());
        if (simplecontainer != null) {
            simplecontainer.m_19181_((ContainerListener)this);
            int i = Math.min(simplecontainer.m_6643_(), this.inventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = simplecontainer.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.inventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.inventory));
    }

    protected boolean getFlag(int p_30648_) {
        return ((Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS) & p_30648_) != 0;
    }

    protected void setFlag(int p_30598_, boolean p_30599_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_ID_FLAGS);
        if (p_30599_) {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 | p_30598_)));
        } else {
            this.f_19804_.m_135381_(DATA_ID_FLAGS, (Object)((byte)(b0 & ~p_30598_)));
        }
    }

    protected void updateContainerEquipment() {
        if (!this.f_19853_.f_46443_) {
            this.setFlag(4, !this.inventory.m_8020_(0).m_41619_());
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_142049_()));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        if (this.outOfControlTicks < 60.0f) {
            if (!this.f_19853_.f_46443_) {
                return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7840_(double p_38307_, boolean p_38308_, BlockState p_38309_, BlockPos p_38310_) {
        if (!this.m_20159_()) {
            if (p_38308_) {
                if (this.f_19789_ > 3.0f) {
                    if (this.status != Status.ON_LAND) {
                        this.m_183634_();
                        return;
                    }
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            for (int i = 0; i < 3; ++i) {
                                this.m_19998_((ItemLike)this.getSpaceshipType().getDye());
                            }
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_) && p_38307_ < 0.0) {
                this.f_19789_ -= (float)p_38307_;
            }
        }
    }

    public void setDamage(float p_38312_) {
        this.f_19804_.m_135381_(DATA_ID_DAMAGE, (Object)Float.valueOf(p_38312_));
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_DAMAGE)).floatValue();
    }

    public void setHurtTime(int p_38355_) {
        this.f_19804_.m_135381_(DATA_ID_HURT, (Object)p_38355_);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURT);
    }

    public void setHurtDir(int p_38363_) {
        this.f_19804_.m_135381_(DATA_ID_HURTDIR, (Object)p_38363_);
    }

    public int getHurtDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_HURTDIR);
    }

    public void setType(Type p_38333_) {
        this.f_19804_.m_135381_(DATA_ID_TYPE, (Object)p_38333_.ordinal());
    }

    public Type getSpaceshipType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID_TYPE));
    }

    protected boolean m_7310_(Entity p_38390_) {
        return this.m_20197_().size() < 2 && !this.m_204029_(FluidTags.f_13131_);
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_5842_() {
        return this.status == Status.UNDER_WATER || this.status == Status.UNDER_FLOWING_WATER;
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, (float)this.lerpYRot, (float)this.lerpXRot);
        }
    }

    public static enum Type {
        BLACK(Items.f_42498_, "black"),
        GREY(Items.f_42490_, "grey"),
        LIGHT_GREY(Items.f_42491_, "light_grey"),
        WHITE(Items.f_42535_, "white"),
        PINK(Items.f_42489_, "pink"),
        MAGENTA(Items.f_42537_, "magenta"),
        RED(Items.f_42497_, "red"),
        BROWN(Items.f_42495_, "brown"),
        ORANGE(Items.f_42536_, "orange"),
        YELLOW(Items.f_42539_, "yellow"),
        LIME(Items.f_42540_, "lime"),
        GREEN(Items.f_42496_, "green"),
        CYAN(Items.f_42492_, "cyan"),
        LIGHT_BLUE(Items.f_42538_, "light_blue"),
        BLUE(Items.f_42497_, "blue"),
        PURPLE(Items.f_42497_, "purple");

        private final String name;
        private final Item dye;

        private Type(Item dye, String name) {
            this.name = name;
            this.dye = dye;
        }

        public String getName() {
            return this.name;
        }

        public Item getDye() {
            return this.dye;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int p_38431_) {
            Type[] spaceship$type = Type.values();
            if (p_38431_ < 0 || p_38431_ >= spaceship$type.length) {
                p_38431_ = 0;
            }
            return spaceship$type[p_38431_];
        }

        public static Type byName(String p_38433_) {
            Type[] spaceship$type;
            for (Type type : spaceship$type = Type.values()) {
                if (!type.getName().equals(p_38433_)) continue;
                return type;
            }
            return spaceship$type[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

