/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.shim.celestialexploration.entity.Spaceship;
import com.shim.celestialexploration.entity.model.SpaceshipModel;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import mod.azure.azurelib.cache.object.BakedGeoModel;
import mod.azure.azurelib.constant.DataTickets;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animation.AnimationState;
import mod.azure.azurelib.model.GeoModel;
import mod.azure.azurelib.renderer.GeoEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SpaceshipRenderer
extends GeoEntityRenderer<Spaceship> {
    private final Map<Spaceship.Type, Pair<ResourceLocation, SpaceshipModel>> spaceshipResources = (Map)Stream.of(Spaceship.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, p_173941_ -> Pair.of((Object)new ResourceLocation("textures/entity/spaceship/" + p_173941_.getName() + ".png"), (Object)((Object)new SpaceshipModel()))));

    public SpaceshipRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new SpaceshipModel());
    }

    public void actuallyRender(PoseStack poseStack, Spaceship animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender) {
            float motionThreshold = this.getMotionAnimThreshold((GeoAnimatable)animatable);
            Vec3 velocity = animatable.m_20184_();
            float avgVelocity = (float)(Math.abs(velocity.f_82479_) + Math.abs(velocity.f_82481_)) / 2.0f;
            AnimationState animationState = new AnimationState((GeoAnimatable)animatable, 1.0f, 1.0f, partialTick, avgVelocity >= motionThreshold);
            long instanceId = this.getInstanceId(animatable);
            animationState.setData(DataTickets.TICK, (Object)animatable.getTick((Object)animatable));
            animationState.setData(DataTickets.ENTITY, (Object)animatable);
            GeoModel var32 = this.model;
            Objects.requireNonNull(animationState);
            var32.addAdditionalStateData((GeoAnimatable)animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            this.model.handleAnimations((GeoAnimatable)animatable, instanceId, animationState);
        }
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)animatable.f_19859_, (float)animatable.m_146908_());
        float nativeScale = 1.7f;
        poseStack.m_85841_(nativeScale, nativeScale, nativeScale);
        float ageInTicks = (float)animatable.f_19797_ + partialTick;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick, nativeScale);
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

