/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.vehicle;

import com.shim.celestialexploration.entity.vehicle.AbstractMagCart;
import com.shim.celestialexploration.registry.EntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MagCartFurnace
extends AbstractMagCart {
    private static final EntityDataAccessor<Boolean> DATA_ID_FUEL = SynchedEntityData.m_135353_(MagCartFurnace.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int fuel;
    public double xPush;
    public double zPush;
    private static final Ingredient INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_});

    public MagCartFurnace(EntityType<? extends MagCartFurnace> p_38552_, Level p_38553_) {
        super(p_38552_, p_38553_);
    }

    public MagCartFurnace(Level p_38555_, double p_38556_, double p_38557_, double p_38558_) {
        super((EntityType)EntityRegistry.FURNACE_MAGCART.get(), p_38555_, p_38556_, p_38557_, p_38558_);
    }

    @Override
    public AbstractMagCart.Type getMagCartType() {
        return AbstractMagCart.Type.FURNACE;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_FUEL, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            if (this.fuel > 0) {
                --this.fuel;
            }
            if (this.fuel <= 0) {
                this.xPush = 0.0;
                this.zPush = 0.0;
            }
            this.setHasFuel(this.fuel > 0);
        }
        if (this.hasFuel() && this.f_19796_.nextInt(4) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_() + 0.8, this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected double getMaxSpeed() {
        return (this.m_20069_() ? 3.0 : 4.0) / 20.0;
    }

    @Override
    public float getMaxCartSpeedOnRail() {
        return 0.2f;
    }

    @Override
    public void destroy(DamageSource p_38560_) {
        super.destroy(p_38560_);
        if (!p_38560_.m_19372_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19998_((ItemLike)Blocks.f_50094_);
        }
    }

    @Override
    protected void moveAlongTrack(BlockPos p_38569_, BlockState p_38570_) {
        double d0 = 1.0E-4;
        double d1 = 0.001;
        super.moveAlongTrack(p_38569_, p_38570_);
        Vec3 vec3 = this.m_20184_();
        double d2 = vec3.m_165925_();
        double d3 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (d3 > 1.0E-4 && d2 > 0.001) {
            double d4 = Math.sqrt(d2);
            double d5 = Math.sqrt(d3);
            this.xPush = vec3.f_82479_ / d4 * d5;
            this.zPush = vec3.f_82481_ / d4 * d5;
        }
    }

    @Override
    protected void applyNaturalSlowdown() {
        double d0 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (d0 > 1.0E-7) {
            d0 = Math.sqrt(d0);
            this.xPush /= d0;
            this.zPush /= d0;
            Vec3 vec3 = this.m_20184_().m_82542_(0.8, 0.0, 0.8).m_82520_(this.xPush, 0.0, this.zPush);
            if (this.m_20069_()) {
                vec3 = vec3.m_82490_(0.1);
            }
            this.m_20256_(vec3);
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.98, 0.0, 0.98));
        }
        super.applyNaturalSlowdown();
    }

    public InteractionResult m_6096_(Player p_38562_, InteractionHand p_38563_) {
        InteractionResult ret = super.m_6096_(p_38562_, p_38563_);
        if (ret.m_19077_()) {
            return ret;
        }
        ItemStack itemstack = p_38562_.m_21120_(p_38563_);
        if (INGREDIENT.test(itemstack) && this.fuel + 3600 <= 32000) {
            if (!p_38562_.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.fuel += 3600;
        }
        if (this.fuel > 0) {
            this.xPush = this.m_20185_() - p_38562_.m_20185_();
            this.zPush = this.m_20189_() - p_38562_.m_20189_();
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    @Override
    protected void m_7380_(CompoundTag p_38567_) {
        super.m_7380_(p_38567_);
        p_38567_.m_128347_("PushX", this.xPush);
        p_38567_.m_128347_("PushZ", this.zPush);
        p_38567_.m_128376_("Fuel", (short)this.fuel);
    }

    @Override
    protected void m_7378_(CompoundTag p_38565_) {
        super.m_7378_(p_38565_);
        this.xPush = p_38565_.m_128459_("PushX");
        this.zPush = p_38565_.m_128459_("PushZ");
        this.fuel = p_38565_.m_128448_("Fuel");
    }

    protected boolean hasFuel() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ID_FUEL);
    }

    protected void setHasFuel(boolean p_38577_) {
        this.f_19804_.m_135381_(DATA_ID_FUEL, (Object)p_38577_);
    }

    @Override
    public BlockState getDefaultDisplayBlockState() {
        return (BlockState)((BlockState)Blocks.f_50094_.m_49966_().m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)Direction.NORTH)).m_61124_((Property)FurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.hasFuel()));
    }
}

