/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.events;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.MarsPortalBlock;
import com.shim.celestialexploration.blocks.MercuryPortalBlock;
import com.shim.celestialexploration.blocks.MoonPortalBlock;
import com.shim.celestialexploration.blocks.VenusPortalBlock;
import com.shim.celestialexploration.capabilities.ISpaceFlight;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.entity.Spaceship;
import com.shim.celestialexploration.item.armor.ThermalSpaceSuitArmorItem;
import com.shim.celestialexploration.packets.CelestialPacketHandler;
import com.shim.celestialexploration.packets.SpaceFlightPacket;
import com.shim.celestialexploration.registry.BlockRegistry;
import com.shim.celestialexploration.registry.CapabilityRegistry;
import com.shim.celestialexploration.registry.DimensionRegistry;
import com.shim.celestialexploration.registry.EffectRegistry;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.util.DimensionUtil;
import com.shim.celestialexploration.util.TeleportUtil;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="celestialexploration", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ModForgeEventBus {
    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Spaceship spaceship;
        Entity entity;
        if (event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof Spaceship && !(spaceship = (Spaceship)entity).m_146910_() && !event.getWorldObj().f_46443_) {
            event.setCanceled(spaceship.getTimeOnGround() < Spaceship.maxTimeOnGround);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Player spaceVehicle = null;
        ISpaceFlight flightCap = CelestialExploration.getCapability((Entity)player, CapabilityRegistry.SPACE_FLIGHT_CAPABILITY);
        if (flightCap != null) {
            spaceVehicle = player;
        } else if (player.m_20202_() != null && (flightCap = CelestialExploration.getCapability(player.m_20202_(), CapabilityRegistry.SPACE_FLIGHT_CAPABILITY)) != null) {
            spaceVehicle = player.m_20202_();
        }
        if (spaceVehicle != null) {
            if (flightCap.canSpaceTravel() && flightCap.isTeleportHeight((Entity)spaceVehicle) && !spaceVehicle.f_19853_.m_46472_().equals(DimensionRegistry.SPACE)) {
                ArrayList<Entity> passengers = flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle);
                TeleportUtil.displayTeleportMessage((Entity)player, flightCap.getTeleportationCooldown(), DimensionRegistry.SPACE);
                if (flightCap.getTeleportationCooldown() == 0) {
                    Vec3 teleportLocation = new Vec3(CelestialUtil.getPlanetaryChunkCoordinates((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_()).f_82479_ * 16.0, 135.0, CelestialUtil.getPlanetaryChunkCoordinates((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_()).f_82481_ * 16.0);
                    TeleportUtil.teleport((Entity)spaceVehicle, passengers, DimensionRegistry.SPACE, teleportLocation);
                    flightCap.resetTeleportationCooldown();
                } else {
                    flightCap.decrementTeleportationCooldown();
                }
            } else if (flightCap.canSpaceTravel() && spaceVehicle.f_19853_.m_46472_().equals(DimensionRegistry.SPACE)) {
                Spaceship spaceship;
                BlockHitResult hitResult = spaceVehicle instanceof Spaceship && (spaceship = (Spaceship)spaceVehicle).getMaxSpeed() >= Spaceship.SPACESHIP_LOW_FUEL_SPEED ? (BlockHitResult)player.m_19907_(35.0, 0.0f, false) : (BlockHitResult)player.m_19907_(18.0, 0.0f, false);
                BlockState blockState = spaceVehicle.f_19853_.m_8055_(hitResult.m_82425_());
                ResourceKey<Level> destination = TeleportUtil.getTeleportLocation(spaceVehicle.m_20182_(), blockState);
                ArrayList<Entity> passengers = flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle);
                CelestialExploration.LOGGER.debug("canSpaceTravel, and in space. destination: " + destination);
                if (destination != null) {
                    TeleportUtil.displayTeleportMessage((Entity)player, flightCap.getTeleportationCooldown(), destination);
                    if (flightCap.getTeleportationCooldown() == 0) {
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CelestialPacketHandler.INSTANCE.sendTo((Object)new SpaceFlightPacket(flightCap.getTeleportationCooldown()), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                        }
                        TeleportUtil.teleport((Entity)spaceVehicle, passengers, destination, spaceVehicle.m_20182_());
                        flightCap.resetTeleportationCooldown();
                    } else {
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CelestialPacketHandler.INSTANCE.sendTo((Object)new SpaceFlightPacket(flightCap.getTeleportationCooldown()), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                        }
                        flightCap.decrementTeleportationCooldown();
                    }
                } else {
                    flightCap.resetTeleportationCooldown();
                }
            }
        }
    }

    @SubscribeEvent
    public static void clickEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (event.getSide() == LogicalSide.SERVER && player != null) {
            Level level;
            BlockState block;
            if (event.getItemStack() != null && event.getItemStack().m_41720_() == Items.f_42409_) {
                Level level2 = event.getWorld();
                if (player.f_19853_.m_46472_() == DimensionRegistry.MARS || player.f_19853_.m_46472_() == DimensionRegistry.MOON || player.f_19853_.m_46472_() == DimensionRegistry.VENUS || player.f_19853_.m_46472_() == DimensionRegistry.MERCURY || player.f_19853_.m_46472_() == Level.f_46428_) {
                    for (Direction direction : Direction.Plane.VERTICAL) {
                        BlockPos framePos = event.getPos().m_142300_(direction);
                        if (((MarsPortalBlock)((Object)BlockRegistry.MARS_PORTAL.get())).trySpawnPortal((LevelAccessor)level2, framePos)) {
                            level2.m_5594_(player, framePos, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.CONSUME);
                            continue;
                        }
                        if (((MoonPortalBlock)((Object)BlockRegistry.MOON_PORTAL.get())).trySpawnPortal((LevelAccessor)level2, framePos)) {
                            level2.m_5594_(player, framePos, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.CONSUME);
                            continue;
                        }
                        if (((VenusPortalBlock)((Object)BlockRegistry.VENUS_PORTAL.get())).trySpawnPortal((LevelAccessor)level2, framePos)) {
                            level2.m_5594_(player, framePos, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            event.setCanceled(true);
                            event.setCancellationResult(InteractionResult.CONSUME);
                            continue;
                        }
                        if (!((MercuryPortalBlock)((Object)BlockRegistry.MERCURY_PORTAL.get())).trySpawnPortal((LevelAccessor)level2, framePos)) continue;
                        level2.m_5594_(player, framePos, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        event.setCanceled(true);
                        event.setCancellationResult(InteractionResult.CONSUME);
                    }
                }
            } else if (event.getItemStack() != null && event.getItemStack().m_41720_() instanceof ShovelItem && (block = (level = event.getWorld()).m_8055_(event.getHitVec().m_82425_())).m_60713_((Block)BlockRegistry.MERCURY_SAND.get())) {
                level.m_7731_(event.getHitVec().m_82425_(), ((Block)BlockRegistry.MERCURY_SAND_PATH.get()).m_49966_(), 1);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        ResourceKey dimension = event.getWorld().m_46472_();
        if (((Boolean)CelestialCommonConfig.USE_GRAVITY_EFFECTS.get()).booleanValue()) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ItemStack itemStack = player.m_6844_(EquipmentSlot.FEET);
                if (itemStack.m_41720_() instanceof ThermalSpaceSuitArmorItem && ((ThermalSpaceSuitArmorItem)itemStack.m_41720_()).isGravityBoots(itemStack)) {
                    player.m_21195_((MobEffect)EffectRegistry.LOW_GRAVITY.get());
                } else if (DimensionUtil.isLowGravityDimension((ResourceKey<Level>)dimension)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.LOW_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    player.m_21195_((MobEffect)EffectRegistry.LOW_GRAVITY.get());
                }
                if (DimensionUtil.isHighGravityDimension((ResourceKey<Level>)dimension)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.HIGH_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    player.m_21195_((MobEffect)EffectRegistry.HIGH_GRAVITY.get());
                }
            } else if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (DimensionUtil.isLowGravityDimension((ResourceKey<Level>)dimension)) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.LOW_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    livingEntity.m_21195_((MobEffect)EffectRegistry.LOW_GRAVITY.get());
                }
                if (DimensionUtil.isHighGravityDimension((ResourceKey<Level>)dimension)) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.HIGH_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    livingEntity.m_21195_((MobEffect)EffectRegistry.HIGH_GRAVITY.get());
                }
            }
        }
        if (((Boolean)CelestialCommonConfig.STORMS.get()).booleanValue()) {
            if (event.getWorld().m_46471_() && dimension.equals(DimensionRegistry.MARS)) {
                if (entity instanceof LivingEntity) {
                    livingEntity = (LivingEntity)entity;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 12000, 1, false, false, true));
                }
            } else if (!event.getWorld().m_46471_() && dimension.equals(DimensionRegistry.MARS) && entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                livingEntity.m_21195_(MobEffects.f_19597_);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityEquipmentChange(LivingEquipmentChangeEvent event) {
        if (!((Boolean)CelestialCommonConfig.USE_GRAVITY_EFFECTS.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        EquipmentSlot slot = event.getSlot();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack itemStack = event.getTo();
            if (slot != EquipmentSlot.FEET) {
                return;
            }
            if (itemStack.m_41720_() instanceof ThermalSpaceSuitArmorItem && ((ThermalSpaceSuitArmorItem)itemStack.m_41720_()).isGravityBoots(itemStack)) {
                player.m_21195_((MobEffect)EffectRegistry.LOW_GRAVITY.get());
                player.m_21195_((MobEffect)EffectRegistry.EXTRA_LOW_GRAVITY.get());
            } else {
                ResourceKey dimension = player.f_19853_.m_46472_();
                if (DimensionUtil.isLowGravityDimension((ResourceKey<Level>)dimension)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.LOW_GRAVITY.get(), 120000, 0, false, false, true));
                }
            }
        }
    }
}

