/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.integration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import com.shim.celestialexploration.blocks.blockentities.WorkbenchBlockEntity;
import com.shim.celestialexploration.recipes.WorkbenchSmeltingRecipe;
import com.shim.celestialexploration.registry.BlockRegistry;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class WorkbenchSmeltingRecipeCategory
implements IRecipeCategory<WorkbenchSmeltingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("celestialexploration", "workbench_smelting");
    public static final ResourceLocation TEXTURE = new ResourceLocation("celestialexploration", "textures/gui/workbench.png");
    private final IDrawable background;
    private final IDrawable icon;
    protected final IDrawableStatic staticFlame;
    protected final IDrawableAnimated animatedFlame;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public WorkbenchSmeltingRecipeCategory(final IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockRegistry.WORKBENCH.get()));
        this.staticFlame = helper.createDrawable(TEXTURE, 176, 0, 14, 14);
        this.animatedFlame = helper.createAnimatedDrawable(this.staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return helper.drawableBuilder(TEXTURE, 176, 14, 19, 14).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends WorkbenchSmeltingRecipe> getRecipeClass() {
        return WorkbenchSmeltingRecipe.class;
    }

    public RecipeType<WorkbenchSmeltingRecipe> getRecipeType() {
        return super.getRecipeType();
    }

    public Component getTitle() {
        return new TranslatableComponent("recipe.celestialexploration.workbench.smelting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected IDrawableAnimated getArrow(WorkbenchSmeltingRecipe recipe) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = 100;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public void draw(WorkbenchSmeltingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        this.animatedFlame.draw(poseStack, 14, 36);
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(poseStack, 30, 36);
        this.drawCookTime(recipe, poseStack, 58);
    }

    protected void drawExperience(WorkbenchSmeltingRecipe recipe, PoseStack poseStack, int y) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            TranslatableComponent experienceString = new TranslatableComponent("gui.jei.category.smelting.experience", new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            fontRenderer.m_92889_(poseStack, (Component)experienceString, (float)(this.background.getWidth() - stringWidth - 12), (float)y, -8355712);
        }
    }

    protected void drawCookTime(WorkbenchSmeltingRecipe recipe, PoseStack poseStack, int y) {
        int cookTime = recipe.getCookingTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            TranslatableComponent timeString = new TranslatableComponent("gui.jei.category.smelting.time.seconds", new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            fontRenderer.m_92889_(poseStack, (Component)timeString, (float)(this.background.getWidth() - stringWidth - 12), (float)y, -8355712);
        }
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull WorkbenchSmeltingRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 13, 17).addIngredients((Ingredient)recipe.m_7527_().get(0));
        FluidStack fluid = new FluidStack(recipe.getResultFluid(), WorkbenchBlockEntity.maxFluidLevel);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 52, 17).setFluidRenderer(WorkbenchBlockEntity.maxFluidLevel, true, 9, 52).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluid);
    }
}

