/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.inventory.containers.WorkbenchCraftingContainer;
import com.shim.celestialexploration.recipes.WorkbenchCraftingRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WorkbenchResultSlot
extends Slot {
    private final WorkbenchCraftingContainer craftSlots;
    private final Player player;
    private int removeCount;

    public WorkbenchResultSlot(Player p_40166_, WorkbenchCraftingContainer p_40167_, Container p_40168_, int p_40169_, int p_40170_, int p_40171_) {
        super(p_40168_, p_40169_, p_40170_, p_40171_);
        this.player = p_40166_;
        this.craftSlots = p_40167_;
    }

    public boolean m_5857_(ItemStack p_40178_) {
        return false;
    }

    public ItemStack m_6201_(int p_40173_) {
        if (this.m_6657_()) {
            this.removeCount += Math.min(p_40173_, this.m_7993_().m_41613_());
        }
        CelestialExploration.LOGGER.debug("workbenchResultSlot: remove");
        return super.m_6201_(p_40173_);
    }

    protected void m_7169_(ItemStack p_40180_, int p_40181_) {
        this.removeCount += p_40181_;
        this.m_5845_(p_40180_);
    }

    protected void m_6405_(int p_40183_) {
        this.removeCount += p_40183_;
    }

    protected void m_5845_(ItemStack itemStack) {
        CelestialExploration.LOGGER.debug("checkTakeAchievements");
        CelestialExploration.LOGGER.debug("checkTakeAchievements, player is:" + this.player + ", container is: " + this.f_40218_);
        if (this.removeCount > 0) {
            itemStack.m_41678_(this.player.f_19853_, this.player, this.removeCount);
            ForgeEventFactory.firePlayerCraftingEvent((Player)this.player, (ItemStack)itemStack, (Container)this.craftSlots);
        }
        if (this.f_40218_ instanceof RecipeHolder) {
            ((RecipeHolder)this.f_40218_).m_8015_(this.player);
        }
        this.removeCount = 0;
    }

    public void popExperience(ServerPlayer player, WorkbenchCraftingRecipe recipe) {
        CelestialExploration.LOGGER.debug("popExperience");
        Object2IntOpenHashMap recipesUsed = new Object2IntOpenHashMap();
        ResourceLocation resourcelocation = recipe.m_6423_();
        recipesUsed.addTo((Object)resourcelocation, 1);
        for (Object2IntMap.Entry entry : recipesUsed.object2IntEntrySet()) {
            player.f_19853_.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe1 -> WorkbenchResultSlot.createExperience(player.m_183503_(), player.m_20182_(), entry.getIntValue(), ((WorkbenchCraftingRecipe)recipe1).getExperience()));
        }
    }

    private static void createExperience(ServerLevel level, Vec3 position, int p_155001_, float p_155002_) {
        CelestialExploration.LOGGER.debug("createExperience, int: " + p_155001_ + "float: " + p_155002_);
        int i = Mth.m_14143_((float)((float)p_155001_ * p_155002_));
        float f = Mth.m_14187_((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        CelestialExploration.LOGGER.debug("createExperience, i:" + i);
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)i);
    }

    public void m_142406_(Player player, ItemStack p_150639_) {
        this.m_5845_(p_150639_);
        ForgeHooks.setCraftingPlayer((Player)player);
        NonNullList nonnulllist = player.f_19853_.m_7465_().m_44069_((RecipeType)WorkbenchCraftingRecipe.Type.INSTANCE, (Container)this.craftSlots, player.f_19853_);
        ForgeHooks.setCraftingPlayer(null);
        Optional recipe = player.f_19853_.m_7465_().m_44015_((RecipeType)WorkbenchCraftingRecipe.Type.INSTANCE, (Container)this.craftSlots, player.f_19853_);
        if (recipe.isPresent()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.popExperience(serverPlayer, (WorkbenchCraftingRecipe)recipe.get());
            }
            float buckets = ((WorkbenchCraftingRecipe)recipe.get()).getBuckets();
            int millibuckets = (int)((double)buckets * 1000.0);
            this.craftSlots.getTank().drain(millibuckets, IFluidHandler.FluidAction.EXECUTE);
            this.craftSlots.setFluidAmount(this.craftSlots.getTank().getFluidAmount());
            for (int i = 0; i < nonnulllist.size(); ++i) {
                ItemStack itemstack = this.craftSlots.m_8020_(i);
                ItemStack itemstack1 = (ItemStack)nonnulllist.get(i);
                if (!itemstack.m_41619_()) {
                    this.craftSlots.m_7407_(i, 1);
                    itemstack = this.craftSlots.m_8020_(i);
                }
                if (itemstack1.m_41619_()) continue;
                if (itemstack.m_41619_()) {
                    this.craftSlots.m_6836_(i, itemstack1);
                    continue;
                }
                if (ItemStack.m_41746_((ItemStack)itemstack, (ItemStack)itemstack1) && ItemStack.m_41658_((ItemStack)itemstack, (ItemStack)itemstack1)) {
                    itemstack1.m_41769_(itemstack.m_41613_());
                    this.craftSlots.m_6836_(i, itemstack1);
                    continue;
                }
                if (this.player.m_150109_().m_36054_(itemstack1)) continue;
                this.player.m_36176_(itemstack1, false);
            }
        }
    }
}

