/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.inventory.menus;

import com.shim.celestialexploration.blocks.blockentities.OxygenCompressorBlockEntity;
import com.shim.celestialexploration.inventory.FuelSlot;
import com.shim.celestialexploration.inventory.OxygenTankSlot;
import com.shim.celestialexploration.registry.BlockRegistry;
import com.shim.celestialexploration.registry.MenuRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class OxygenCompressorMenu
extends AbstractContainerMenu {
    private final OxygenCompressorBlockEntity blockEntity;
    private final Level level;
    private final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 5;

    public OxygenCompressorMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(4));
    }

    public OxygenCompressorMenu(int containerId, Inventory inv, BlockEntity entity, ContainerData data) {
        super((MenuType)MenuRegistry.OXYGEN_COMPRESSOR_MENU.get(), containerId);
        OxygenCompressorMenu.m_38869_((Container)inv, (int)6);
        this.blockEntity = (OxygenCompressorBlockEntity)entity;
        this.level = inv.f_35978_.f_19853_;
        this.data = data;
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            this.m_38897_((Slot)new FuelSlot((IItemHandler)handler, 0, 31, 51));
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 1, 106, 23));
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 2, 130, 23));
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 3, 106, 47));
            this.m_38897_((Slot)new OxygenTankSlot((IItemHandler)handler, 4, 130, 47));
        });
        this.m_38884_(data);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 41, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 41) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return OxygenCompressorMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)BlockRegistry.OXYGEN_COMPRESSOR.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getScaledProgress(int progressSize) {
        int progress = this.data.m_6413_(0);
        int maxProgress = this.data.m_6413_(1);
        return maxProgress != 0 && progress != 0 ? progress * progressSize / maxProgress : 0;
    }

    public int getBurnProgress() {
        int i = this.data.m_6413_(2);
        int j = this.data.m_6413_(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getLitProgress() {
        int i = this.data.m_6413_(3);
        int j = this.data.m_6413_(2);
        if (i == 0) {
            i = 200;
        }
        return j * 13 / i;
    }

    public boolean isLit() {
        return this.data.m_6413_(2) > 0;
    }

    public boolean isBurning() {
        return this.data.m_6413_(0) > 0;
    }
}

